/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.ldap.LDAPManager;
import org.datanucleus.store.ldap.LDAPTransactionEventListener;
import org.datanucleus.store.ldap.fieldmanager.FetchFieldManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPManager.class.getClassLoader());
    public static final String[] NO_ATTRIBUTES = new String[0];

    public static StateManager getStateManagerForObject(Object object, ObjectManager om, boolean persist) {
        StateManager smpc = om.findStateManager(object);
        if (smpc == null && persist) {
            int objectType = 0;
            om.persistObjectInternal(object, null, null, -1, objectType);
            smpc = om.findStateManager(object);
        }
        return smpc;
    }

    public static boolean isHierarchicalMappedAtChild(StateManager sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        String pattern = LDAPUtils.getDistinguishedNamePattern(cmd);
        String parentFieldName = LDAPUtils.getParentFieldName(pattern);
        return parentFieldName != null;
    }

    public static boolean isHierarchicalMapped(AbstractClassMetaData childCmd, AbstractClassMetaData potentialParentCmd) {
        return LDAPUtils.isParentOfHierarchicalMapping(potentialParentCmd, childCmd);
    }

    public static boolean isParentOfHierarchicalMapping(AbstractClassMetaData potentialParentCmd, AbstractClassMetaData childCmd) {
        String pattern = LDAPUtils.getDistinguishedNamePattern(childCmd);
        String parentFieldName = LDAPUtils.getParentFieldName(pattern);
        if (parentFieldName != null) {
            AbstractMemberMetaData parentFieldMmd = childCmd.getMetaDataForMember(parentFieldName);
            AbstractClassMetaData parentFieldTypeCmd = LDAPUtils.getEffectiveClassMetaData(parentFieldMmd);
            return parentFieldTypeCmd == potentialParentCmd;
        }
        return false;
    }

    public static AbstractClassMetaData getEffectiveClassMetaData(AbstractMemberMetaData mmd) {
        AbstractClassMetaData collectionFieldTypeCmd;
        ClassLoaderResolver clr = mmd.getMetaDataManager().getOMFContext().getClassLoaderResolver(null);
        AbstractClassMetaData fieldTypeCmd = mmd.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
        if (fieldTypeCmd != null) {
            return fieldTypeCmd;
        }
        AbstractClassMetaData abstractClassMetaData = collectionFieldTypeCmd = mmd.getCollection() != null ? mmd.getCollection().getElementClassMetaData() : null;
        if (collectionFieldTypeCmd != null) {
            return collectionFieldTypeCmd;
        }
        return null;
    }

    public static LdapName getDistinguishedNameForObject(StateManager sm) {
        LdapName dn;
        block13: {
            if (sm.getAssociatedValue((Object)"dn") != null) {
                return (LdapName)((LdapName)sm.getAssociatedValue((Object)"dn")).clone();
            }
            AbstractClassMetaData cmd = sm.getClassMetaData();
            Object value = sm.provideField(cmd.getPKMemberPositions()[0]);
            AbstractMemberMetaData rdnMmd = cmd.getMetaDataForManagedMemberAtPosition(cmd.getPKMemberPositions()[0]);
            String rdnKey = LDAPUtils.getAttributeNameForField(rdnMmd);
            try {
                String pattern = LDAPUtils.getDistinguishedNamePattern(cmd);
                Rdn rdn = new Rdn(rdnKey, value);
                if (LDAPUtils.isHierarchicalMappedAtChild(sm)) {
                    LdapName parentDn;
                    block12: {
                        String parentFieldName = LDAPUtils.getParentFieldName(pattern);
                        AbstractMemberMetaData parentFieldMmd = cmd.getMetaDataForMember(parentFieldName);
                        Object parentFieldValue = sm.provideField(parentFieldMmd.getAbsoluteFieldNumber());
                        if (parentFieldValue != null) {
                            StateManager parentSm = sm.getObjectManager().findStateManager(parentFieldValue);
                            parentDn = LDAPUtils.getDistinguishedNameForObject(parentSm);
                        } else {
                            AbstractClassMetaData parentFieldTypeCmd = sm.getMetaDataManager().getMetaDataForClass(parentFieldMmd.getType(), sm.getObjectManager().getClassLoaderResolver());
                            LdapName base = LDAPUtils.getDistinguishedNameForClass(parentFieldTypeCmd);
                            String ocFilter = LDAPUtils.getObjectClassesFilterForObject(cmd);
                            String rdnFilter = "(" + rdnKey + "=" + value + ")";
                            String filter = ocFilter != null ? "(&" + ocFilter + rdnFilter + ")" : rdnFilter;
                            SearchControls searchControls = LDAPUtils.getSearchControls(cmd);
                            ObjectManager om = sm.getObjectManager();
                            ManagedConnection mconn = om.getStoreManager().getConnection(om);
                            try {
                                DirContext ctx = (DirContext)mconn.getConnection();
                                NamingEnumeration<SearchResult> enumeration = ctx.search((Name)base, filter, searchControls);
                                if (enumeration.hasMoreElements()) {
                                    SearchResult sr = (SearchResult)enumeration.nextElement();
                                    String srName = sr.getNameInNamespace();
                                    LdapName srDn = new LdapName(srName);
                                    parentDn = LDAPUtils.getParentDistingueshedName(srDn, pattern);
                                    break block12;
                                }
                                throw new NucleusObjectNotFoundException("No distinguished name found for object " + sm.toString());
                            }
                            catch (NamingException e) {
                                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                            }
                            finally {
                                mconn.release();
                            }
                        }
                    }
                    dn = LDAPUtils.composeDistinguishedName(parentDn, rdn, pattern);
                    break block13;
                }
                dn = new LdapName(pattern);
                dn.add(rdn);
            }
            catch (InvalidNameException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        sm.setAssociatedValue((Object)"dn", (Object)dn);
        return dn;
    }

    public static SearchControls getSearchControls(AbstractClassMetaData cmd) {
        SearchControls searchControls = new SearchControls();
        String pattern = LDAPUtils.getDistinguishedNamePattern(cmd);
        String parentFieldName = LDAPUtils.getParentFieldName(pattern);
        if (parentFieldName != null) {
            searchControls.setSearchScope(2);
        }
        return searchControls;
    }

    public static LdapName getDistinguishedNameForClass(AbstractClassMetaData cmd) throws InvalidNameException {
        LdapName dn;
        String pattern = LDAPUtils.getDistinguishedNamePattern(cmd);
        String parentFieldName = LDAPUtils.getParentFieldName(pattern);
        if (parentFieldName != null) {
            AbstractMemberMetaData parentMmd = cmd.getMetaDataForMember(parentFieldName);
            ClassLoaderResolver clr = cmd.getMetaDataManager().getOMFContext().getClassLoaderResolver(null);
            AbstractClassMetaData parentFieldCmd = cmd.getMetaDataManager().getMetaDataForClass(parentMmd.getType(), clr);
            LdapName parentDn = LDAPUtils.getDistinguishedNameForClass(parentFieldCmd);
            dn = LDAPUtils.composeDistinguishedName(parentDn, null, pattern);
        } else {
            dn = new LdapName(pattern);
        }
        return dn;
    }

    public static String getDistinguishedNamePattern(AbstractClassMetaData cmd) {
        String name = null;
        if (cmd != null && cmd.hasExtension("dn")) {
            name = cmd.getValueForExtension("dn");
        } else if (cmd != null && cmd.getTable() != null) {
            name = cmd.getTable();
        } else {
            throw new NucleusDataStoreException("Missing 'dn' extension or 'table' attribute for class " + cmd.getName());
        }
        return name;
    }

    public static String getEmptyValue(AbstractMemberMetaData mmd) {
        return mmd.getValueForExtension("empty-value");
    }

    public static String getParentFieldName(String pattern) {
        if (pattern != null) {
            int left = pattern.indexOf(123);
            int right = pattern.indexOf(125);
            if (left > -1 && right > left) {
                String fieldName = pattern.substring(left + 1, right);
                return fieldName;
            }
        }
        return null;
    }

    public static LdapName getParentDistingueshedName(LdapName dn, String pattern) {
        LdapName suffix = LDAPUtils.getSuffix(pattern);
        LdapName parent = (LdapName)dn.getPrefix(dn.size() - suffix.size() - 1);
        return parent;
    }

    public static LdapName composeDistinguishedName(LdapName parentDn, Rdn rdn, String pattern) throws InvalidNameException {
        LdapName dn = new LdapName(parentDn.getRdns());
        LdapName suffix = LDAPUtils.getSuffix(pattern);
        dn.addAll(suffix.getRdns());
        if (rdn != null) {
            dn.add(rdn);
        }
        return dn;
    }

    public static LdapName getSuffix(String pattern) {
        try {
            int left = pattern.indexOf(123);
            String suffix = pattern.substring(0, left);
            LdapName suffixDn = new LdapName(suffix);
            if (suffixDn.size() > 0 && suffixDn.getRdn(0).size() == 0) {
                suffixDn.remove(0);
            }
            return suffixDn;
        }
        catch (InvalidNameException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static Class getConcreteCollectionType(Class instanceType) {
        if (instanceType.isInterface()) {
            if (List.class.isAssignableFrom(instanceType)) {
                instanceType = ArrayList.class;
            } else if (Set.class.isAssignableFrom(instanceType)) {
                instanceType = HashSet.class;
            }
        }
        return instanceType;
    }

    public static Object getObjectByAttributes(ObjectManager om, Class cls, String dnAsString) {
        try {
            final AbstractClassMetaData fieldTypeCmd = om.getMetaDataManager().getMetaDataForClass(cls, om.getClassLoaderResolver());
            LdapName dn = new LdapName(dnAsString);
            Rdn rdn = dn.getRdn(dn.size() - 1);
            final Attributes attrs = rdn.toAttributes();
            return om.findObjectUsingAID(cls, new FieldValues(){

                public void fetchFields(StateManager sm) {
                    sm.replaceFields(fieldTypeCmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                }

                public void fetchNonLoadedFields(StateManager sm) {
                    sm.replaceNonLoadedFields(fieldTypeCmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                }

                public FetchPlan getFetchPlanForLoading() {
                    return null;
                }
            }, false, true);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static void markForPersisting(Object pc, ObjectManager om) {
        LDAPTransactionEventListener listener = LDAPUtils.getTransactionEventListener(om);
        listener.addObjectToPersist(pc);
    }

    public static void markForRename(Object pc, ObjectManager om, LdapName oldDn, LdapName newDn) {
        LDAPTransactionEventListener listener = LDAPUtils.getTransactionEventListener(om);
        listener.addObjectToRename(pc, oldDn, newDn);
    }

    public static void markForDeletion(Object pc, ObjectManager om) {
        LDAPTransactionEventListener listener = LDAPUtils.getTransactionEventListener(om);
        listener.addObjectToDelete(pc);
    }

    public static void unmarkForDeletion(Object pc, ObjectManager om) {
        LDAPTransactionEventListener listener = LDAPUtils.getTransactionEventListener(om);
        listener.removeObjectToDelete(pc);
    }

    private static LDAPTransactionEventListener getTransactionEventListener(ObjectManager om) {
        Transaction transaction = om.getTransaction();
        LDAPTransactionEventListener listener = (LDAPTransactionEventListener)transaction.getOptions().get("LDAPTransactionEventListener");
        if (listener == null) {
            listener = new LDAPTransactionEventListener(om);
            transaction.getOptions().put("LDAPTransactionEventListener", listener);
            transaction.addTransactionEventListener((TransactionEventListener)listener);
        }
        return listener;
    }

    public static String getAttributeNameForField(AbstractMemberMetaData mmd) {
        String name = mmd.getName();
        if (mmd.hasExtension("dn")) {
            name = mmd.getValueForExtension("dn");
        } else if (mmd.hasExtension("attribute")) {
            name = mmd.getValueForExtension("attribute");
        } else if (mmd.getColumn() != null) {
            name = mmd.getColumn();
        }
        return name;
    }

    public static Set<String> getObjectClassesForObject(AbstractClassMetaData cmd) {
        LinkedHashSet<String> ocs = new LinkedHashSet<String>();
        if (cmd.hasExtension("objectClass")) {
            ocs.addAll(Arrays.asList(cmd.getValuesForExtension("objectClass")));
        } else if (cmd.getSchema() != null) {
            ocs.addAll(Arrays.asList(MetaDataUtils.getInstance().getValuesForCommaSeparatedAttribute(cmd.getSchema())));
        } else {
            throw new NucleusDataStoreException("Missing 'objectClass' extension or 'schema' attribute for class " + cmd.getName());
        }
        return ocs;
    }

    public static String getObjectClassesFilterForObject(AbstractClassMetaData cmd) {
        Set<String> objectClasses = LDAPUtils.getObjectClassesForObject(cmd);
        if (objectClasses.isEmpty()) {
            return null;
        }
        StringBuffer filter = new StringBuffer();
        if (objectClasses.size() > 1) {
            filter.append("(&");
            for (String oc : objectClasses) {
                filter.append("(objectClass=");
                filter.append(oc);
                filter.append(")");
            }
            filter.append(")");
        } else {
            filter.append("(objectClass=");
            filter.append(objectClasses.iterator().next());
            filter.append(")");
        }
        return filter.toString();
    }

    public static List<Object> getObjectsOfCandidateType(ObjectManager om, ManagedConnection mconn, QueryCompilation compilation, Class candidateClass, boolean subclasses, boolean ignoreCache, boolean inMemory) {
        String[] subclassNames;
        DirContext ctx = (DirContext)mconn.getConnection();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
        List<Object> results = LDAPUtils.getObjectsOfCandidateType(om, ctx, compilation, acmd, ignoreCache, inMemory);
        if (subclasses && (subclassNames = om.getMetaDataManager().getSubclassesForClass(candidateClass.getName(), true)) != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(subclassNames[i], clr);
                results.addAll(LDAPUtils.getObjectsOfCandidateType(om, ctx, compilation, cmd, ignoreCache, inMemory));
            }
        }
        return results;
    }

    private static List<Object> getObjectsOfCandidateType(ObjectManager om, DirContext ctx, QueryCompilation compilation, final AbstractClassMetaData acmd, boolean ignoreCache, boolean inMemory) {
        ArrayList<Object> results;
        block7: {
            results = new ArrayList<Object>();
            try {
                ClassLoaderResolver clr = om.getClassLoaderResolver();
                SearchControls searchControls = LDAPUtils.getSearchControls(acmd);
                String objectClassFilter = LDAPUtils.getObjectClassesFilterForObject(acmd);
                if (objectClassFilter == null) break block7;
                NamingEnumeration<SearchResult> enumeration = null;
                if (!inMemory) {
                    try {
                        String className = "org.datanucleus.store.ldap.query.QueryToLDAPFilterMapper";
                        Class cls = clr.classForName(className);
                        Method method = ClassUtils.getMethodForClass((Class)cls, (String)"compile", null);
                        Constructor constr = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[]{QueryCompilation.class, AbstractClassMetaData.class});
                        String filter = (String)method.invoke(constr.newInstance(compilation, acmd), (Object[])null);
                        enumeration = ctx.search((Name)LDAPUtils.getDistinguishedNameForClass(acmd), filter, searchControls);
                    }
                    catch (Throwable e) {
                        NucleusLogger.QUERY.warn((Object)LOCALISER.msg("LDAP.Query.NativeQueryFailed"));
                        inMemory = true;
                    }
                }
                if (inMemory) {
                    enumeration = ctx.search((Name)LDAPUtils.getDistinguishedNameForClass(acmd), objectClassFilter, searchControls);
                }
                while (enumeration.hasMoreElements()) {
                    SearchResult sr = (SearchResult)enumeration.nextElement();
                    final Attributes attrs = sr.getAttributes();
                    results.add(om.findObjectUsingAID(clr.classForName(acmd.getFullClassName()), new FieldValues(){

                        public void fetchFields(StateManager sm) {
                            sm.replaceFields(acmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                            sm.replaceFields(acmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                        }

                        public void fetchNonLoadedFields(StateManager sm) {
                            sm.replaceNonLoadedFields(acmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, ignoreCache, true));
                }
            }
            catch (NamingException ne) {
                ne.printStackTrace();
            }
        }
        return results;
    }
}

