/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.ldap.LDAPUtils;

public class LDAPTransactionEventListener
implements TransactionEventListener {
    Map<Object, LdapName> objectsToRenameOldDn = new HashMap<Object, LdapName>();
    Map<Object, LdapName> objectsToRenameNewDn = new HashMap<Object, LdapName>();
    Set<Object> objectsToPersist = new HashSet<Object>();
    Set<Object> objectsToDelete = new HashSet<Object>();
    Set<Object> objectsNotToDelete = new HashSet<Object>();
    ObjectManager om;

    public LDAPTransactionEventListener(ObjectManager om) {
        this.om = om;
    }

    public void addObjectToDelete(Object pc) {
        if (!this.objectsNotToDelete.contains(pc)) {
            this.objectsToDelete.add(pc);
        }
    }

    public void removeObjectToDelete(Object pc) {
        this.objectsToDelete.remove(pc);
        this.objectsNotToDelete.add(pc);
    }

    public void addObjectToRename(Object pc, LdapName oldDn, LdapName newDn) {
        this.objectsToRenameOldDn.put(pc, oldDn);
        this.objectsToRenameNewDn.put(pc, newDn);
    }

    public void addObjectToPersist(Object pc) {
        this.objectsToPersist.add(pc);
    }

    public void transactionCommitted() {
    }

    public void transactionEnded() {
    }

    public void transactionFlushed() {
    }

    public void transactionPreCommit() {
        ManagedConnection mconn = this.om.getStoreManager().getConnection(this.om);
        try {
            DirContext ctx = (DirContext)mconn.getConnection();
            for (Object pc : this.objectsToRenameOldDn.keySet()) {
                LdapName oldDn = this.objectsToRenameOldDn.get(pc);
                LdapName newDn = this.objectsToRenameNewDn.get(pc);
                ctx.rename(oldDn, newDn);
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
        while (!this.objectsToPersist.isEmpty()) {
            HashSet<Object> insert = new HashSet<Object>(this.objectsToPersist);
            for (Object pc : insert) {
                LDAPUtils.getStateManagerForObject(pc, this.om, true);
            }
            this.objectsToPersist.removeAll(insert);
        }
        for (Object pc : this.objectsToDelete) {
            StateManager sm = LDAPUtils.getStateManagerForObject(pc, this.om, false);
            sm.deletePersistent();
        }
    }

    public void transactionPreRollBack() {
    }

    public void transactionRolledBack() {
    }

    public void transactionStarted() {
    }
}

