/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.util.Collection;
import java.util.Set;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.AbstractStateManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.ldap.LDAPManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.FetchFieldManager;
import org.datanucleus.store.ldap.fieldmanager.InsertFieldManager;
import org.datanucleus.store.ldap.fieldmanager.UpdateFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class LDAPPersistenceHandler
implements StorePersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPManager.class.getClassLoader());
    protected final LDAPManager storeMgr;

    public LDAPPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (LDAPManager)storeMgr;
    }

    public void close() {
    }

    public void insertObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (LDAPUtils.isHierarchicalMappedAtChild(sm)) {
            String pattern = LDAPUtils.getDistinguishedNamePattern(cmd);
            String parentFieldName = LDAPUtils.getParentFieldName(pattern);
            AbstractMemberMetaData parentFieldMmd = cmd.getMetaDataForMember(parentFieldName);
            Object parentFieldValue = sm.provideField(parentFieldMmd.getAbsoluteFieldNumber());
            if (parentFieldValue != null) {
                LDAPUtils.getStateManagerForObject(parentFieldValue, sm.getObjectManager(), true);
            } else {
                throw new NucleusUserException(LOCALISER.msg("LDAP.Insert.MissingParentReference", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                this.locateObject(sm);
                throw new NucleusUserException(LOCALISER.msg("LDAP.Insert.ObjectWithIdAlreadyExists", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            catch (NucleusObjectNotFoundException onfe) {}
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusUserException(LOCALISER.msg("LDAP.DatastoreID"));
        }
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.Insert.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            BasicAttributes attrs = new BasicAttributes();
            int[] fieldNumbers = sm.getClassMetaData().getAllMemberPositions();
            sm.provideFields(fieldNumbers, (FieldManager)new InsertFieldManager(sm, attrs));
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(sm);
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            Set<String> objectClasses = LDAPUtils.getObjectClassesForObject(sm.getClassMetaData());
            for (String oc : objectClasses) {
                objectClass.add(oc);
            }
            attrs.put(objectClass);
            ctx.bind(dn, null, (Attributes)attrs);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementInsertCount();
            }
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("LDAP.Insert.ObjectPersisted", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                AbstractClassMetaData cmd = sm.getClassMetaData();
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.Update.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            AbstractClassMetaData cmd = sm.getClassMetaData();
            if (LDAPUtils.isHierarchicalMappedAtChild(sm)) {
                String pattern = LDAPUtils.getDistinguishedNamePattern(cmd);
                String parentFieldName = LDAPUtils.getParentFieldName(pattern);
                AbstractMemberMetaData parentFieldMmd = cmd.getMetaDataForMember(parentFieldName);
                int absoluteFieldNumber = parentFieldMmd.getAbsoluteFieldNumber();
                for (int i : fieldNumbers) {
                    if (i != absoluteFieldNumber) continue;
                    Object parentFieldValue = sm.provideField(absoluteFieldNumber);
                    if (parentFieldValue == null) break;
                    LdapName oldDn = LDAPUtils.getDistinguishedNameForObject(sm);
                    sm.setAssociatedValue((Object)"dn", null);
                    LdapName newDn = LDAPUtils.getDistinguishedNameForObject(sm);
                    if (oldDn.equals(newDn)) break;
                    LDAPUtils.markForRename(sm.getObject(), sm.getObjectManager(), oldDn, newDn);
                    LDAPUtils.unmarkForDeletion(sm.getObject(), sm.getObjectManager());
                    break;
                }
            }
            BasicAttributes attrs = new BasicAttributes();
            sm.provideFields(fieldNumbers, (FieldManager)new UpdateFieldManager(sm, attrs));
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(sm);
            if (attrs.size() > 0) {
                ctx.modifyAttributes(dn, 2, (Attributes)attrs);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        sm.loadUnloadedFields();
        sm.provideFields(sm.getClassMetaData().getAllMemberPositions(), (FieldManager)new DeleteFieldManager(sm));
        this.deleteDnReferences(sm);
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.Delete.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            ctx.unbind(LDAPUtils.getDistinguishedNameForObject(sm));
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementDeleteCount();
            }
        }
        catch (ContextNotEmptyException cnee) {
            try {
                DirContext ctx = (DirContext)mconn.getConnection();
                this.deleteChildrenRecursive(ctx, LDAPUtils.getDistinguishedNameForObject(sm));
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    private void deleteDnReferences(StateManager sm) {
        int[] fieldNumbers;
        for (int fieldNumber : fieldNumbers = sm.getClassMetaData().getAllMemberPositions()) {
            AbstractMemberMetaData mmd = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            ElementMetaData elementMetaData = mmd.getElementMetaData();
            if (elementMetaData == null) continue;
            String name = elementMetaData.getColumnName();
            AbstractClassMetaData otherCmd = LDAPUtils.getEffectiveClassMetaData(mmd);
            String emptyValue = LDAPUtils.getEmptyValue(mmd);
            this.deleteDnReference(otherCmd, name, sm, emptyValue);
            mmd.isDependent();
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        MetaDataManager mdm = sm.getMetaDataManager();
        Collection classesWithMetaData = mdm.getClassesWithMetaData();
        for (String className : classesWithMetaData) {
            AbstractClassMetaData otherCmd = mdm.getMetaDataForClass(className, clr);
            for (int fieldNumber : fieldNumbers = otherCmd.getAllMemberPositions()) {
                AbstractMemberMetaData mmd = otherCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                AbstractClassMetaData effectiveCmd = LDAPUtils.getEffectiveClassMetaData(mmd);
                if (effectiveCmd != sm.getClassMetaData()) continue;
                String name = LDAPUtils.getAttributeNameForField(mmd);
                String emptyValue = LDAPUtils.getEmptyValue(mmd);
                this.deleteDnReference(otherCmd, name, sm, emptyValue);
            }
        }
    }

    private void deleteDnReference(AbstractClassMetaData cmd, String name, StateManager sm, Object emptyValue) {
        LdapName dn = LDAPUtils.getDistinguishedNameForObject(sm);
        ObjectManager om = sm.getObjectManager();
        ManagedConnection mconn = om.getStoreManager().getConnection(om);
        try {
            LdapName base = LDAPUtils.getDistinguishedNameForClass(cmd);
            String ocFilter = LDAPUtils.getObjectClassesFilterForObject(cmd);
            String dnFilter = "(" + name + "=" + dn.toString() + ")";
            String filter = ocFilter != null ? "(&" + ocFilter + dnFilter + ")" : dnFilter;
            SearchControls searchControls = LDAPUtils.getSearchControls(cmd);
            searchControls.setReturningAttributes(new String[]{name});
            DirContext ctx = (DirContext)mconn.getConnection();
            NamingEnumeration<SearchResult> enumeration = ctx.search((Name)base, filter, searchControls);
            while (enumeration.hasMoreElements()) {
                boolean removed;
                SearchResult sr = (SearchResult)enumeration.nextElement();
                String srName = sr.getNameInNamespace();
                Attributes attrs = sr.getAttributes();
                Attribute attr = sr.getAttributes().get(name);
                if (attr == null || !(removed = attr.remove(dn.toString()))) continue;
                if (attr.size() == 0 && emptyValue != null) {
                    attr.add(emptyValue);
                }
                ctx.modifyAttributes(srName, 2, attrs);
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    private void deleteChildrenRecursive(DirContext ctx, LdapName dn) throws NamingException {
        NamingEnumeration<SearchResult> enumeration = ctx.search((Name)dn, "(objectClass=*)", new SearchControls());
        while (enumeration.hasMoreElements()) {
            SearchResult result = (SearchResult)enumeration.nextElement();
            String resultName = result.getNameInNamespace();
            LdapName resultDn = new LdapName(resultName);
            try {
                ctx.unbind(resultDn);
            }
            catch (ContextNotEmptyException cnee) {
                this.deleteChildrenRecursive(ctx, resultDn);
            }
        }
        ctx.unbind(dn);
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        if (((AbstractStateManager)sm).getLifecycleState().isDeleted()) {
            return;
        }
        fieldNumbers = sm.getClassMetaData().getAllMemberPositions();
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            StringBuffer str = new StringBuffer("Fetching object \"");
            str.append(StringUtils.toJVMIDString((Object)sm.getObject())).append("\" (id=");
            str.append(sm.getObjectManager().getApiAdapter().getObjectId(sm)).append(")").append(" fields [");
            for (int i = 0; i < fieldNumbers.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
            }
            str.append("]");
            NucleusLogger.PERSISTENCE.debug((Object)str);
        }
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.Fetch.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(sm);
            Attributes result = ctx.getAttributes(dn, null);
            sm.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(sm, result));
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementFetchCount();
            }
        }
        catch (NameNotFoundException e) {
            throw new NucleusObjectNotFoundException("Object not found", sm.getExternalObjectId(sm.getObject()));
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    public void locateObject(StateManager sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
            try {
                DirContext ctx = (DirContext)mconn.getConnection();
                LdapName dn = LDAPUtils.getDistinguishedNameForObject(sm);
                ctx.getAttributes(dn, LDAPUtils.NO_ATTRIBUTES);
                return;
            }
            catch (NameNotFoundException e) {
                throw new NucleusObjectNotFoundException("Object not found", sm.getExternalObjectId(sm.getObject()));
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusUserException(LOCALISER.msg("LDAP.DatastoreID"));
        }
    }
}

