/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.util.NucleusLogger;

public class InsertFieldManager
implements FieldManager {
    StateManager sm;
    BasicAttributes attributes;

    public InsertFieldManager(StateManager sm, BasicAttributes attrs) {
        this.sm = sm;
        this.attributes = attrs;
    }

    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        if (value != null) {
            this.attributes.put(new BasicAttribute(name, value));
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        if (value != null) {
            AbstractClassMetaData fieldTypeCmd = this.sm.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.sm.getObjectManager().getClassLoaderResolver());
            if (fieldTypeCmd != null) {
                StateManager smpc = this.sm.getObjectManager().findStateManager(value);
                if (smpc == null) {
                    this.sm.getObjectManager().persistObjectInternal(value, null, null, -1, 0);
                }
                smpc = this.sm.getObjectManager().findStateManager(value);
                this.attributes.put(new BasicAttribute(name, LDAPUtils.getDistinguishedNameForObject(smpc).toString()));
            } else if (mmd.getCollection() != null) {
                Collection c = (Collection)value;
                Iterator it = c.iterator();
                BasicAttribute attr = new BasicAttribute(name);
                this.attributes.put(attr);
                while (it.hasNext()) {
                    Object pc = it.next();
                    StateManager smpc = this.sm.getObjectManager().findStateManager(pc);
                    if (smpc == null) {
                        this.sm.getObjectManager().persistObjectInternal(pc, null, null, -1, 0);
                    }
                    smpc = this.sm.getObjectManager().findStateManager(pc);
                    attr.add(LDAPUtils.getDistinguishedNameForObject(smpc).toString());
                }
            } else {
                ObjectStringConverter converter = this.sm.getObjectManager().getOMFContext().getTypeManager().getStringConverter(mmd.getType());
                if (converter != null) {
                    this.attributes.put(new BasicAttribute(name, converter.toString(value)));
                } else {
                    NucleusLogger.PERSISTENCE.warn((Object)("Field " + mmd.getFullFieldName() + " cannot be persisted because type=" + mmd.getTypeName() + " is not supported for this datastore"));
                }
            }
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        this.attributes.put(new BasicAttribute(name, ("" + value).toUpperCase()));
    }

    public void storeByteField(int fieldNumber, byte value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        this.attributes.put(new BasicAttribute(name, "" + value));
    }

    public void storeCharField(int fieldNumber, char value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        this.attributes.put(new BasicAttribute(name, "" + value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        this.attributes.put(new BasicAttribute(name, "" + value));
    }

    public void storeFloatField(int fieldNumber, float value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        this.attributes.put(new BasicAttribute(name, "" + value));
    }

    public void storeIntField(int fieldNumber, int value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        this.attributes.put(new BasicAttribute(name, "" + value));
    }

    public void storeLongField(int fieldNumber, long value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        this.attributes.put(new BasicAttribute(name, "" + value));
    }

    public void storeShortField(int fieldNumber, short value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        this.attributes.put(new BasicAttribute(name, "" + value));
    }

    public String fetchStringField(int fieldNumber) {
        return null;
    }

    public Object fetchObjectField(int fieldNumber) {
        return null;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return false;
    }

    public byte fetchByteField(int fieldNumber) {
        return 0;
    }

    public char fetchCharField(int fieldNumber) {
        return '\u0000';
    }

    public double fetchDoubleField(int fieldNumber) {
        return 0.0;
    }

    public float fetchFloatField(int fieldNumber) {
        return 0.0f;
    }

    public int fetchIntField(int fieldNumber) {
        return 0;
    }

    public long fetchLongField(int fieldNumber) {
        return 0L;
    }

    public short fetchShortField(int fieldNumber) {
        return 0;
    }
}

