/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.ldap.fieldmanager.FetchFieldManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class LDAPUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)(class$org$datanucleus$store$ldap$LDAPManager == null ? (class$org$datanucleus$store$ldap$LDAPManager = LDAPUtils.class$("org.datanucleus.store.ldap.LDAPManager")) : class$org$datanucleus$store$ldap$LDAPManager).getClassLoader());
    public static final String[] NO_ATTRIBUTES = new String[0];
    static /* synthetic */ Class class$org$datanucleus$store$ldap$LDAPManager;
    static /* synthetic */ Class class$org$datanucleus$query$compiler$QueryCompilation;
    static /* synthetic */ Class class$org$datanucleus$metadata$AbstractClassMetaData;

    public static String getDistinguishedNameForObject(StateManager sm) {
        Object value = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        AbstractMemberMetaData rdnmmd = sm.getClassMetaData().getMetaDataForManagedMemberAtPosition(sm.getClassMetaData().getPKMemberPositions()[0]);
        String dnKey = LDAPUtils.getAttributeNameForField(rdnmmd);
        return dnKey + "=" + value + "," + LDAPUtils.getContainterDistinguishedName(sm.getClassMetaData());
    }

    private static String getContainterDistinguishedName(AbstractClassMetaData cmd) {
        String name = null;
        if (cmd.hasExtension("dn")) {
            name = cmd.getValueForExtension("dn");
        } else if (cmd.getTable() != null) {
            name = cmd.getTable();
        } else {
            throw new NucleusDataStoreException("Missing 'dn' extension or 'table' attribute for class " + cmd.getName());
        }
        return name;
    }

    public static String getAttributeNameForField(AbstractMemberMetaData mmd) {
        String name = mmd.getName();
        if (mmd.hasExtension("dn")) {
            name = mmd.getValueForExtension("dn");
        } else if (mmd.hasExtension("attribute")) {
            name = mmd.getValueForExtension("attribute");
        } else if (mmd.getColumn() != null) {
            name = mmd.getColumn();
        }
        return name;
    }

    public static String[] getObjectClassesForObject(AbstractClassMetaData cmd) {
        String[] ocs = null;
        if (cmd.hasExtension("objectClass")) {
            ocs = cmd.getValuesForExtension("objectClass");
        } else if (cmd.getSchema() != null) {
            ocs = MetaDataUtils.getInstance().getValuesForCommaSeparatedAttribute(cmd.getSchema());
        } else {
            throw new NucleusDataStoreException("Missing 'objectClass' extension or 'schema' attribute for class " + cmd.getName());
        }
        return ocs;
    }

    public static List getObjectsOfCandidateType(ObjectManager om, ManagedConnection mconn, QueryCompilation compilation, Class candidateClass, boolean subclasses, boolean ignoreCache, boolean inMemory) {
        String[] subclassNames;
        DirContext ctx = (DirContext)mconn.getConnection();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
        List results = LDAPUtils.getObjectsOfCandidateType(om, ctx, compilation, acmd, ignoreCache, inMemory);
        if (subclasses && (subclassNames = om.getMetaDataManager().getSubclassesForClass(candidateClass.getName(), true)) != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(subclassNames[i], clr);
                results.addAll(LDAPUtils.getObjectsOfCandidateType(om, ctx, compilation, cmd, ignoreCache, inMemory));
            }
        }
        return results;
    }

    private static List getObjectsOfCandidateType(ObjectManager om, DirContext ctx, QueryCompilation compilation, final AbstractClassMetaData acmd, boolean ignoreCache, boolean inMemory) {
        ArrayList<Object> results;
        block8: {
            results = new ArrayList<Object>();
            try {
                ClassLoaderResolver clr = om.getClassLoaderResolver();
                String[] objectClasses = LDAPUtils.getObjectClassesForObject(acmd);
                if (objectClasses == null) break block8;
                NamingEnumeration<SearchResult> enumeration = null;
                if (!inMemory) {
                    try {
                        String className = "org.datanucleus.store.ldap.query.QueryToLDAPFilterMapper";
                        Class cls = clr.classForName(className);
                        Method method = ClassUtils.getMethodForClass((Class)cls, (String)"compile", null);
                        Constructor constr = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[]{class$org$datanucleus$query$compiler$QueryCompilation == null ? (class$org$datanucleus$query$compiler$QueryCompilation = LDAPUtils.class$("org.datanucleus.query.compiler.QueryCompilation")) : class$org$datanucleus$query$compiler$QueryCompilation, class$org$datanucleus$metadata$AbstractClassMetaData == null ? (class$org$datanucleus$metadata$AbstractClassMetaData = LDAPUtils.class$("org.datanucleus.metadata.AbstractClassMetaData")) : class$org$datanucleus$metadata$AbstractClassMetaData});
                        String filter = (String)method.invoke(constr.newInstance(compilation, acmd), null);
                        enumeration = ctx.search(LDAPUtils.getContainterDistinguishedName(acmd), filter, null);
                    }
                    catch (Throwable e) {
                        NucleusLogger.QUERY.warn((Object)LOCALISER.msg("LDAP.Query.NativeQueryFailed"));
                        inMemory = true;
                    }
                }
                if (inMemory) {
                    BasicAttributes matchAttrs = new BasicAttributes(true);
                    BasicAttribute objectClass = new BasicAttribute("objectClass");
                    for (int i = 0; i < objectClasses.length; ++i) {
                        objectClass.add(objectClasses[i]);
                    }
                    matchAttrs.put(objectClass);
                    enumeration = ctx.search(LDAPUtils.getContainterDistinguishedName(acmd), (Attributes)matchAttrs);
                }
                while (enumeration.hasMoreElements()) {
                    SearchResult sr = (SearchResult)enumeration.nextElement();
                    final Attributes attrs = sr.getAttributes();
                    results.add(om.findObjectUsingAID(clr.classForName(acmd.getFullClassName()), new FieldValues(){

                        public void fetchFields(StateManager sm) {
                            sm.replaceFields(acmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                        }

                        public void fetchNonLoadedFields(StateManager sm) {
                            sm.replaceNonLoadedFields(acmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, ignoreCache, true));
                }
            }
            catch (NamingException ne) {
                ne.printStackTrace();
            }
        }
        return results;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

