/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.ldap.LDAPManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.FetchFieldManager;
import org.datanucleus.store.ldap.fieldmanager.InsertFieldManager;
import org.datanucleus.store.ldap.fieldmanager.UpdateFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class LDAPPersistenceHandler
implements StorePersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)(class$org$datanucleus$store$ldap$LDAPManager == null ? (class$org$datanucleus$store$ldap$LDAPManager = LDAPPersistenceHandler.class$("org.datanucleus.store.ldap.LDAPManager")) : class$org$datanucleus$store$ldap$LDAPManager).getClassLoader());
    protected final LDAPManager storeMgr;
    static /* synthetic */ Class class$org$datanucleus$store$ldap$LDAPManager;

    public LDAPPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (LDAPManager)storeMgr;
    }

    public void close() {
    }

    public void insertObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                this.locateObject(sm);
                throw new NucleusUserException(LOCALISER.msg("LDAP.Insert.ObjectWithIdAlreadyExists", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            catch (NucleusObjectNotFoundException onfe) {}
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusUserException(LOCALISER.msg("LDAP.DatastoreID"));
        }
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.Insert.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            BasicAttributes attrs = new BasicAttributes();
            int[] fieldNumbers = sm.getClassMetaData().getAllMemberPositions();
            sm.provideFields(fieldNumbers, (FieldManager)new InsertFieldManager(sm, attrs));
            String dn = LDAPUtils.getDistinguishedNameForObject(sm);
            BasicAttribute objectClass = new BasicAttribute("ObjectClass");
            String[] objectClasses = sm.getClassMetaData().getValuesForExtension("objectClass");
            for (int i = 0; i < objectClasses.length; ++i) {
                objectClass.add(objectClasses[i]);
            }
            attrs.put(objectClass);
            ctx.bind(dn, null, (Attributes)attrs);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementInsertCount();
            }
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("LDAP.Insert.ObjectPersisted", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                AbstractClassMetaData cmd = sm.getClassMetaData();
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.Update.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            BasicAttributes attrs = new BasicAttributes();
            BasicAttributes attrsToRemove = new BasicAttributes();
            sm.provideFields(fieldNumbers, (FieldManager)new UpdateFieldManager(sm, attrs, attrsToRemove));
            String dn = LDAPUtils.getDistinguishedNameForObject(sm);
            BasicAttribute objectClass = new BasicAttribute("ObjectClass");
            String[] objectClasses = sm.getClassMetaData().getValuesForExtension("objectClass");
            for (int i = 0; i < objectClasses.length; ++i) {
                objectClass.add(objectClasses[i]);
            }
            attrs.put(objectClass);
            if (attrs.size() > 0) {
                ctx.modifyAttributes(dn, 2, (Attributes)attrs);
            }
            if (attrsToRemove.size() > 0) {
                ctx.modifyAttributes(dn, 3, (Attributes)attrsToRemove);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.Delete.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            ctx.unbind(LDAPUtils.getDistinguishedNameForObject(sm));
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementDeleteCount();
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            StringBuffer str = new StringBuffer("Fetching object \"");
            str.append(StringUtils.toJVMIDString((Object)sm.getObject())).append("\" (id=");
            str.append(sm.getObjectManager().getApiAdapter().getObjectId(sm)).append(")").append(" fields [");
            for (int i = 0; i < fieldNumbers.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
            }
            str.append("]");
            NucleusLogger.PERSISTENCE.debug((Object)str);
        }
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.Fetch.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            String dn = LDAPUtils.getDistinguishedNameForObject(sm);
            Attributes result = ctx.getAttributes(dn, null);
            sm.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(sm, result));
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementFetchCount();
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    public void locateObject(StateManager sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
            try {
                DirContext ctx = (DirContext)mconn.getConnection();
                String dn = LDAPUtils.getDistinguishedNameForObject(sm);
                ctx.getAttributes(dn, LDAPUtils.NO_ATTRIBUTES);
                return;
            }
            catch (NamingException ex) {
                throw new NucleusObjectNotFoundException("Object not found", sm.getExternalObjectId(sm.getObject()));
            }
            finally {
                mconn.release();
            }
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusUserException(LOCALISER.msg("LDAP.DatastoreID"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

