/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.json.JsonPersistenceHandler;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.inmemory.JPQLInMemoryEvaluator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    private static final long serialVersionUID = -6015910615189203380L;

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JPQLQuery)null);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, JPQLQuery q) {
        super(storeMgr, ec, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.ec.getClassLoaderResolver());
        Properties options = new Properties();
        options.put("org.datanucleus.store.json.url", ((JsonPersistenceHandler)this.getStoreManager().getPersistenceHandler()).getURLPathForQuery(cmd));
        ManagedConnection mconn = this.getStoreManager().getConnectionManager().getConnection(this.ec, (Map)options);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021046", (Object[])new Object[]{QueryLanguage.JPQL.name(), this.getSingleStringQuery(), null}));
            }
            List candidates = null;
            candidates = this.candidateCollection == null ? ((JsonPersistenceHandler)this.getStoreManager().getPersistenceHandler()).getObjectsOfCandidateType(this.ec, mconn, this.candidateClass, this.subclasses, this.ignoreCache, options) : new ArrayList(this.candidateCollection);
            JPQLInMemoryEvaluator resultMapper = new JPQLInMemoryEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
            Collection results = resultMapper.execute(true, true, true, true, true);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021074", (Object[])new Object[]{QueryLanguage.JPQL.name(), "" + (System.currentTimeMillis() - startTime)}));
            }
            if (this.type == Query.QueryType.BULK_DELETE) {
                this.ec.deleteObjects(results.toArray());
                Long l = results.size();
                return l;
            }
            if (this.type == Query.QueryType.BULK_UPDATE) {
                throw new NucleusException("Bulk Update is not yet supported");
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }
}

