/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.json.JsonPersistenceHandler;
import org.datanucleus.store.json.query.JDOQLQuery;
import org.datanucleus.store.json.query.JPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;

public class JsonStoreManager
extends AbstractStoreManager {
    public JsonStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext ctx, Map<String, Object> props) {
        super("json", clr, ctx, props);
        this.persistenceHandler = new JsonPersistenceHandler((StoreManager)this);
        this.connectionMgr.disableConnectionCaching();
        this.logConfiguration();
    }

    public NucleusConnection getNucleusConnection(ExecutionContext ec) {
        throw new UnsupportedOperationException();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationId");
        set.add("ApplicationCompositeId");
        set.add("DatastoreId");
        set.add("TransactionIsolationLevel.read-committed");
        set.add("ORM");
        set.add("ORM.EmbeddedPC.Nested");
        set.add("Query.JDOQL.BulkDelete");
        set.add("Query.JPQL.BulkDelete");
        set.add("ORM.Inheritance.CompleteTable");
        return set;
    }

    public Query newQuery(String language, ExecutionContext ec) {
        if (language.equals(QueryLanguage.JDOQL.name())) {
            return new JDOQLQuery((StoreManager)this, ec);
        }
        if (language.equals(QueryLanguage.JPQL.name())) {
            return new JPQLQuery((StoreManager)this, ec);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public Query newQuery(String language, ExecutionContext ec, String queryString) {
        if (language.equals(QueryLanguage.JDOQL.name())) {
            return new JDOQLQuery((StoreManager)this, ec, queryString);
        }
        if (language.equals(QueryLanguage.JPQL.name())) {
            return new JPQLQuery((StoreManager)this, ec, queryString);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public Query newQuery(String language, ExecutionContext ec, Query q) {
        if (language.equals(QueryLanguage.JDOQL.name())) {
            return new JDOQLQuery((StoreManager)this, ec, (JDOQLQuery)q);
        }
        if (language.equals(QueryLanguage.JPQL.name())) {
            return new JPQLQuery((StoreManager)this, ec, (JPQLQuery)q);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public void manageClasses(ClassLoaderResolver clr, String ... classNames) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        for (ClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            StoreData sd;
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd.isEmbeddedOnly() || this.storeDataMgr.managesClass(cmd.getFullClassName()) || (sd = this.storeDataMgr.get(cmd.getFullClassName())) != null) continue;
            CompleteClassTable table = new CompleteClassTable((StoreManager)this, (AbstractClassMetaData)cmd, null);
            sd = this.newStoreData(cmd, clr);
            sd.setTable((Table)table);
            this.registerStoreData(sd);
        }
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.store.json.Localisation", (ClassLoader)JsonStoreManager.class.getClassLoader());
    }
}

