/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URLConnection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.CloudStorageUtils;
import org.datanucleus.store.json.fieldmanager.FetchFieldManager;
import org.datanucleus.store.json.fieldmanager.StoreFieldManager;
import org.datanucleus.store.json.orgjson.JSONArray;
import org.datanucleus.store.json.orgjson.JSONException;
import org.datanucleus.store.json.orgjson.JSONObject;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JsonPersistenceHandler
extends AbstractPersistenceHandler {
    JsonPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertObject(DNStateManager sm) {
        this.assertReadOnlyForUpdateOfObject(sm);
        ExecutionContext ec = sm.getExecutionContext();
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
            this.storeMgr.manageClasses(ec.getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
        }
        Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.datanucleus.store.json.url", this.getURLPath(sm));
        options.put("Content-Type", "application/json");
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec, options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"JSON.Insert.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            JSONObject jsonobj = new JSONObject();
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                String memberName = table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName();
                Object idKey = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)sm.getInternalObjectId());
                try {
                    jsonobj.put(memberName, idKey);
                }
                catch (JSONException e) {
                    throw new NucleusException("Exception setting datastore identity in JSON object", (Throwable)e);
                }
            }
            if (cmd.isVersioned()) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                String verColName = null;
                verColName = vermd.getMemberName() != null ? table.getMemberColumnMappingForMember(cmd.getMetaDataForMember(vermd.getMemberName())).getColumn(0).getName() : table.getSurrogateColumn(SurrogateColumnType.VERSION).getName();
                if (vermd.getStrategy() == VersionStrategy.VERSION_NUMBER) {
                    long versionNumber = 1L;
                    sm.setTransactionalVersion((Object)versionNumber);
                    if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"JSON.Insert.ObjectPersistedWithVersion", (Object[])new Object[]{StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), "" + versionNumber}));
                    }
                    try {
                        jsonobj.put(verColName, versionNumber);
                    }
                    catch (JSONException e) {
                        throw new NucleusException("Exception setting version in JSON object", (Throwable)e);
                    }
                    if (vermd.getMemberName() != null) {
                        AbstractMemberMetaData verfmd = cmd.getMetaDataForMember(vermd.getMemberName());
                        if (verfmd.getType() == Integer.class) {
                            sm.replaceField(verfmd.getAbsoluteFieldNumber(), (Object)((int)versionNumber));
                        } else {
                            sm.replaceField(verfmd.getAbsoluteFieldNumber(), (Object)versionNumber);
                        }
                    }
                } else if (vermd.getStrategy() == VersionStrategy.DATE_TIME) {
                    Date date = new Date();
                    Timestamp ts = new Timestamp(date.getTime());
                    sm.setTransactionalVersion((Object)ts);
                    if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"JSON.Insert.ObjectPersistedWithVersion", (Object[])new Object[]{StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), "" + ts}));
                    }
                    try {
                        jsonobj.put(verColName, ts.getTime());
                    }
                    catch (JSONException e) {
                        throw new NucleusException("Exception setting version in JSON object", (Throwable)e);
                    }
                }
            }
            int[] fieldNumbers = cmd.getAllMemberPositions();
            sm.provideFields(fieldNumbers, (FieldManager)new StoreFieldManager(sm, jsonobj, true, table));
            String jsonString = jsonobj.toString();
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("POST " + jsonString));
            }
            this.write("POST", conn.getURL().toExternalForm(), conn, jsonString, this.getHeaders("POST", options));
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementInsertCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"JSON.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(DNStateManager sm, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(sm);
        ExecutionContext ec = sm.getExecutionContext();
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
            this.storeMgr.manageClasses(ec.getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
        }
        Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.datanucleus.store.json.url", this.getURLPath(sm));
        options.put("Content-Type", "application/json");
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec, options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        try {
            int i;
            int[] updatedFieldNums = fieldNumbers;
            Object currentVersion = sm.getTransactionalVersion();
            Object nextVersion = null;
            if (cmd.isVersioned()) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getMemberName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getMemberName());
                    if (currentVersion instanceof Integer) {
                        currentVersion = ((Integer)currentVersion).longValue();
                    }
                    nextVersion = ec.getLockManager().getNextVersion(vermd, currentVersion);
                    if (verMmd.getType() == Integer.class || verMmd.getType() == Integer.TYPE) {
                        nextVersion = ((Long)nextVersion).intValue();
                    }
                    sm.replaceField(verMmd.getAbsoluteFieldNumber(), nextVersion);
                    boolean updatingVerField = false;
                    for (i = 0; i < fieldNumbers.length; ++i) {
                        if (fieldNumbers[i] != verMmd.getAbsoluteFieldNumber()) continue;
                        updatingVerField = true;
                    }
                    if (!updatingVerField) {
                        updatedFieldNums = new int[fieldNumbers.length + 1];
                        System.arraycopy(fieldNumbers, 0, updatedFieldNums, 0, fieldNumbers.length);
                        updatedFieldNums[fieldNumbers.length] = verMmd.getAbsoluteFieldNumber();
                    }
                } else {
                    nextVersion = ec.getLockManager().getNextVersion(vermd, currentVersion);
                }
                sm.setTransactionalVersion(nextVersion);
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuilder fieldStr = new StringBuilder();
                for (i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"JSON.Update.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId(), fieldStr.toString()}));
            }
            JSONObject jsonobj = new JSONObject();
            if (cmd.isVersioned()) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                String verColName = null;
                verColName = vermd.getMemberName() != null ? table.getMemberColumnMappingForMember(cmd.getMetaDataForMember(vermd.getMemberName())).getColumn(0).getName() : table.getSurrogateColumn(SurrogateColumnType.VERSION).getName();
                if (vermd.getStrategy() == VersionStrategy.VERSION_NUMBER) {
                    if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"JSON.Insert.ObjectPersistedWithVersion", (Object[])new Object[]{StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), "" + nextVersion}));
                    }
                    try {
                        jsonobj.put(verColName, nextVersion);
                    }
                    catch (JSONException e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                }
                if (vermd.getStrategy() == VersionStrategy.DATE_TIME) {
                    if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"JSON.Insert.ObjectPersistedWithVersion", (Object[])new Object[]{StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), "" + nextVersion}));
                    }
                    Timestamp ts = (Timestamp)nextVersion;
                    Date date = new Date();
                    date.setTime(ts.getTime());
                    try {
                        jsonobj.put(verColName, ts.getTime());
                    }
                    catch (JSONException e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            StoreFieldManager storeFM = new StoreFieldManager(sm, jsonobj, false, table);
            sm.provideFields(updatedFieldNums, (FieldManager)storeFM);
            sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)storeFM);
            String jsonString = jsonobj.toString();
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("PUT " + jsonString));
            }
            this.write("PUT", conn.getURL().toExternalForm(), conn, jsonString, this.getHeaders("PUT", options));
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementUpdateCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"JSON.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(DNStateManager sm) {
        this.assertReadOnlyForUpdateOfObject(sm);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.datanucleus.store.json.url", this.getURLPath(sm));
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec, options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"JSON.Delete.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            HttpURLConnection http = (HttpURLConnection)conn;
            Map<String, String> headers = this.getHeaders("DELETE", options);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                http.setRequestProperty(key, value);
            }
            http.setRequestMethod("DELETE");
            http.setReadTimeout(10000);
            http.setConnectTimeout(10000);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("DELETE " + sm.getInternalObjectId()));
            }
            http.connect();
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
            if (http.getResponseCode() == 404) {
                throw new NucleusObjectNotFoundException();
            }
            this.handleHTTPErrorCode(http);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"JSON.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchObject(DNStateManager sm, int[] fieldNumbers) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.datanucleus.store.json.url", this.getURLPath(sm));
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec, options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        try {
            AbstractClassMetaData cmd = sm.getClassMetaData();
            Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                StringBuilder str = new StringBuilder("Fetching object \"");
                str.append(sm.getObjectAsPrintable()).append("\" (id=");
                str.append(sm.getInternalObjectId()).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.PERSISTENCE.debug((Object)str.toString());
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"JSON.Fetch.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            JSONObject jsonobj = new JSONObject();
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                String memberName = table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName();
                Object idKey = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)sm.getInternalObjectId());
                try {
                    jsonobj.put(memberName, idKey);
                }
                catch (JSONException e) {
                    throw new NucleusException("Exception setting datastore identity in JSON object", (Throwable)e);
                }
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)new StoreFieldManager(sm, jsonobj, true, table));
            }
            JSONObject result = this.read("GET", conn.getURL().toExternalForm(), conn, this.getHeaders("GET", options));
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("GET " + result.toString()));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
                ec.getStatistics().incrementFetchCount();
            }
            sm.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(sm, result, table));
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"JSON.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    public void locateObject(DNStateManager sm) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.datanucleus.store.json.url", this.getURLPath(sm));
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec, options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        try {
            HttpURLConnection http = (HttpURLConnection)conn;
            Map<String, String> headers = this.getHeaders("HEAD", options);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                http.setRequestProperty(key, value);
            }
            http.setDoOutput(true);
            http.setRequestMethod("HEAD");
            http.setReadTimeout(10000);
            http.setConnectTimeout(10000);
            http.connect();
            int code = http.getResponseCode();
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
            }
            if (code == 404) {
                throw new NucleusObjectNotFoundException();
            }
            this.handleHTTPErrorCode(http);
        }
        catch (IOException e) {
            throw new NucleusObjectNotFoundException(e.getMessage(), (Object)e);
        }
    }

    protected void write(String method, String requestUri, URLConnection conn, String jsonString, Map<String, String> headers) {
        try {
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)("Writing to URL " + requestUri + " content " + jsonString));
            }
            int length = jsonString.length();
            HttpURLConnection http = (HttpURLConnection)conn;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                http.setRequestProperty(key, value);
            }
            http.setRequestProperty("Content-Length", "" + length);
            http.setDoOutput(true);
            http.setRequestMethod(method);
            http.setReadTimeout(10000);
            http.setConnectTimeout(10000);
            http.connect();
            OutputStream os = conn.getOutputStream();
            os.write(jsonString.getBytes());
            os.flush();
            os.close();
            this.handleHTTPErrorCode(http);
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected JSONObject read(String method, String requestUri, URLConnection conn, Map headers) {
        try {
            HttpURLConnection http = (HttpURLConnection)conn;
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                http.setRequestProperty(key, value);
            }
            http.setDoInput(true);
            http.setRequestMethod(method);
            http.setReadTimeout(10000);
            http.setConnectTimeout(10000);
            http.connect();
            int code = http.getResponseCode();
            if (code == 404) {
                throw new NucleusObjectNotFoundException();
            }
            http.getResponseMessage();
            StringBuilder sb = new StringBuilder();
            if (http.getContentLength() > 0) {
                for (int i = 0; i < http.getContentLength(); ++i) {
                    sb.append((char)http.getInputStream().read());
                }
            } else {
                int r;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((r = http.getInputStream().read(buffer)) != -1) {
                    baos.write(buffer, 0, r);
                }
                sb.append(new String(baos.toByteArray()));
            }
            http.getInputStream().close();
            return new JSONObject(sb.toString());
        }
        catch (SocketTimeoutException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected Map<String, String> getHeaders(String httpVerb, Map<String, String> options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Date", CloudStorageUtils.getHTTPDate());
        String contentType = "";
        if (options.containsKey("Content-Type")) {
            contentType = options.get("Content-Type");
            headers.put("Content-Type", contentType);
        }
        return headers;
    }

    public List getObjectsOfCandidateType(ExecutionContext ec, ManagedConnection mconn, Class candidateClass, boolean subclasses, boolean ignoreCache, Map options) {
        ArrayList<Persistable> results = new ArrayList<Persistable>();
        try {
            JSONArray jsonarray;
            URLConnection conn = (URLConnection)mconn.getConnection();
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            final AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
            Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
            try {
                int code;
                HttpURLConnection http = (HttpURLConnection)conn;
                Map<String, String> headers = this.getHeaders("GET", options);
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    http.setRequestProperty(key, value);
                }
                http.setDoInput(true);
                http.setRequestMethod("GET");
                http.setReadTimeout(10000);
                http.setConnectTimeout(10000);
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("GET " + candidateClass.getName()));
                }
                http.connect();
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementNumReads();
                }
                if ((code = http.getResponseCode()) == 404) {
                    return Collections.EMPTY_LIST;
                }
                http.getResponseMessage();
                StringBuilder sb = new StringBuilder();
                if (http.getContentLength() > 0) {
                    for (int i = 0; i < http.getContentLength(); ++i) {
                        sb.append((char)http.getInputStream().read());
                    }
                } else {
                    int r;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((r = http.getInputStream().read(buffer)) != -1) {
                        baos.write(buffer, 0, r);
                    }
                    sb.append(new String(baos.toByteArray()));
                }
                http.getInputStream().close();
                jsonarray = new JSONArray(sb.toString());
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (JSONException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            for (int i = 0; i < jsonarray.length(); ++i) {
                JSONObject json = jsonarray.getJSONObject(i);
                FetchFieldManager fetchFM = new FetchFieldManager(ec, cmd, json, table);
                Object id = null;
                if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    String memberName = table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName();
                    Object key = json.get(memberName);
                    id = key instanceof String ? ec.getNucleusContext().getIdentityManager().getDatastoreId((String)key) : ec.getNucleusContext().getIdentityManager().getDatastoreId(cmd.getFullClassName(), key);
                } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)true, (FieldManager)fetchFM);
                }
                Comparable<Long> version = null;
                if (cmd.isVersioned()) {
                    VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                    String verColName = null;
                    verColName = vermd.getMemberName() == null ? table.getSurrogateColumn(SurrogateColumnType.VERSION).getName() : table.getMemberColumnMappingForMember(cmd.getMetaDataForMember(vermd.getMemberName())).getColumn(0).getName();
                    long versionLong = -1L;
                    try {
                        versionLong = json.getLong(verColName);
                        if (vermd.getStrategy() == VersionStrategy.VERSION_NUMBER) {
                            version = versionLong;
                        } else if (vermd.getStrategy() == VersionStrategy.DATE_TIME) {
                            version = new Timestamp(versionLong);
                        }
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                Persistable obj = ec.findObject(id, new FieldValues((FieldManager)fetchFM){
                    final /* synthetic */ FieldManager val$fetchFM;
                    {
                        this.val$fetchFM = fieldManager;
                    }

                    public FetchPlan getFetchPlanForLoading() {
                        return null;
                    }

                    public void fetchNonLoadedFields(DNStateManager sm) {
                        sm.replaceNonLoadedFields(cmd.getAllMemberPositions(), this.val$fetchFM);
                    }

                    public void fetchFields(DNStateManager sm) {
                        sm.replaceFields(cmd.getAllMemberPositions(), this.val$fetchFM);
                    }
                }, null, ignoreCache, false);
                DNStateManager sm = ec.findStateManager((Object)obj);
                if (cmd.isVersioned() && version != null) {
                    sm.setVersion(version);
                }
                sm.replaceAllLoadedSCOFieldsWithWrappers();
                results.add(obj);
            }
        }
        catch (JSONException je) {
            throw new NucleusException(je.getMessage(), (Throwable)je);
        }
        return results;
    }

    protected String getURLPath(DNStateManager sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
        Object url = this.getURLPath(cmd);
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            url = (String)url + IdentityUtils.getTargetKeyForDatastoreIdentity((Object)sm.getInternalObjectId());
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            JSONObject jsonobj = new JSONObject();
            sm.provideFields(cmd.getPKMemberPositions(), (FieldManager)new StoreFieldManager(sm, jsonobj, true, table));
            try {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[0]);
                String name = table.getMemberColumnMappingForMember(mmd).getColumn(0).getName();
                url = (String)url + jsonobj.get(name).toString();
            }
            catch (JSONException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
        return url;
    }

    protected String getURLPath(AbstractClassMetaData acmd) {
        Object url = acmd.getValueForExtension("url");
        if (url == null) {
            url = acmd.getFullClassName();
        }
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        return url;
    }

    public String getURLPathForQuery(AbstractClassMetaData acmd) {
        Object url = acmd.getValueForExtension("url");
        if (url == null) {
            url = acmd.getFullClassName();
        }
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        return url;
    }

    protected void handleHTTPErrorCode(HttpURLConnection http) throws IOException {
        if (http.getResponseCode() >= 400) {
            StringBuilder sb = new StringBuilder();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            if (http.getErrorStream() != null) {
                int r;
                while ((r = http.getErrorStream().read(buffer)) != -1) {
                    baos.write(buffer, 0, r);
                }
                sb.append(new String(baos.toByteArray()));
                http.getErrorStream().close();
            }
            throw new NucleusDataStoreException("Error on URL: '" + http.getURL().toExternalForm() + "' Request Method: " + http.getRequestMethod() + " HTTP Error code: " + http.getResponseCode() + " " + http.getResponseMessage() + " error: " + sb.toString());
        }
        if (http.getResponseCode() >= 300) {
            throw new NucleusDataStoreException("Redirect not supported. HTTP Error code: " + http.getResponseCode() + " " + http.getResponseMessage());
        }
    }
}

