/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.CloudStorageUtils;
import org.datanucleus.store.json.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.json.orgjson.JSONException;
import org.datanucleus.store.json.orgjson.JSONObject;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.converters.EnumConversionHelper;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    protected Table table;
    protected JSONObject jsonobj;

    public StoreFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, JSONObject jsonobj, boolean insert, Table table) {
        super(ec, cmd, insert);
        this.jsonobj = jsonobj;
        this.table = table;
    }

    public StoreFieldManager(DNStateManager sm, JSONObject jsonobj, boolean insert, Table table) {
        super(sm, insert);
        this.table = table;
        this.jsonobj = jsonobj;
        try {
            jsonobj.put("class", this.cmd.getFullClassName());
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), Character.valueOf(value));
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            if (value == null) {
                this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), JSONObject.NULL);
            } else {
                this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
            }
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        ExecutionContext ec = this.sm.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (!(mmd.isCascadePersist() || ec.getApiAdapter().isDetached(value) || ec.getApiAdapter().isPersistent(value))) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                }
                throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
            }
            try {
                this.storeObjectFieldEmbedded(fieldNumber, value, mmd, clr, relationType);
                return;
            }
            catch (JSONException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.storeObjectFieldInternal(fieldNumber, value, mmd, clr, relationType);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    protected void storeObjectFieldEmbedded(int fieldNumber, Object value, AbstractMemberMetaData mmd, ClassLoaderResolver clr, RelationType relationType) throws JSONException {
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            boolean nested = CloudStorageUtils.isMemberNested(mmd);
            AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            if (nested) {
                if (value == null) {
                    MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
                    String name = mapping.getColumn(0).getName();
                    this.jsonobj.put(name, JSONObject.NULL);
                    return;
                }
                JSONObject embobj = new JSONObject();
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                DNStateManager embSM = this.ec.findStateManagerForEmbedded(value, this.sm, mmd, null);
                StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(embSM, embobj, this.insert, embMmds, this.table);
                embSM.provideFields(embCmd.getAllMemberPositions(), (FieldManager)storeEmbFM);
                NucleusLogger.PERSISTENCE.warn((Object)("Member " + mmd.getFullFieldName() + " marked as embedded NESTED. This is experimental : " + embobj));
                MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
                String name = mapping != null ? mapping.getColumn(0).getName() : mmd.getName();
                this.jsonobj.put(name, embobj);
                return;
            }
            int[] embMmdPosns = embCmd.getAllMemberPositions();
            ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
            embMmds.add(mmd);
            if (value == null) {
                StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(this.ec, embCmd, this.jsonobj, this.insert, embMmds, this.table);
                for (int i = 0; i < embMmdPosns.length; ++i) {
                    AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embMmdPosns[i]);
                    if (String.class.isAssignableFrom(embMmd.getType()) || embMmd.getType().isPrimitive() || ClassUtils.isPrimitiveWrapperType((String)mmd.getTypeName())) {
                        ArrayList<AbstractMemberMetaData> colEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                        colEmbMmds.add(embMmd);
                        MemberColumnMapping mapping = this.table.getMemberColumnMappingForEmbeddedMember(colEmbMmds);
                        for (int j = 0; j < mapping.getNumberOfColumns(); ++j) {
                            this.jsonobj.put(mapping.getColumn(j).getName(), JSONObject.NULL);
                        }
                        continue;
                    }
                    if (!Object.class.isAssignableFrom(embMmd.getType())) continue;
                    storeEmbFM.storeObjectField(embMmdPosns[i], null);
                }
                return;
            }
            DNStateManager embSM = this.ec.findStateManagerForEmbedded(value, this.sm, mmd, null);
            StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(embSM, this.jsonobj, this.insert, embMmds, this.table);
            embSM.provideFields(embMmdPosns, (FieldManager)storeEmbFM);
            return;
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            throw new NucleusUserException("Dont support embedded multi-valued field at " + mmd.getFullFieldName() + " with Excel");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void storeObjectFieldInternal(int fieldNumber, Object value, AbstractMemberMetaData mmd, ClassLoaderResolver clr, RelationType relationType) throws JSONException {
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        String name = mapping.getColumn(0).getName();
        if (value instanceof Optional) {
            Optional opt;
            if (relationType != RelationType.NONE) {
                relationType = RelationType.ONE_TO_ONE_UNI;
            }
            value = (opt = (Optional)value).isPresent() ? opt.get() : null;
        }
        if (relationType == RelationType.NONE) {
            if (mapping.getTypeConverter() != null) {
                Object datastoreValue = mapping.getTypeConverter().toDatastoreType(value);
                if (mapping.getNumberOfColumns() > 1) {
                    if (value == null) {
                        this.jsonobj.put(name, JSONObject.NULL);
                        return;
                    }
                    int i = 0;
                    while (i < mapping.getNumberOfColumns()) {
                        Object colValue = Array.get(datastoreValue, i);
                        this.jsonobj.put(mapping.getColumn(i).getName(), colValue);
                        ++i;
                    }
                    throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
                }
                if (value == null) {
                    this.jsonobj.put(name, JSONObject.NULL);
                    return;
                }
                this.jsonobj.put(mapping.getColumn(0).getName(), datastoreValue);
                throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
            }
            if (value == null) {
                this.jsonobj.put(name, JSONObject.NULL);
                return;
            }
            if (value instanceof Boolean) {
                this.jsonobj.put(name, (Boolean)value);
                return;
            }
            if (value instanceof Integer) {
                this.jsonobj.put(name, (Integer)value);
                return;
            }
            if (value instanceof Long) {
                this.jsonobj.put(name, (Long)value);
                return;
            }
            if (value instanceof Double) {
                this.jsonobj.put(name, (Double)value);
                return;
            }
            if (value instanceof String) {
                this.jsonobj.put(name, value);
                return;
            }
            if (value instanceof Enum) {
                this.jsonobj.put(name, EnumConversionHelper.getStoredValueFromEnum((AbstractMemberMetaData)mmd, (FieldRole)FieldRole.ROLE_FIELD, (Enum)((Enum)value)));
                return;
            }
            if (value instanceof BigDecimal) {
                this.jsonobj.put(name, value);
                return;
            }
            if (value instanceof BigInteger) {
                this.jsonobj.put(name, value);
                return;
            }
            if (value instanceof Collection) {
                this.jsonobj.put(name, (Collection)value);
                return;
            }
            if (value instanceof Map) {
                this.jsonobj.put(name, (Map)value);
                return;
            }
            boolean useLong = MetaDataUtils.isJdbcTypeNumeric((JdbcType)mapping.getColumn(0).getJdbcType());
            TypeConverter longConv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), Long.class);
            if (useLong) {
                if (longConv != null) {
                    this.jsonobj.put(name, longConv.toDatastoreType(value));
                    return;
                }
            } else {
                TypeConverter strConv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), String.class);
                if (strConv != null) {
                    this.jsonobj.put(name, strConv.toDatastoreType(value));
                    return;
                }
                if (longConv != null) {
                    this.jsonobj.put(name, longConv.toDatastoreType(value));
                    return;
                }
            }
            JSONObject jsonobjfield = new JSONObject(value);
            jsonobjfield.put("class", value.getClass().getName());
            this.jsonobj.put(name, jsonobjfield);
            return;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            if (!(mmd.isCascadePersist() || this.ec.getApiAdapter().isDetached(value) || this.ec.getApiAdapter().isPersistent(value))) {
                if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
            }
            if (value == null) {
                this.jsonobj.put(name, JSONObject.NULL);
                return;
            }
            Object valuePC = this.ec.persistObjectInternal(value, this.sm, fieldNumber, PersistableObjectType.PC);
            Object valueId = this.ec.getApiAdapter().getIdForObject(valuePC);
            this.jsonobj.put(name, IdentityUtils.getPersistableIdentityForId((Object)valueId));
            return;
        }
        if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
        if (value == null) {
            this.jsonobj.put(name, JSONObject.NULL);
            return;
        }
        if (mmd.hasCollection()) {
            Collection coll = (Collection)value;
            if (!mmd.isCascadePersist()) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                }
                for (Object element : coll) {
                    if (this.ec.getApiAdapter().isDetached(element) || this.ec.getApiAdapter().isPersistent(element)) continue;
                    throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), element);
                }
            }
            ArrayList<String> idColl = new ArrayList<String>();
            Iterator collIter = coll.iterator();
            while (true) {
                if (!collIter.hasNext()) {
                    this.jsonobj.put(name, idColl);
                    return;
                }
                Object element = collIter.next();
                Object elementPC = this.ec.persistObjectInternal(element, this.sm, fieldNumber, PersistableObjectType.PC);
                Object elementID = this.ec.getApiAdapter().getIdForObject(elementPC);
                idColl.add(IdentityUtils.getPersistableIdentityForId((Object)elementID));
            }
        }
        if (mmd.hasArray()) {
            ArrayList<String> ids = new ArrayList<String>(Array.getLength(value));
            int i = 0;
            while (true) {
                if (i >= Array.getLength(value)) {
                    this.jsonobj.put(name, ids);
                    return;
                }
                Object element = Array.get(value, i);
                Object elementPC = this.ec.persistObjectInternal(element, this.sm, fieldNumber, PersistableObjectType.PC);
                Object elementID = this.ec.getApiAdapter().getIdForObject(elementPC);
                ids.add(IdentityUtils.getPersistableIdentityForId((Object)elementID));
                ++i;
            }
        }
        if (!mmd.hasMap()) throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
        AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr);
        AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr);
        HashMap<Object, Object> idMap = new HashMap<Object, Object>();
        Map map = (Map)value;
        Iterator mapIter = map.entrySet().iterator();
        while (true) {
            if (!mapIter.hasNext()) {
                this.jsonobj.put(name, idMap);
                return;
            }
            Map.Entry entry = mapIter.next();
            Object key = null;
            Object val = null;
            if (keyCmd != null) {
                Object keyPC = this.ec.persistObjectInternal(entry.getKey(), this.sm, fieldNumber, PersistableObjectType.PC);
                key = this.ec.getApiAdapter().getIdForObject(keyPC);
                key = IdentityUtils.getPersistableIdentityForId((Object)key);
            } else {
                key = entry.getKey();
            }
            if (valCmd != null) {
                Object valPC = this.ec.persistObjectInternal(entry.getValue(), this.sm, fieldNumber, PersistableObjectType.PC);
                val = this.ec.getApiAdapter().getIdForObject(valPC);
                val = IdentityUtils.getPersistableIdentityForId((Object)val);
            } else {
                val = entry.getValue();
            }
            idMap.put(key, val);
        }
    }
}

