/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.NucleusLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class StoreEmbeddedFieldManager
extends StoreFieldManager {
    protected List<AbstractMemberMetaData> mmds;

    public StoreEmbeddedFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, JSONObject jsonobj, boolean insert, List<AbstractMemberMetaData> mmds, Table table) {
        super(ec, cmd, jsonobj, insert, table);
        this.mmds = mmds;
    }

    public StoreEmbeddedFieldManager(ObjectProvider op, JSONObject jsonobj, boolean insert, List<AbstractMemberMetaData> mmds, Table table) {
        super(op, jsonobj, insert, table);
        this.mmds = mmds;
    }

    @Override
    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        return this.table.getMemberColumnMappingForEmbeddedMember(embMmds);
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData lastMmd = this.mmds.get(this.mmds.size() - 1);
        EmbeddedMetaData embmd = this.mmds.get(0).getEmbeddedMetaData();
        if (this.mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) {
            ObjectProvider[] ownerOPs;
            if (this.op != null && (ownerOPs = this.op.getEmbeddedOwners()) != null && ownerOPs.length == 1 && value != ownerOPs[0].getObject()) {
                this.op.replaceField(fieldNumber, ownerOPs[0].getObject());
            }
            return;
        }
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, lastMmd)) {
            try {
                this.storeObjectFieldEmbedded(fieldNumber, value, mmd, clr, relationType);
                return;
            }
            catch (JSONException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.op == null) {
            MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
            for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
            }
        }
        try {
            this.storeObjectFieldInternal(fieldNumber, value, mmd, clr, relationType);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void storeObjectFieldEmbedded(int fieldNumber, Object value, AbstractMemberMetaData mmd, ClassLoaderResolver clr, RelationType relationType) throws JSONException {
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            boolean nested = false;
            String nestedStr = mmd.getValueForExtension("nested");
            if (nestedStr != null && nestedStr.equalsIgnoreCase("true")) {
                nested = true;
            }
            AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            if (nested) {
                if (value == null) {
                    MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
                    String name = mapping.getColumn(0).getIdentifier();
                    this.jsonobj.put(name, JSONObject.NULL);
                    return;
                }
                JSONObject embobj = new JSONObject();
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
                embMmds.add(mmd);
                ObjectProvider embOP = this.ec.findObjectProviderForEmbedded(value, this.op, mmd);
                StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(embOP, embobj, this.insert, embMmds, this.table);
                embOP.provideFields(embCmd.getAllMemberPositions(), (FieldManager)storeEmbFM);
                NucleusLogger.PERSISTENCE.warn((Object)("Member " + mmd.getFullFieldName() + " marked as embedded NESTED. This is experimental : " + embobj));
                MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
                String name = mapping != null ? mapping.getColumn(0).getIdentifier() : mmd.getName();
                this.jsonobj.put(name, embobj);
                return;
            }
            if (embCmd != null) {
                ObjectProvider embOP = null;
                embOP = value != null ? this.ec.findObjectProviderForEmbedded(value, this.op, mmd) : this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, embCmd, this.op, fieldNumber);
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
                embMmds.add(mmd);
                embOP.provideFields(embCmd.getAllMemberPositions(), (FieldManager)new StoreEmbeddedFieldManager(embOP, this.jsonobj, this.insert, embMmds, this.table));
                return;
            }
        } else {
            NucleusLogger.PERSISTENCE.debug((Object)("Field=" + mmd.getFullFieldName() + " not currently supported (embedded), storing as null"));
            return;
        }
    }
}

