/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.TypeConversionHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchFieldManager
extends AbstractFetchFieldManager {
    protected final JSONObject result;
    protected StoreManager storeMgr;

    public FetchFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, JSONObject result) {
        super(ec, cmd);
        this.result = result;
        this.storeMgr = ec.getStoreManager();
    }

    public FetchFieldManager(ObjectProvider op, JSONObject result) {
        super(op);
        this.result = result;
        this.storeMgr = this.ec.getStoreManager();
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String memberName = this.storeMgr.getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
        if (this.result.isNull(memberName)) {
            return false;
        }
        try {
            return this.result.getBoolean(memberName);
        }
        catch (JSONException e) {
            return false;
        }
    }

    public byte fetchByteField(int fieldNumber) {
        String memberName = this.storeMgr.getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
        if (this.result.isNull(memberName)) {
            return 0;
        }
        try {
            String str = this.result.getString(memberName);
            return Byte.valueOf(str);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public char fetchCharField(int fieldNumber) {
        String memberName = this.storeMgr.getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
        if (this.result.isNull(memberName)) {
            return '\u0000';
        }
        try {
            return this.result.getString(memberName).charAt(0);
        }
        catch (JSONException e) {
            return '\u0000';
        }
    }

    public double fetchDoubleField(int fieldNumber) {
        String memberName = this.storeMgr.getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
        if (this.result.isNull(memberName)) {
            return 0.0;
        }
        try {
            return this.result.getDouble(memberName);
        }
        catch (JSONException e) {
            return 0.0;
        }
    }

    public float fetchFloatField(int fieldNumber) {
        String memberName = this.storeMgr.getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
        if (this.result.isNull(memberName)) {
            return 0.0f;
        }
        try {
            return (float)this.result.getDouble(memberName);
        }
        catch (JSONException e) {
            return 0.0f;
        }
    }

    public int fetchIntField(int fieldNumber) {
        String memberName = this.storeMgr.getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
        if (this.result.isNull(memberName)) {
            return 0;
        }
        try {
            return this.result.getInt(memberName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public long fetchLongField(int fieldNumber) {
        String memberName = this.storeMgr.getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
        if (this.result.isNull(memberName)) {
            return 0L;
        }
        try {
            return this.result.getLong(memberName);
        }
        catch (JSONException e) {
            return 0L;
        }
    }

    public short fetchShortField(int fieldNumber) {
        String memberName = this.storeMgr.getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
        if (this.result.isNull(memberName)) {
            return 0;
        }
        try {
            return (short)this.result.getInt(memberName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public String fetchStringField(int fieldNumber) {
        String memberName = this.storeMgr.getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
        if (this.result.isNull(memberName)) {
            return null;
        }
        try {
            return this.result.getString(memberName);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String memberName = this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        if (this.result.isNull(memberName)) {
            return null;
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (RelationType.isRelationSingleValued((RelationType)relationType) && mmd.isEmbedded()) {
            throw new NucleusException("Don't currently support embedded fields");
        }
        try {
            return this.fetchObjectFieldInternal(mmd, memberName, clr);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object fetchObjectFieldInternal(AbstractMemberMetaData mmd, String memberName, ClassLoaderResolver clr) throws JSONException {
        Map map;
        JSONObject mapVal;
        block78: {
            Collection coll;
            JSONArray array;
            block77: {
                Class valCls;
                Class keyCls;
                Iterator keyIter;
                JSONObject mapValue;
                Map map2;
                block76: {
                    Class elementCls;
                    JSONArray array2;
                    Collection coll2;
                    block74: {
                        RelationType relationType;
                        block72: {
                            Object returnValue;
                            block75: {
                                block73: {
                                    relationType = mmd.getRelationType(clr);
                                    if (relationType != RelationType.NONE) break block72;
                                    returnValue = null;
                                    if (mmd.getTypeConverterName() != null) {
                                        TypeConverter conv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForName(mmd.getTypeConverterName());
                                        Class datastoreType = TypeManager.getDatastoreTypeForTypeConverter((TypeConverter)conv, (Class)mmd.getType());
                                        if (datastoreType == String.class) {
                                            returnValue = conv.toMemberType((Object)this.result.getString(memberName));
                                        } else if (datastoreType == Boolean.class) {
                                            returnValue = conv.toMemberType((Object)this.result.getBoolean(memberName));
                                        } else if (datastoreType == Double.class) {
                                            returnValue = conv.toMemberType((Object)this.result.getDouble(memberName));
                                        } else if (datastoreType == Float.class) {
                                            returnValue = conv.toMemberType((Object)this.result.getDouble(memberName));
                                        } else if (datastoreType == Integer.class) {
                                            returnValue = conv.toMemberType((Object)this.result.getInt(memberName));
                                        } else if (datastoreType == Long.class) {
                                            returnValue = conv.toMemberType((Object)this.result.getLong(memberName));
                                        }
                                        if (this.op == null) throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
                                        this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), returnValue, false, false, true);
                                        throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
                                    }
                                    if (Boolean.class.isAssignableFrom(mmd.getType())) {
                                        return this.result.getBoolean(memberName);
                                    }
                                    if (Integer.class.isAssignableFrom(mmd.getType())) {
                                        return this.result.getInt(memberName);
                                    }
                                    if (Long.class.isAssignableFrom(mmd.getType())) {
                                        return this.result.getLong(memberName);
                                    }
                                    if (Double.class.isAssignableFrom(mmd.getType())) {
                                        return this.result.getDouble(memberName);
                                    }
                                    if (Enum.class.isAssignableFrom(mmd.getType())) {
                                        ColumnMetaData[] colmds = mmd.getColumnMetaData();
                                        boolean useNumeric = MetaDataUtils.persistColumnAsNumeric(colmds != null ? colmds[0] : null);
                                        if (!useNumeric) return Enum.valueOf(mmd.getType(), (String)this.result.get(memberName));
                                        return mmd.getType().getEnumConstants()[this.result.getInt(memberName)];
                                    }
                                    if (BigDecimal.class.isAssignableFrom(mmd.getType())) return TypeConversionHelper.convertTo((Object)this.result.get(memberName), (Class)mmd.getType());
                                    if (BigInteger.class.isAssignableFrom(mmd.getType())) {
                                        return TypeConversionHelper.convertTo((Object)this.result.get(memberName), (Class)mmd.getType());
                                    }
                                    if (!Collection.class.isAssignableFrom(mmd.getType())) break block73;
                                    try {
                                        Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                                        coll2 = (Collection)instanceType.newInstance();
                                    }
                                    catch (Exception e) {
                                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                                    }
                                    array2 = this.result.getJSONArray(memberName);
                                    elementCls = null;
                                    if (mmd.getCollection() != null && mmd.getCollection().getElementType() != null) {
                                        elementCls = clr.classForName(mmd.getCollection().getElementType());
                                    }
                                    break block74;
                                }
                                if (!Map.class.isAssignableFrom(mmd.getType())) break block75;
                                try {
                                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                                    map2 = (Map)instanceType.newInstance();
                                }
                                catch (Exception e) {
                                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                                }
                                mapValue = this.result.getJSONObject(memberName);
                                keyIter = mapValue.keys();
                                keyCls = null;
                                if (mmd.getMap() != null && mmd.getMap().getKeyType() != null) {
                                    keyCls = clr.classForName(mmd.getMap().getKeyType());
                                }
                                valCls = null;
                                if (mmd.getMap() != null && mmd.getMap().getValueType() != null) {
                                    valCls = clr.classForName(mmd.getMap().getValueType());
                                }
                                break block76;
                            }
                            if (!mmd.getType().isArray()) {
                                String jdbc;
                                boolean useLong = false;
                                ColumnMetaData[] colmds = mmd.getColumnMetaData();
                                if (colmds != null && colmds.length == 1 && (jdbc = colmds[0].getJdbcType()) != null && (jdbc.equalsIgnoreCase("INTEGER") || jdbc.equalsIgnoreCase("NUMERIC"))) {
                                    useLong = true;
                                }
                                TypeConverter strConv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), String.class);
                                TypeConverter longConv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), Long.class);
                                if (useLong && longConv != null) {
                                    returnValue = longConv.toMemberType((Object)this.result.getLong(memberName));
                                } else if (!useLong && strConv != null) {
                                    returnValue = strConv.toMemberType((Object)((String)this.result.get(memberName)));
                                } else if (!useLong && longConv != null) {
                                    returnValue = longConv.toMemberType((Object)this.result.getLong(memberName));
                                } else {
                                    Object value = this.result.get(memberName);
                                    if (value instanceof JSONObject) {
                                        Class cls = clr.classForName(((JSONObject)value).getString("class"), true);
                                        returnValue = this.getNonpersistableObjectFromJSON((JSONObject)value, cls, clr);
                                    } else {
                                        returnValue = TypeConversionHelper.convertTo((Object)this.result.get(memberName), (Class)mmd.getType());
                                    }
                                }
                                if (this.op == null) return returnValue;
                                this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), returnValue, false, false, true);
                                return returnValue;
                            }
                            break block77;
                        }
                        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                            String idStr = (String)this.result.get(memberName);
                            if (idStr == null) {
                                return null;
                            }
                            Object obj = null;
                            AbstractClassMetaData memberCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                            if (!memberCmd.usesSingleFieldIdentityClass()) return IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec, (boolean)true);
                            if (idStr.indexOf(58) <= 0) return IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec, (boolean)true);
                            return IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec);
                        }
                        if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
                        if (mmd.hasCollection()) {
                            array = (JSONArray)this.result.get(memberName);
                            try {
                                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                                coll = (Collection)instanceType.newInstance();
                            }
                            catch (Exception e) {
                                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                            }
                        }
                        if (!mmd.hasArray()) {
                            if (!mmd.hasMap()) throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
                            mapVal = (JSONObject)this.result.get(memberName);
                            try {
                                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                                map = (Map)instanceType.newInstance();
                            }
                            catch (Exception e) {
                                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                            }
                        }
                        break block78;
                    }
                    int i = 0;
                    while (true) {
                        if (i >= array2.length()) {
                            if (this.op == null) return coll2;
                            this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)coll2, false, false, true);
                            return coll2;
                        }
                        if (array2.isNull(i)) {
                            coll2.add(null);
                        } else {
                            Object value = array2.get(i);
                            if (value instanceof JSONObject) {
                                Class cls = clr.classForName(((JSONObject)value).getString("class"), true);
                                coll2.add(this.getNonpersistableObjectFromJSON((JSONObject)value, cls, clr));
                            } else if (elementCls != null) {
                                coll2.add(TypeConversionHelper.convertTo((Object)value, (Class)elementCls));
                            } else {
                                coll2.add(value);
                            }
                        }
                        ++i;
                    }
                }
                while (true) {
                    void var12_60;
                    Object jsonVal;
                    Object jsonKey;
                    if (!keyIter.hasNext()) {
                        if (this.op == null) return map2;
                        this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)map2, false, false, true);
                        return map2;
                    }
                    Object e = jsonKey = keyIter.next();
                    if (keyCls != null) {
                        Object object = TypeConversionHelper.convertTo(jsonKey, (Class)keyCls);
                    }
                    Object val = jsonVal = mapValue.get((String)var12_60);
                    if (jsonVal instanceof JSONObject) {
                        Class cls = clr.classForName(((JSONObject)jsonVal).getString("class"), true);
                        val = this.getNonpersistableObjectFromJSON((JSONObject)jsonVal, cls, clr);
                    } else if (valCls != null) {
                        val = TypeConversionHelper.convertTo((Object)jsonVal, (Class)valCls);
                    }
                    map2.put(var12_60, val);
                }
            }
            JSONArray arrayJson = this.result.getJSONArray(memberName);
            Object array3 = Array.newInstance(mmd.getType().getComponentType(), arrayJson.length());
            int i = 0;
            while (i < arrayJson.length()) {
                if (arrayJson.isNull(i)) {
                    Array.set(array3, i, null);
                } else {
                    Object value = arrayJson.get(i);
                    if (value instanceof JSONObject) {
                        JSONObject valueJson = (JSONObject)value;
                        Class valueCls = clr.classForName(valueJson.getString("class"));
                        Array.set(array3, i, this.getNonpersistableObjectFromJSON((JSONObject)value, valueCls, clr));
                    } else {
                        Array.set(array3, i, TypeConversionHelper.convertTo((Object)value, mmd.getType().getComponentType()));
                    }
                }
                ++i;
            }
            return array3;
            AbstractClassMetaData elementCmd = mmd.getCollection().getElementClassMetaData(this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager());
            i = 0;
            while (true) {
                if (i >= array.length()) {
                    if (this.op == null) return coll;
                    return this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)coll, false, false, true);
                }
                String idStr = (String)array.get(i);
                Object element = null;
                element = elementCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec, (boolean)true);
                coll.add(element);
                ++i;
            }
        }
        JSONArray array = (JSONArray)this.result.get(memberName);
        Object arrayField = Array.newInstance(mmd.getType().getComponentType(), array.length());
        AbstractClassMetaData elementCmd = mmd.getCollection().getElementClassMetaData(this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager());
        int i = 0;
        while (true) {
            if (i >= array.length()) {
                if (this.op == null) return arrayField;
                return this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), arrayField, false, false, true);
            }
            String idStr = (String)array.get(i);
            Object element = null;
            element = elementCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec, (boolean)true);
            Array.set(arrayField, i, element);
            ++i;
        }
        AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager());
        AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager());
        Iterator keyIter = mapVal.keys();
        while (true) {
            if (!keyIter.hasNext()) {
                if (this.op == null) return map;
                return this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)map, false, false, true);
            }
            Object jsonKey = keyIter.next();
            Object key = null;
            if (keyCmd != null) {
                String string = (String)jsonKey;
                key = keyCmd.usesSingleFieldIdentityClass() && string.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)string, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)string, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec, (boolean)true);
            } else {
                Class clazz = this.ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType());
                key = TypeConversionHelper.convertTo(jsonKey, (Class)clazz);
            }
            Object object = mapVal.get((String)key);
            Object val = null;
            if (valCmd != null) {
                String idStr = (String)object;
                val = valCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)valCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)valCmd, (ExecutionContext)this.ec, (boolean)true);
            } else {
                Class valCls = this.ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType());
                val = TypeConversionHelper.convertTo((Object)object, (Class)valCls);
            }
            map.put(key, val);
        }
    }

    private Object getNonpersistableObjectFromJSON(final JSONObject jsonobj, final Class cls, ClassLoaderResolver clr) {
        if (cls.getName().equals("com.google.appengine.api.users.User")) {
            return this.getComGoogleAppengineApiUsersUserFromJSON(jsonobj, cls, clr);
        }
        if (cls.getName().equals("com.google.appengine.api.datastore.Key")) {
            return this.getComGoogleAppengineApiDatastoreKeyFromJSON(jsonobj, cls, clr);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Constructor c = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[0]);
                        c.setAccessible(true);
                        Object obj = c.newInstance(new Object[0]);
                        String[] fieldNames = JSONObject.getNames(jsonobj);
                        for (int i = 0; i < jsonobj.length(); ++i) {
                            if (fieldNames[i].equals("class")) continue;
                            Field field = cls.getField(fieldNames[i]);
                            field.setAccessible(true);
                            field.set(obj, jsonobj.get(fieldNames[i]));
                        }
                        return obj;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected Object getComGoogleAppengineApiUsersUserFromJSON(JSONObject jsonobj, Class cls, ClassLoaderResolver clr) {
        String email = null;
        String authDomain = null;
        try {
            email = jsonobj.getString("email");
        }
        catch (JSONException e) {
            // empty catch block
        }
        try {
            authDomain = jsonobj.getString("authDomain");
        }
        catch (JSONException e) {
            // empty catch block
        }
        return ClassUtils.newInstance((Class)cls, (Class[])new Class[]{String.class, String.class}, (Object[])new String[]{email, authDomain});
    }

    protected Object getComGoogleAppengineApiDatastoreKeyFromJSON(JSONObject jsonobj, Class cls, ClassLoaderResolver clr) {
        try {
            Object parent = null;
            if (jsonobj.has("parent") && !jsonobj.isNull("parent")) {
                JSONObject parentobj = jsonobj.getJSONObject("parent");
                parent = this.getNonpersistableObjectFromJSON(parentobj, clr.classForName(jsonobj.getString("class")), clr);
            }
            if (jsonobj.has("appId")) {
                String appId = jsonobj.getString("appId");
                String kind = jsonobj.getString("kind");
                Class keyFactory = clr.classForName("com.google.appengine.api.datastore.KeyFactory", cls.getClassLoader(), false);
                if (parent != null) {
                    return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{cls, String.class, String.class}).invoke(null, parent, kind, appId);
                }
                return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{String.class, String.class}).invoke(null, kind, appId);
            }
            long id = jsonobj.getLong("id");
            String kind = jsonobj.getString("kind");
            Class keyFactory = clr.classForName("com.google.appengine.api.datastore.KeyFactory", cls.getClassLoader(), false);
            if (parent != null) {
                return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{cls, String.class, Long.TYPE}).invoke(null, parent, kind, id);
            }
            return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{String.class, Long.TYPE}).invoke(null, kind, id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

