/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.converters.TypeConverter;
import org.json.JSONException;
import org.json.JSONObject;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    JSONObject jsonobj;
    StoreManager storeMgr;

    public StoreFieldManager(ObjectProvider op, JSONObject jsonobj, boolean insert) {
        super(op, insert);
        this.storeMgr = op.getExecutionContext().getStoreManager();
        this.jsonobj = jsonobj;
        try {
            jsonobj.put("class", this.cmd.getFullClassName());
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        try {
            this.jsonobj.put(name, new Character(value));
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        try {
            if (value == null) {
                this.jsonobj.put(name, JSONObject.NULL);
            } else {
                this.jsonobj.put(name, value);
            }
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        int relationType = mmd.getRelationType(clr);
        if (Relation.isRelationSingleValued((int)relationType) && mmd.isEmbedded()) {
            throw new NucleusException("Embedded fields are not supported");
        }
        try {
            this.storeObjectFieldInternal(fieldNumber, value, mmd, clr);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    protected void storeObjectFieldInternal(int fieldNumber, Object value, AbstractMemberMetaData mmd, ClassLoaderResolver clr) throws JSONException {
        int relationType = mmd.getRelationType(clr);
        String name = this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        if (value == null) {
            this.jsonobj.put(name, JSONObject.NULL);
            return;
        }
        if (relationType == 0) {
            if (mmd.getTypeConverterName() != null) {
                TypeConverter conv = this.op.getExecutionContext().getTypeManager().getTypeConverterForName(mmd.getTypeConverterName());
                this.jsonobj.put(name, conv.toDatastoreType(value));
                return;
            }
            if (value instanceof Boolean) {
                this.jsonobj.put(name, (Boolean)value);
            } else if (value instanceof Integer) {
                this.jsonobj.put(name, (Integer)value);
            } else if (value instanceof Long) {
                this.jsonobj.put(name, (Long)value);
            } else if (value instanceof Double) {
                this.jsonobj.put(name, (Double)value);
            } else if (value instanceof Enum) {
                String jdbcType;
                ColumnMetaData[] colmds = mmd.getColumnMetaData();
                boolean persistAsString = true;
                if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null && ((jdbcType = colmds[0].getJdbcType()).equalsIgnoreCase("INTEGER") || jdbcType.equalsIgnoreCase("NUMERIC"))) {
                    persistAsString = false;
                }
                if (persistAsString) {
                    this.jsonobj.put(name, ((Enum)value).name());
                } else {
                    this.jsonobj.put(name, ((Enum)value).ordinal());
                }
            } else if (value instanceof BigDecimal) {
                this.jsonobj.put(name, value);
            } else if (value instanceof BigInteger) {
                this.jsonobj.put(name, value);
            } else if (value instanceof Collection) {
                this.jsonobj.put(name, value);
            } else if (value instanceof Map) {
                this.jsonobj.put(name, value);
            } else {
                String jdbc;
                boolean useLong = false;
                ColumnMetaData[] colmds = mmd.getColumnMetaData();
                if (colmds != null && colmds.length == 1 && (jdbc = colmds[0].getJdbcType()) != null && (jdbc.equalsIgnoreCase("INTEGER") || jdbc.equalsIgnoreCase("NUMERIC"))) {
                    useLong = true;
                }
                TypeConverter strConv = this.op.getExecutionContext().getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), String.class);
                TypeConverter longConv = this.op.getExecutionContext().getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), Long.class);
                if (useLong) {
                    if (longConv != null) {
                        this.jsonobj.put(name, longConv.toDatastoreType(value));
                        return;
                    }
                } else {
                    if (strConv != null) {
                        this.jsonobj.put(name, strConv.toDatastoreType(value));
                        return;
                    }
                    if (longConv != null) {
                        this.jsonobj.put(name, longConv.toDatastoreType(value));
                        return;
                    }
                }
                JSONObject jsonobjfield = new JSONObject(value);
                jsonobjfield.put("class", value.getClass().getName());
                this.jsonobj.put(name, jsonobjfield);
            }
            return;
        }
        if (Relation.isRelationSingleValued((int)relationType)) {
            Object valuePC = this.op.getExecutionContext().persistObjectInternal(value, this.op, fieldNumber, -1);
            Object valueId = this.op.getExecutionContext().getApiAdapter().getIdForObject(valuePC);
            this.jsonobj.put(name, valueId);
            return;
        }
        if (Relation.isRelationMultiValued((int)relationType)) {
            if (mmd.hasCollection()) {
                ArrayList<String> idColl = new ArrayList<String>();
                Collection coll = (Collection)value;
                for (Object element : coll) {
                    Object elementPC = this.op.getExecutionContext().persistObjectInternal(element, this.op, fieldNumber, -1);
                    Object elementID = this.op.getExecutionContext().getApiAdapter().getIdForObject(elementPC);
                    idColl.add(elementID.toString());
                }
                this.jsonobj.put(name, idColl);
                return;
            }
            if (mmd.hasArray()) {
                ArrayList<String> ids = new ArrayList<String>(Array.getLength(value));
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    Object elementPC = this.op.getExecutionContext().persistObjectInternal(element, this.op, fieldNumber, -1);
                    Object elementID = this.op.getExecutionContext().getApiAdapter().getIdForObject(elementPC);
                    ids.add(elementID.toString());
                }
                this.jsonobj.put(name, ids);
                return;
            }
            if (mmd.hasMap()) {
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.op.getExecutionContext().getMetaDataManager());
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, this.op.getExecutionContext().getMetaDataManager());
                HashMap<Object, Object> idMap = new HashMap<Object, Object>();
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    Object key = null;
                    Object val = null;
                    if (keyCmd != null) {
                        Object keyPC = this.op.getExecutionContext().persistObjectInternal(entry.getKey(), this.op, fieldNumber, -1);
                        key = this.op.getExecutionContext().getApiAdapter().getIdForObject(keyPC);
                    } else {
                        key = entry.getKey();
                    }
                    if (valCmd != null) {
                        Object valPC = this.op.getExecutionContext().persistObjectInternal(entry.getValue(), this.op, fieldNumber, -1);
                        val = this.op.getExecutionContext().getApiAdapter().getIdForObject(valPC);
                    } else {
                        val = entry.getValue();
                    }
                    idMap.put(key, val);
                }
                this.jsonobj.put(name, idMap);
                return;
            }
        }
        throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
    }
}

