/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.json.Base64;

public class CloudStorageUtils {
    private static final String UTF8_CHARSET = "UTF-8";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public static String hmac(String key, String data) {
        try {
            byte[] secretyKeyBytes = key.getBytes(UTF8_CHARSET);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretyKeyBytes, HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(secretKeySpec);
            byte[] rawHmac = mac.doFinal(data.getBytes(UTF8_CHARSET));
            return new String(Base64.encode(rawHmac));
        }
        catch (UnsupportedEncodingException e) {
            throw new NucleusException("UTF-8 is unsupported!", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getHTTPDate() {
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.ENGLISH);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return httpDateFormat.format(new Date());
    }
}

