/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues2;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.Type;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.JSONLogger;
import org.datanucleus.store.json.fieldmanager.FetchFieldManager;
import org.datanucleus.store.json.fieldmanager.InsertFieldManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonPersistenceHandler
extends AbstractPersistenceHandler {
    protected AbstractStoreManager storeMgr;

    JsonPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (AbstractStoreManager)storeMgr;
    }

    public void close() {
    }

    public String getURLPath(ObjectProvider sm) {
        String url = this.getURLPath(sm.getClassMetaData());
        JSONObject jsonobj = new JSONObject();
        sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)new InsertFieldManager(sm, jsonobj));
        try {
            url = url + jsonobj.get(JSONObject.getNames(jsonobj)[0]).toString();
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return url;
    }

    public String getURLPath(AbstractClassMetaData acmd) {
        String url = acmd.getValueForExtension("url");
        if (url == null) {
            url = acmd.getFullClassName();
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public String getURLPathForQuery(AbstractClassMetaData acmd) {
        String url = acmd.getValueForExtension("url");
        if (url == null) {
            url = acmd.getFullClassName();
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public void insertObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        int[] fieldNumbers = sm.getClassMetaData().getAllMemberPositions();
        Properties options = new Properties();
        ((Hashtable)options).put("org.datanucleus.store.json.url", this.getURLPath(sm));
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getExecutionContext(), (Map)options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        JSONObject jsonobj = new JSONObject();
        sm.provideFields(fieldNumbers, (FieldManager)new InsertFieldManager(sm, jsonobj));
        sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)new InsertFieldManager(sm, jsonobj));
        this.write("POST", conn.getURL().toExternalForm(), conn, jsonobj, this.getHeaders("POST", options));
    }

    public void updateObject(ObjectProvider sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        Properties options = new Properties();
        ((Hashtable)options).put("org.datanucleus.store.json.url", this.getURLPath(sm));
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getExecutionContext(), (Map)options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        JSONObject jsonobj = new JSONObject();
        sm.provideFields(fieldNumbers, (FieldManager)new InsertFieldManager(sm, jsonobj));
        sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)new InsertFieldManager(sm, jsonobj));
        this.write("PUT", conn.getURL().toExternalForm(), conn, jsonobj, this.getHeaders("PUT", options));
    }

    public void deleteObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        Properties options = new Properties();
        ((Hashtable)options).put("org.datanucleus.store.json.url", this.getURLPath(sm));
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getExecutionContext(), (Map)options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        try {
            HttpURLConnection http = (HttpURLConnection)conn;
            Map headers = this.getHeaders("DELETE", options);
            Iterator iterator = headers.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = (String)headers.get(key);
                http.setRequestProperty(key, value);
            }
            http.setRequestMethod("DELETE");
            http.setReadTimeout(10000);
            http.setConnectTimeout(10000);
            http.connect();
            int code = http.getResponseCode();
            if (code == 404) {
                throw new NucleusObjectNotFoundException();
            }
            this.handleHTTPErrorCode(http);
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected void handleHTTPErrorCode(HttpURLConnection http) throws IOException {
        if (http.getResponseCode() >= 400) {
            StringBuffer sb = new StringBuffer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            if (http.getErrorStream() != null) {
                int r;
                while ((r = http.getErrorStream().read(buffer)) != -1) {
                    baos.write(buffer, 0, r);
                }
                sb.append(new String(baos.toByteArray()));
                http.getErrorStream().close();
            }
            throw new NucleusDataStoreException("Error on URL: '" + http.getURL().toExternalForm() + "' Request Method: " + http.getRequestMethod() + " HTTP Error code: " + http.getResponseCode() + " " + http.getResponseMessage() + " error: " + sb.toString());
        }
        if (http.getResponseCode() >= 300) {
            throw new NucleusDataStoreException("Redirect not supported. HTTP Error code: " + http.getResponseCode() + " " + http.getResponseMessage());
        }
    }

    public void fetchObject(ObjectProvider sm, int[] fieldNumbers) {
        JSONObject jsonobj = new JSONObject();
        sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)new InsertFieldManager(sm, jsonobj));
        Properties options = new Properties();
        ((Hashtable)options).put("org.datanucleus.store.json.url", this.getURLPath(sm));
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getExecutionContext(), (Map)options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        JSONObject result = this.read("GET", conn.getURL().toExternalForm(), conn, this.getHeaders("GET", options));
        sm.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(sm, result));
    }

    public Object findObject(ExecutionContext om, Object id) {
        return null;
    }

    public void locateObject(ObjectProvider sm) {
        Properties options = new Properties();
        ((Hashtable)options).put("org.datanucleus.store.json.url", this.getURLPath(sm));
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getExecutionContext(), (Map)options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        try {
            HttpURLConnection http = (HttpURLConnection)conn;
            Map headers = this.getHeaders("HEAD", options);
            Iterator iterator = headers.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = (String)headers.get(key);
                http.setRequestProperty(key, value);
            }
            http.setDoOutput(true);
            http.setRequestMethod("HEAD");
            http.setReadTimeout(10000);
            http.setConnectTimeout(10000);
            http.connect();
            int code = http.getResponseCode();
            if (code == 404) {
                throw new NucleusObjectNotFoundException();
            }
            this.handleHTTPErrorCode(http);
        }
        catch (IOException e) {
            throw new NucleusObjectNotFoundException(e.getMessage(), (Object)e);
        }
    }

    protected void write(String method, String requestUri, URLConnection conn, JSONObject jsonobj, Map headers) {
        try {
            if (JSONLogger.LOGGER.isDebugEnabled()) {
                JSONLogger.LOGGER.debug((Object)("Writing to URL " + requestUri + " content " + jsonobj.toString()));
            }
            int length = jsonobj.toString().length();
            HttpURLConnection http = (HttpURLConnection)conn;
            Iterator iterator = headers.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = (String)headers.get(key);
                http.setRequestProperty(key, value);
            }
            http.setRequestProperty("Content-Length", "" + length);
            http.setDoOutput(true);
            http.setRequestMethod(method);
            http.setReadTimeout(10000);
            http.setConnectTimeout(10000);
            http.connect();
            OutputStream os = conn.getOutputStream();
            os.write(jsonobj.toString().getBytes());
            os.flush();
            os.close();
            this.handleHTTPErrorCode(http);
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected JSONObject read(String method, String requestUri, URLConnection conn, Map headers) {
        try {
            HttpURLConnection http = (HttpURLConnection)conn;
            Iterator iterator = headers.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = (String)headers.get(key);
                http.setRequestProperty(key, value);
            }
            http.setDoInput(true);
            http.setRequestMethod(method);
            http.setReadTimeout(10000);
            http.setConnectTimeout(10000);
            http.connect();
            int code = http.getResponseCode();
            if (code == 404) {
                throw new NucleusObjectNotFoundException();
            }
            http.getResponseMessage();
            StringBuffer sb = new StringBuffer();
            if (http.getContentLength() > 0) {
                for (int i = 0; i < http.getContentLength(); ++i) {
                    sb.append((char)http.getInputStream().read());
                }
            } else {
                int r;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((r = http.getInputStream().read(buffer)) != -1) {
                    baos.write(buffer, 0, r);
                }
                sb.append(new String(baos.toByteArray()));
            }
            http.getInputStream().close();
            return new JSONObject(sb.toString());
        }
        catch (SocketTimeoutException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected Map getHeaders(String httpVerb, Map options) {
        return Collections.EMPTY_MAP;
    }

    public List getObjectsOfCandidateType(ExecutionContext om, ManagedConnection mconn, Class candidateClass, boolean ignoreCache, Map options) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            JSONArray jsonarray;
            URLConnection conn = (URLConnection)mconn.getConnection();
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            final AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
            try {
                HttpURLConnection http = (HttpURLConnection)conn;
                Map headers = this.getHeaders("GET", options);
                Iterator iterator = headers.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String value = (String)headers.get(key);
                    http.setRequestProperty(key, value);
                }
                http.setDoInput(true);
                http.setRequestMethod("GET");
                http.setReadTimeout(10000);
                http.setConnectTimeout(10000);
                http.connect();
                int code = http.getResponseCode();
                if (code == 404) {
                    return Collections.EMPTY_LIST;
                }
                http.getResponseMessage();
                StringBuffer sb = new StringBuffer();
                if (http.getContentLength() > 0) {
                    for (int i = 0; i < http.getContentLength(); ++i) {
                        sb.append((char)http.getInputStream().read());
                    }
                } else {
                    int r;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((r = http.getInputStream().read(buffer)) != -1) {
                        baos.write(buffer, 0, r);
                    }
                    sb.append(new String(baos.toByteArray()));
                }
                http.getInputStream().close();
                jsonarray = new JSONArray(sb.toString());
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (JSONException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            for (int i = 0; i < jsonarray.length(); ++i) {
                final JSONObject json = jsonarray.getJSONObject(i);
                results.add(om.findObjectUsingAID(new Type(clr.classForName(cmd.getFullClassName())), new FieldValues2(){

                    public void fetchFields(ObjectProvider sm) {
                        sm.replaceFields(cmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(sm, json));
                    }

                    public void fetchNonLoadedFields(ObjectProvider sm) {
                        sm.replaceNonLoadedFields(cmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(sm, json));
                    }

                    public FetchPlan getFetchPlanForLoading() {
                        return null;
                    }
                }, ignoreCache, true));
            }
        }
        catch (JSONException je) {
            throw new NucleusException(je.getMessage(), (Throwable)je);
        }
        return results;
    }
}

