/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.jdo.JDONullIdentityException;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.JDOStateManagerImpl;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.TypeConversionHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchFieldManager
implements FieldManager {
    StateManager sm;
    JSONObject result;
    static /* synthetic */ Class class$java$lang$String;

    public FetchFieldManager(StateManager sm, JSONObject result) {
        this.sm = sm;
        this.result = result;
    }

    public String fetchStringField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return null;
        }
        try {
            return this.result.getString(fieldName);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public short fetchShortField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0;
        }
        try {
            return (short)this.result.getInt(fieldName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return null;
        }
        try {
            Object value = this.result.get(fieldName);
            if (value instanceof JSONObject) {
                return this.getObjectFromJSONObject((JSONObject)value, mmd.getType().getName(), this.sm.getObjectManager());
            }
            if (value instanceof JSONArray) {
                return this.fetchJSONArray((JSONArray)value, fieldNumber, this.sm.getObjectManager(), this.sm.getClassMetaData());
            }
            return TypeConversionHelper.convertTo((Object)this.result.get(fieldName), (Class)mmd.getType());
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    private List fetchJSONArray(JSONArray array, int position, ObjectManager om, AbstractClassMetaData cmd) throws JSONException {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            if (array.isNull(i)) {
                elements.add(null);
                continue;
            }
            Object value = array.get(i);
            if (value instanceof JSONObject) {
                elements.add(this.getObjectFromJSONObject((JSONObject)value, ((JSONObject)value).getString("class"), om));
                continue;
            }
            if (value instanceof JSONArray) {
                elements.add(this.fetchJSONArray((JSONArray)value, position, om, cmd));
                continue;
            }
            elements.add(TypeConversionHelper.convertTo((Object)value, (Class)cmd.getMetaDataForMemberAtRelativePosition(position).getType()));
        }
        return elements;
    }

    public long fetchLongField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0L;
        }
        try {
            return this.result.getLong(fieldName);
        }
        catch (JSONException e) {
            return 0L;
        }
    }

    public int fetchIntField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0;
        }
        try {
            return this.result.getInt(fieldName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public float fetchFloatField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0.0f;
        }
        try {
            return (float)this.result.getDouble(fieldName);
        }
        catch (JSONException e) {
            return 0.0f;
        }
    }

    public double fetchDoubleField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0.0;
        }
        try {
            return this.result.getDouble(fieldName);
        }
        catch (JSONException e) {
            return 0.0;
        }
    }

    public char fetchCharField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return '\u0000';
        }
        try {
            return this.result.getString(fieldName).charAt(0);
        }
        catch (JSONException e) {
            return '\u0000';
        }
    }

    public byte fetchByteField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0;
        }
        try {
            String str = this.result.getString(fieldName);
            return new Byte(str);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return false;
        }
        try {
            return this.result.getBoolean(fieldName);
        }
        catch (JSONException e) {
            return false;
        }
    }

    public void storeStringField(int fieldNumber, String value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    public void storeObjectField(int fieldNumber, Object value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    protected Object getObjectFromJSONObject(JSONObject jsonobj, String className, ObjectManager om) {
        OMFContext ctx = om.getOMFContext();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class cls = clr.classForName(className, true);
        AbstractClassMetaData cmd = ctx.getMetaDataManager().getMetaDataForClass(cls, clr);
        if (cmd == null) {
            return this.getObject(clr, jsonobj, cls);
        }
        int[] fieldNumbers = cmd.getAllMemberPositions();
        LocalSM sm1 = null;
        sm1 = new LocalSM(cls);
        sm1.replaceFields(fieldNumbers, new LocalFieldManager(jsonobj, null, cmd, om));
        Object obj = sm1.getObject();
        try {
            Object id = om.getApiAdapter().getNewApplicationIdentityObjectId(sm1.getObject(), cmd);
            obj = om.findObject(id, false, true, null);
            JDOStateManagerImpl sm = (JDOStateManagerImpl)om.findStateManager(obj);
            fieldNumbers = cmd.getNonPKMemberPositions();
            sm.replaceFields(fieldNumbers, (FieldManager)new LocalFieldManager(jsonobj, (StateManager)sm, cmd, om));
            return obj;
        }
        catch (JDONullIdentityException ex) {
            sm1.disconnect();
            return obj;
        }
        catch (JDOObjectNotFoundException ex) {
            sm1.disconnect();
            return obj;
        }
    }

    private Object getObject(ClassLoaderResolver clr, final JSONObject jsonobj, final Class cls) {
        if (cls.getName().equals("com.google.appengine.api.users.User")) {
            String email = null;
            String authDomain = null;
            try {
                email = jsonobj.getString("email");
            }
            catch (JSONException e) {
                // empty catch block
            }
            try {
                authDomain = jsonobj.getString("authDomain");
            }
            catch (JSONException e) {
                // empty catch block
            }
            return ClassUtils.newInstance((Class)cls, (Class[])new Class[]{class$java$lang$String == null ? (class$java$lang$String = FetchFieldManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = FetchFieldManager.class$("java.lang.String")) : class$java$lang$String}, (Object[])new String[]{email, authDomain});
        }
        if (cls.getName().equals("com.google.appengine.api.datastore.Key")) {
            try {
                Object parent = null;
                if (jsonobj.has("parent") && !jsonobj.isNull("parent")) {
                    JSONObject parentobj = jsonobj.getJSONObject("parent");
                    parent = this.getObject(clr, parentobj, clr.classForName(jsonobj.getString("class")));
                }
                if (jsonobj.has("appId")) {
                    String appId = jsonobj.getString("appId");
                    String kind = jsonobj.getString("kind");
                    Class<?> keyFactory = Class.forName("com.google.appengine.api.datastore.KeyFactory", false, cls.getClassLoader());
                    if (parent != null) {
                        return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{cls, class$java$lang$String == null ? (class$java$lang$String = FetchFieldManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = FetchFieldManager.class$("java.lang.String")) : class$java$lang$String}).invoke(null, parent, kind, appId);
                    }
                    return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{class$java$lang$String == null ? (class$java$lang$String = FetchFieldManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = FetchFieldManager.class$("java.lang.String")) : class$java$lang$String}).invoke(null, kind, appId);
                }
                long id = jsonobj.getLong("id");
                String kind = jsonobj.getString("kind");
                Class<?> keyFactory = Class.forName("com.google.appengine.api.datastore.KeyFactory", false, cls.getClassLoader());
                if (parent != null) {
                    return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{cls, class$java$lang$String == null ? (class$java$lang$String = FetchFieldManager.class$("java.lang.String")) : class$java$lang$String, Long.TYPE}).invoke(null, parent, kind, new Long(id));
                }
                return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{class$java$lang$String == null ? (class$java$lang$String = FetchFieldManager.class$("java.lang.String")) : class$java$lang$String, Long.TYPE}).invoke(null, kind, new Long(id));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Constructor c = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[0]);
                        ((AccessibleObject)c).setAccessible(true);
                        Object obj = c.newInstance(new Object[0]);
                        String[] fieldNames = JSONObject.getNames(jsonobj);
                        for (int i = 0; i < jsonobj.length(); ++i) {
                            if (fieldNames[i].equals("class")) continue;
                            Field field = cls.getField(fieldNames[i]);
                            ((AccessibleObject)field).setAccessible(true);
                            field.set(obj, jsonobj.get(fieldNames[i]));
                        }
                        return obj;
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LocalSM
    implements javax.jdo.spi.StateManager {
        PersistenceCapable myPC;
        FieldManager fm;

        public LocalSM(Class cls) {
            this.myPC = JDOImplHelper.getInstance().newInstance(cls, (javax.jdo.spi.StateManager)this);
        }

        public boolean getBooleanField(PersistenceCapable arg0, int arg1, boolean arg2) {
            return false;
        }

        public byte getByteField(PersistenceCapable arg0, int arg1, byte arg2) {
            return 0;
        }

        public char getCharField(PersistenceCapable arg0, int arg1, char arg2) {
            return '\u0000';
        }

        public double getDoubleField(PersistenceCapable arg0, int arg1, double arg2) {
            return 0.0;
        }

        public float getFloatField(PersistenceCapable arg0, int arg1, float arg2) {
            return 0.0f;
        }

        public int getIntField(PersistenceCapable arg0, int arg1, int arg2) {
            return 0;
        }

        public long getLongField(PersistenceCapable arg0, int arg1, long arg2) {
            return 0L;
        }

        public Object getObjectField(PersistenceCapable arg0, int arg1, Object arg2) {
            return null;
        }

        public Object getObjectId(PersistenceCapable arg0) {
            return null;
        }

        public PersistenceManager getPersistenceManager(PersistenceCapable arg0) {
            return null;
        }

        public short getShortField(PersistenceCapable arg0, int arg1, short arg2) {
            return 0;
        }

        public String getStringField(PersistenceCapable arg0, int arg1, String arg2) {
            return null;
        }

        public Object getTransactionalObjectId(PersistenceCapable arg0) {
            return null;
        }

        public Object getVersion(PersistenceCapable arg0) {
            return null;
        }

        public boolean isDeleted(PersistenceCapable arg0) {
            return false;
        }

        public boolean isDirty(PersistenceCapable arg0) {
            return false;
        }

        public boolean isLoaded(PersistenceCapable arg0, int arg1) {
            return false;
        }

        public boolean isNew(PersistenceCapable arg0) {
            return false;
        }

        public boolean isPersistent(PersistenceCapable arg0) {
            return false;
        }

        public boolean isTransactional(PersistenceCapable arg0) {
            return false;
        }

        public void makeDirty(PersistenceCapable arg0, String arg1) {
        }

        public void preSerialize(PersistenceCapable arg0) {
        }

        public void providedBooleanField(PersistenceCapable arg0, int arg1, boolean arg2) {
        }

        public void providedByteField(PersistenceCapable arg0, int arg1, byte arg2) {
        }

        public void providedCharField(PersistenceCapable arg0, int arg1, char arg2) {
        }

        public void providedDoubleField(PersistenceCapable arg0, int arg1, double arg2) {
        }

        public void providedFloatField(PersistenceCapable arg0, int arg1, float arg2) {
        }

        public void providedIntField(PersistenceCapable arg0, int arg1, int arg2) {
        }

        public void providedLongField(PersistenceCapable arg0, int arg1, long arg2) {
        }

        public void providedObjectField(PersistenceCapable arg0, int arg1, Object arg2) {
        }

        public void providedShortField(PersistenceCapable arg0, int arg1, short arg2) {
        }

        public void providedStringField(PersistenceCapable arg0, int arg1, String arg2) {
        }

        public boolean replacingBooleanField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchBooleanField(arg1);
        }

        public byte replacingByteField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchByteField(arg1);
        }

        public char replacingCharField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchCharField(arg1);
        }

        public Object[] replacingDetachedState(Detachable arg0, Object[] arg1) {
            return null;
        }

        public double replacingDoubleField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchDoubleField(arg1);
        }

        public byte replacingFlags(PersistenceCapable arg0) {
            return 0;
        }

        public float replacingFloatField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchFloatField(arg1);
        }

        public int replacingIntField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchIntField(arg1);
        }

        public long replacingLongField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchLongField(arg1);
        }

        public Object replacingObjectField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchObjectField(arg1);
        }

        public short replacingShortField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchShortField(arg1);
        }

        public javax.jdo.spi.StateManager replacingStateManager(PersistenceCapable arg0, javax.jdo.spi.StateManager arg1) {
            return null;
        }

        public String replacingStringField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchStringField(arg1);
        }

        public void setBooleanField(PersistenceCapable arg0, int arg1, boolean arg2, boolean arg3) {
        }

        public void setByteField(PersistenceCapable arg0, int arg1, byte arg2, byte arg3) {
        }

        public void setCharField(PersistenceCapable arg0, int arg1, char arg2, char arg3) {
        }

        public void setDoubleField(PersistenceCapable arg0, int arg1, double arg2, double arg3) {
        }

        public void setFloatField(PersistenceCapable arg0, int arg1, float arg2, float arg3) {
        }

        public void setIntField(PersistenceCapable arg0, int arg1, int arg2, int arg3) {
        }

        public void setLongField(PersistenceCapable arg0, int arg1, long arg2, long arg3) {
        }

        public void setObjectField(PersistenceCapable arg0, int arg1, Object arg2, Object arg3) {
        }

        public void setShortField(PersistenceCapable arg0, int arg1, short arg2, short arg3) {
        }

        public void setStringField(PersistenceCapable arg0, int arg1, String arg2, String arg3) {
        }

        void replaceFields(int[] fieldNumbers, FieldManager fm) {
            this.fm = fm;
            this.myPC.jdoReplaceFields(fieldNumbers);
        }

        public Object getObject() {
            return this.myPC;
        }

        public void disconnect() {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        LocalSM.this.myPC.jdoReplaceStateManager(null);
                        return null;
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    class LocalFieldManager
    implements FieldManager {
        JSONObject jsonobj;
        AbstractClassMetaData cmd;
        StateManager sm;
        ObjectManager pm;

        LocalFieldManager(JSONObject jsonobj, StateManager sm, AbstractClassMetaData cmd, ObjectManager pm) {
            this.jsonobj = jsonobj;
            this.cmd = cmd;
            this.sm = sm;
            this.pm = pm;
        }

        public String fetchStringField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return null;
            }
            try {
                String value = this.jsonobj.getString(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return null;
            }
        }

        public short fetchShortField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0;
            }
            try {
                short value = (short)this.jsonobj.getInt(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }

        public Object fetchObjectField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return null;
            }
            try {
                if (this.jsonobj.isNull(fieldName)) {
                    return null;
                }
                Object value = this.jsonobj.get(fieldName);
                if (value instanceof JSONObject) {
                    value = FetchFieldManager.this.getObjectFromJSONObject((JSONObject)value, ((JSONObject)value).getString("class"), this.pm);
                    if (this.sm != null) {
                        this.sm.makeDirty(position);
                    }
                    return value;
                }
                if (value instanceof JSONArray) {
                    value = this.fetchJSONArray((JSONArray)value, position);
                    if (this.sm != null) {
                        this.sm.makeDirty(position);
                    }
                    return value;
                }
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return TypeConversionHelper.convertTo((Object)value, (Class)this.cmd.getMetaDataForMemberAtRelativePosition(position).getType());
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }

        private List fetchJSONArray(JSONArray array, int position) throws JSONException {
            ArrayList<Object> elements = new ArrayList<Object>();
            for (int i = 0; i < array.length(); ++i) {
                if (array.isNull(i)) {
                    elements.add(null);
                    continue;
                }
                Object value = array.get(i);
                if (value instanceof JSONObject) {
                    elements.add(FetchFieldManager.this.getObjectFromJSONObject((JSONObject)value, ((JSONObject)value).getString("class"), this.pm));
                    continue;
                }
                if (value instanceof JSONArray) {
                    elements.add(this.fetchJSONArray((JSONArray)value, position));
                    continue;
                }
                elements.add(TypeConversionHelper.convertTo((Object)value, (Class)this.cmd.getMetaDataForMemberAtRelativePosition(position).getType()));
            }
            return elements;
        }

        public long fetchLongField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0L;
            }
            try {
                long value = this.jsonobj.getLong(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0L;
            }
        }

        public int fetchIntField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0;
            }
            try {
                int value = this.jsonobj.getInt(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }

        public float fetchFloatField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0.0f;
            }
            try {
                float value = (float)this.jsonobj.getDouble(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0.0f;
            }
        }

        public double fetchDoubleField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0.0;
            }
            try {
                double value = this.jsonobj.getDouble(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0.0;
            }
        }

        public char fetchCharField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return '\u0000';
            }
            try {
                String str = this.jsonobj.getString(fieldName);
                char value = '\u0000';
                if (str != null && str.length() > 0) {
                    value = str.charAt(0);
                }
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return '\u0000';
            }
        }

        public byte fetchByteField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0;
            }
            try {
                String str = this.jsonobj.getString(fieldName);
                byte value = 0;
                if (str != null && str.length() > 0) {
                    value = str.getBytes()[0];
                }
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }

        public boolean fetchBooleanField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return false;
            }
            try {
                boolean value = this.jsonobj.getBoolean(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return false;
            }
        }

        public void storeStringField(int arg0, String arg1) {
        }

        public void storeShortField(int arg0, short arg1) {
        }

        public void storeObjectField(int arg0, Object arg1) {
        }

        public void storeLongField(int arg0, long arg1) {
        }

        public void storeIntField(int arg0, int arg1) {
        }

        public void storeFloatField(int arg0, float arg1) {
        }

        public void storeDoubleField(int arg0, double arg1) {
        }

        public void storeCharField(int arg0, char arg1) {
        }

        public void storeByteField(int arg0, byte arg1) {
        }

        public void storeBooleanField(int arg0, boolean arg1) {
        }
    }
}

