/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.fieldmanager.FetchFieldManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtils {
    public static List getObjectsOfCandidateType(ObjectManager om, ManagedConnection mconn, Class candidateClass, boolean ignoreCache) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            JSONArray jsonarray;
            URLConnection conn = (URLConnection)mconn.getConnection();
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            final AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
            String url = cmd.getValueForExtension("url");
            Properties options = new Properties();
            if (url != null) {
                ((Hashtable)options).put("org.datanucleus.store.json.url", url);
            }
            try {
                HttpURLConnection http = (HttpURLConnection)conn;
                http.setDoInput(true);
                http.setRequestMethod("GET");
                http.setReadTimeout(10000);
                http.connect();
                int code = http.getResponseCode();
                if (code == 404) {
                    return Collections.EMPTY_LIST;
                }
                http.getResponseMessage();
                StringBuffer sb = new StringBuffer();
                if (http.getContentLength() > 0) {
                    for (int i = 0; i < http.getContentLength(); ++i) {
                        sb.append((char)http.getInputStream().read());
                    }
                } else {
                    int r;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((r = http.getInputStream().read(buffer)) != -1) {
                        baos.write(buffer, 0, r);
                    }
                    sb.append(new String(baos.toByteArray()));
                }
                http.getInputStream().close();
                jsonarray = new JSONArray(sb.toString());
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (JSONException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            for (int i = 0; i < jsonarray.length(); ++i) {
                final JSONObject json = jsonarray.getJSONObject(i);
                results.add(om.findObjectUsingAID(clr.classForName(cmd.getFullClassName()), new FieldValues(){

                    public void fetchFields(StateManager sm) {
                        sm.replaceFields(cmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(sm, json));
                    }

                    public void fetchNonLoadedFields(StateManager sm) {
                        sm.replaceNonLoadedFields(cmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(sm, json));
                    }

                    public FetchPlan getFetchPlanForLoading() {
                        return null;
                    }
                }, ignoreCache, true));
            }
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        return results;
    }
}

