/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchFieldManager
implements FieldManager {
    StateManager sm;
    JSONObject result;

    public FetchFieldManager(StateManager sm, JSONObject result) {
        this.sm = sm;
        this.result = result;
    }

    public String fetchStringField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return null;
        }
        try {
            return this.result.getString(fieldName);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public short fetchShortField(int fieldNumber) {
        return 0;
    }

    public Object fetchObjectField(int fieldNumber) {
        throw new NucleusException("Report to JPOX.").setFatal();
    }

    public long fetchLongField(int fieldNumber) {
        try {
            return this.result.getLong(this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName());
        }
        catch (JSONException e) {
            return 0L;
        }
    }

    public int fetchIntField(int fieldNumber) {
        try {
            return this.result.getInt(this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName());
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public float fetchFloatField(int fieldNumber) {
        return 0.0f;
    }

    public double fetchDoubleField(int fieldNumber) {
        return 0.0;
    }

    public char fetchCharField(int fieldNumber) {
        return '\u0000';
    }

    public byte fetchByteField(int fieldNumber) {
        return 0;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return false;
    }

    public void storeStringField(int fieldNumber, String value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    public void storeObjectField(int fieldNumber, Object value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }
}

