/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa.beanvalidation;

import java.lang.reflect.Constructor;
import javax.persistence.PersistenceException;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.state.CallbackHandler;

public class BeanValidatorHandlerFactory {
    public static CallbackHandler newInstance(ObjectManager om) {
        PersistenceConfiguration conf = om.getOMFContext().getPersistenceConfiguration();
        if (conf.hasProperty("javax.persistence.validation.mode") && conf.getStringProperty("javax.persistence.validation.mode").equalsIgnoreCase("none")) {
            return null;
        }
        try {
            Class cls = om.getClassLoaderResolver().classForName("org.datanucleus.jpa.beanvalidation.BeanValidatorHandler");
            Constructor constructor = cls.getConstructor(ObjectManager.class);
            return (CallbackHandler)constructor.newInstance(om);
        }
        catch (Throwable ex) {
            if (conf.hasProperty("javax.persistence.validation.mode") && conf.getStringProperty("javax.persistence.validation.mode").equalsIgnoreCase("callback")) {
                throw new PersistenceException(ex.getMessage(), ex);
            }
            return null;
        }
    }
}

