/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.metadata;

public enum MetaDataExtension {
    IN_MEMORY("inMemory"),
    BLOOM_FILTER("bloomFilter"),
    KEEP_DELETED_CELLS("keepDeletedCells"),
    COMPRESSION("compression"),
    BLOCK_CACHE_ENABLED("blockCacheEnabled"),
    TIME_TO_LIVE("timeToLive"),
    MAX_VERSIONS("maxVersions");

    private String value;

    private MetaDataExtension(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static MetaDataExtension parse(String extension) {
        if (extension == null) {
            return null;
        }
        try {
            return MetaDataExtension.valueOf(extension);
        }
        catch (IllegalArgumentException e) {
            for (MetaDataExtension ext : MetaDataExtension.values()) {
                if (!ext.value.equalsIgnoreCase(extension)) continue;
                return ext;
            }
            return null;
        }
    }
}

