/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.DatastoreIdentityMetaData;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.hbase.HBaseMetaDataListener;
import org.datanucleus.store.hbase.HBasePersistenceHandler;
import org.datanucleus.store.hbase.HBaseSchemaHandler;
import org.datanucleus.store.hbase.query.JDOQLQuery;
import org.datanucleus.store.hbase.query.JPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;

public class HBaseStoreManager
extends AbstractStoreManager
implements SchemaAwareStoreManager {
    public static final String RELATION_IDENTITY_STORAGE_HBASE_LEGACY = "HBaseLegacy";
    public static final String PROPERTY_HBASE_ENFORCE_UNIQUENESS_IN_APPLICATION = "datanucleus.hbase.enforceUniquenessInApplication";
    public static final String PROPERTY_HBASE_SERIALISED_PK = "datanucleus.hbase.serialisedPK";
    public static final String PROPERTY_HBASE_TABLE_POOL_MAXSIZE = "datanucleus.hbase.tablePoolMaxSize";
    MetaDataListener metadataListener;
    private Configuration hbaseConfig;

    public HBaseStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext ctx, Map<String, Object> props) {
        super("hbase", clr, ctx, props);
        this.schemaHandler = new HBaseSchemaHandler((StoreManager)this);
        this.persistenceHandler = new HBasePersistenceHandler((StoreManager)this);
        this.connectionMgr.disableConnectionCaching();
        this.metadataListener = new HBaseMetaDataListener(this);
        MetaDataManager mmgr = this.nucleusContext.getMetaDataManager();
        mmgr.registerListener(this.metadataListener);
        Collection classNamesLoaded = mmgr.getClassesWithMetaData();
        if (classNamesLoaded != null && !classNamesLoaded.isEmpty()) {
            for (String className : classNamesLoaded) {
                AbstractClassMetaData cmd = mmgr.getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                this.metadataListener.loaded(cmd);
            }
        }
        this.logConfiguration();
    }

    public synchronized void close() {
        this.nucleusContext.getMetaDataManager().deregisterListener(this.metadataListener);
        super.close();
    }

    public NucleusConnection getNucleusConnection(ExecutionContext om) {
        throw new UnsupportedOperationException();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationId");
        set.add("ApplicationCompositeId");
        set.add("DatastoreId");
        set.add("NonDurableId");
        set.add("ORM");
        set.add("ORM.EmbeddedPC");
        set.add("ORM.SerialisedPC");
        set.add("TransactionIsolationLevel.read-committed");
        set.add("Query.JDOQL.BulkDelete");
        set.add("Query.JPQL.BulkDelete");
        set.add("ORM.Inheritance.CompleteTable");
        return set;
    }

    public Query newQuery(String language, ExecutionContext ec) {
        if (language.equals(QueryLanguage.JDOQL.name())) {
            return new JDOQLQuery((StoreManager)this, ec);
        }
        if (language.equals(QueryLanguage.JPQL.name())) {
            return new JPQLQuery((StoreManager)this, ec);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public Query newQuery(String language, ExecutionContext ec, String queryString) {
        if (language.equals(QueryLanguage.JDOQL.name())) {
            return new JDOQLQuery((StoreManager)this, ec, queryString);
        }
        if (language.equals(QueryLanguage.JPQL.name())) {
            return new JPQLQuery((StoreManager)this, ec, queryString);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public Query newQuery(String language, ExecutionContext ec, Query q) {
        if (language.equals(QueryLanguage.JDOQL.name())) {
            return new JDOQLQuery((StoreManager)this, ec, (JDOQLQuery)q);
        }
        if (language.equals(QueryLanguage.JPQL.name())) {
            return new JPQLQuery((StoreManager)this, ec, (JPQLQuery)q);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public Configuration getHbaseConfig() {
        if (this.hbaseConfig == null) {
            this.hbaseConfig = HBaseConfiguration.create();
        }
        return this.hbaseConfig;
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        return super.getClassNameForObjectID(id, clr, ec);
    }

    public void manageClasses(ClassLoaderResolver clr, String ... classNames) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        HashSet<String> clsNameSet = new HashSet<String>();
        for (ClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd.isEmbeddedOnly() || cmd.isAbstract() || this.storeDataMgr.managesClass(cmd.getFullClassName())) continue;
            StoreData sd = this.storeDataMgr.get(cmd.getFullClassName());
            if (sd == null) {
                CompleteClassTable table = new CompleteClassTable((StoreManager)this, (AbstractClassMetaData)cmd, null);
                sd = this.newStoreData(cmd, clr);
                sd.setTable((Table)table);
                this.registerStoreData(sd);
            }
            clsNameSet.add(cmd.getFullClassName());
        }
        this.getSchemaHandler().createSchemaForClasses(clsNameSet, null, null);
    }

    protected Properties getPropertiesForValueGenerator(AbstractClassMetaData cmd, int absoluteFieldNumber, ClassLoaderResolver clr, SequenceMetaData seqmd, TableGeneratorMetaData tablegenmd) {
        Properties props = super.getPropertiesForValueGenerator(cmd, absoluteFieldNumber, clr, seqmd, tablegenmd);
        if (!this.managesClass(cmd.getFullClassName())) {
            this.manageClasses(clr, cmd.getFullClassName());
        }
        ValueGenerationStrategy strategy = null;
        if (absoluteFieldNumber >= 0) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            strategy = mmd.getValueStrategy();
        } else {
            DatastoreIdentityMetaData idmd = cmd.getBaseDatastoreIdentityMetaData();
            strategy = idmd.getValueStrategy();
        }
        Table table = this.getStoreDataForClass(cmd.getFullClassName()).getTable();
        props.setProperty("table-name", table.getName());
        if (strategy == ValueGenerationStrategy.INCREMENT && tablegenmd != null) {
            props.remove("table-name");
        }
        return props;
    }

    public void createDatabase(String catalogName, String schemaName, Properties props) {
        this.schemaHandler.createDatabase(catalogName, schemaName, props, null);
    }

    public void deleteDatabase(String catalogName, String schemaName, Properties props) {
        this.schemaHandler.deleteDatabase(catalogName, schemaName, props, null);
    }

    public void createSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.createSchemaForClasses(classNames, props, null);
    }

    public void deleteSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.deleteSchemaForClasses(classNames, props, null);
    }

    public void validateSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.validateSchema(classNames, props, null);
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());
    }
}

