/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.types.converters.TypeConverter;

public class HBaseUtils {
    private HBaseUtils() {
    }

    public static String getDefaultValueForMember(AbstractMemberMetaData mmd) {
        ColumnMetaData[] colmds = mmd.getColumnMetaData();
        if (colmds == null || colmds.length < 1) {
            return null;
        }
        return colmds[0].getDefaultValue();
    }

    public static String getFamilyNameForColumn(Column col) {
        if (col == null) {
            return null;
        }
        String colName = col.getName();
        if (colName != null && colName.indexOf(":") > 0) {
            return colName.substring(0, colName.indexOf(":"));
        }
        return col.getTable().getName();
    }

    public static String getQualifierNameForColumn(Column col) {
        if (col == null) {
            return null;
        }
        String colName = col.getName();
        if (colName != null && colName.indexOf(":") > 0) {
            return colName.substring(colName.indexOf(":") + 1);
        }
        return colName;
    }

    public static Object getVersionForObject(AbstractClassMetaData cmd, Result result, ExecutionContext ec, org.datanucleus.store.schema.table.Table table, StoreManager storeMgr) {
        String tableName = table.getName();
        if (cmd.isVersioned()) {
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                Column col = table.getMemberColumnMappingForMember(verMmd).getColumn(0);
                String familyName = HBaseUtils.getFamilyNameForColumn(col);
                String qualifName = HBaseUtils.getQualifierNameForColumn(col);
                Object version = null;
                try {
                    byte[] bytes = result.getValue(familyName.getBytes(), qualifName.getBytes());
                    if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                        version = verMmd.getType() == Integer.class || verMmd.getType() == Integer.TYPE ? (Number)Bytes.toInt((byte[])bytes) : (Number)Bytes.toLong((byte[])bytes);
                    } else if (Date.class.isAssignableFrom(verMmd.getType())) {
                        String strValue = new String(bytes);
                        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(verMmd.getType(), String.class);
                        version = strConv.toMemberType((Object)strValue);
                        version = new Timestamp(((Date)version).getTime());
                    } else {
                        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                        ObjectInputStream ois = new ObjectInputStream(bis);
                        version = ois.readObject();
                        ois.close();
                        bis.close();
                    }
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
                return version;
            }
            return HBaseUtils.getSurrogateVersionForObject(cmd, result, tableName, storeMgr);
        }
        return null;
    }

    public static Object getSurrogateVersionForObject(AbstractClassMetaData cmd, Result result, String tableName, StoreManager storeMgr) {
        org.datanucleus.store.schema.table.Table table = storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
        VersionMetaData vermd = cmd.getVersionMetaDataForClass();
        String familyName = HBaseUtils.getFamilyNameForColumn(table.getSurrogateColumn(SurrogateColumnType.VERSION));
        String qualifName = HBaseUtils.getQualifierNameForColumn(table.getSurrogateColumn(SurrogateColumnType.VERSION));
        Object version = null;
        try {
            byte[] bytes = result.getValue(familyName.getBytes(), qualifName.getBytes());
            if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                version = Bytes.toLong((byte[])bytes);
            } else {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                version = ois.readObject();
                ois.close();
                bis.close();
            }
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return version;
    }

    public static Put getPutForObject(DNStateManager sm, org.datanucleus.store.schema.table.Table schemaTable) throws IOException {
        byte[] rowKey = (byte[])sm.getAssociatedValue((Object)"HBASE_ROW_KEY");
        if (rowKey == null) {
            AbstractClassMetaData cmd = sm.getClassMetaData();
            Object[] pkValues = HBaseUtils.findKeyObjects(sm, cmd, schemaTable);
            ExecutionContext ec = sm.getExecutionContext();
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
            }
            rowKey = HBaseUtils.getRowKeyForPkValue(pkValues, (NucleusContext)ec.getNucleusContext());
        }
        return new Put(rowKey);
    }

    public static Delete getDeleteForObject(DNStateManager sm, org.datanucleus.store.schema.table.Table schemaTable) throws IOException {
        byte[] rowKey = (byte[])sm.getAssociatedValue((Object)"HBASE_ROW_KEY");
        if (rowKey == null) {
            AbstractClassMetaData cmd = sm.getClassMetaData();
            Object[] pkValues = HBaseUtils.findKeyObjects(sm, cmd, schemaTable);
            ExecutionContext ec = sm.getExecutionContext();
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
            }
            rowKey = HBaseUtils.getRowKeyForPkValue(pkValues, (NucleusContext)ec.getNucleusContext());
        }
        return new Delete(rowKey);
    }

    public static Get getGetForObject(DNStateManager sm, org.datanucleus.store.schema.table.Table schemaTable) throws IOException {
        byte[] rowKey = (byte[])sm.getAssociatedValue((Object)"HBASE_ROW_KEY");
        if (rowKey == null) {
            AbstractClassMetaData cmd = sm.getClassMetaData();
            Object[] pkValues = HBaseUtils.findKeyObjects(sm, cmd, schemaTable);
            ExecutionContext ec = sm.getExecutionContext();
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
            }
            rowKey = HBaseUtils.getRowKeyForPkValue(pkValues, (NucleusContext)ec.getNucleusContext());
        }
        return new Get(rowKey);
    }

    public static Result getResultForObject(DNStateManager sm, Table table, org.datanucleus.store.schema.table.Table schemaTable) throws IOException {
        Get get = HBaseUtils.getGetForObject(sm, schemaTable);
        return table.get(get);
    }

    public static boolean objectExistsInTable(DNStateManager sm, Table table, org.datanucleus.store.schema.table.Table schemaTable) throws IOException {
        Get get = HBaseUtils.getGetForObject(sm, schemaTable);
        return table.exists(get);
    }

    private static Object[] findKeyObjects(DNStateManager sm, AbstractClassMetaData cmd, org.datanucleus.store.schema.table.Table schemaTable) {
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return new Object[]{IdentityUtils.getTargetKeyForDatastoreIdentity((Object)sm.getInternalObjectId())};
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkFieldNums = cmd.getPKMemberPositions();
            ArrayList<Object> pkVals = new ArrayList<Object>();
            ExecutionContext ec = sm.getExecutionContext();
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            for (int i = 0; i < pkFieldNums.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                RelationType relType = pkMmd.getRelationType(clr);
                Object fieldVal = sm.provideField(pkFieldNums[i]);
                if (relType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(sm.getStoreManager().getMetaDataManager(), clr, pkMmd, relType, null)) {
                    DNStateManager embSM = sm.getExecutionContext().findStateManager(fieldVal);
                    AbstractClassMetaData embCmd = embSM.getClassMetaData();
                    int[] memberPositions = embCmd.getAllMemberPositions();
                    for (int j = 0; j < memberPositions.length; ++j) {
                        AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[j]);
                        if (embMmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
                        Object embFieldVal = embSM.provideField(memberPositions[j]);
                        pkVals.add(embFieldVal);
                    }
                    continue;
                }
                MemberColumnMapping mapping = schemaTable.getMemberColumnMappingForMember(pkMmd);
                if (RelationType.isRelationSingleValued((RelationType)relType)) {
                    pkVals.add(IdentityUtils.getPersistableIdentityForId((Object)ec.getApiAdapter().getIdForObject(fieldVal)));
                    continue;
                }
                if (mapping.getTypeConverter() != null) {
                    pkVals.add(mapping.getTypeConverter().toDatastoreType(fieldVal));
                    continue;
                }
                pkVals.add(fieldVal);
            }
            return pkVals.toArray();
        }
        int[] fieldNumbers = cmd.getAllMemberPositions();
        Object[] keyObjects = new Object[fieldNumbers.length];
        for (int i = 0; i < fieldNumbers.length; ++i) {
            keyObjects[i] = sm.provideField(fieldNumbers[i]);
        }
        return keyObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getRowKeyForPkValue(Object[] pkValues, NucleusContext nucCtx) throws IOException {
        boolean useSerialisation = nucCtx.getConfiguration().getBooleanProperty("datanucleus.hbase.serialisedPK");
        if (pkValues.length == 1 && !useSerialisation) {
            Object pkValue = pkValues[0];
            if (pkValue instanceof String) {
                return Bytes.toBytes((String)((String)pkValue));
            }
            if (pkValue instanceof Long) {
                return Bytes.toBytes((long)((Long)pkValue));
            }
            if (pkValue instanceof Integer) {
                return Bytes.toBytes((int)((Integer)pkValue));
            }
            if (pkValue instanceof Short) {
                return Bytes.toBytes((short)((Short)pkValue));
            }
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            if (useSerialisation) {
                try (ObjectOutputStream objectArray = new ObjectOutputStream(bos);){
                    for (Object pkValue : pkValues) {
                        objectArray.writeObject(pkValue);
                    }
                }
            } else {
                for (Object pkValue : pkValues) {
                    if (pkValue instanceof String) {
                        bos.write(Bytes.toBytes((String)((String)pkValue)));
                        continue;
                    }
                    if (pkValue instanceof Long) {
                        bos.write(Bytes.toBytes((long)((Long)pkValue)));
                        continue;
                    }
                    if (pkValue instanceof Integer) {
                        bos.write(Bytes.toBytes((int)((Integer)pkValue)));
                        continue;
                    }
                    if (pkValue instanceof Short) {
                        bos.write(Bytes.toBytes((short)((Short)pkValue)));
                        continue;
                    }
                    try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                        oos.writeObject(pkValue);
                    }
                }
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

