/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.util.NucleusLogger;

public class HBaseMetaDataListener
implements MetaDataListener {
    HBaseMetaDataListener(HBaseStoreManager storeManager) {
    }

    public void loaded(AbstractClassMetaData cmd) {
        int[] pkFieldNumbers;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (cmd.getDatastoreIdentityMetaData() != null && cmd.getDatastoreIdentityMetaData().getValueStrategy() == ValueGenerationStrategy.IDENTITY) {
                cmd.getDatastoreIdentityMetaData().setValueStrategy(ValueGenerationStrategy.INCREMENT);
                NucleusLogger.METADATA.warn((Object)("Class " + cmd.getFullClassName() + " has been specified to use datastore-identity with IDENTITY value generation, but not supported on HBase. Using INCREMENT"));
            }
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION && (pkFieldNumbers = cmd.getPKMemberPositions()) != null) {
            for (int i = 0; i < pkFieldNumbers.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                if (mmd.getValueStrategy() != ValueGenerationStrategy.IDENTITY) continue;
                cmd.getDatastoreIdentityMetaData().setValueStrategy(ValueGenerationStrategy.INCREMENT);
                NucleusLogger.METADATA.warn((Object)("Field " + mmd.getFullFieldName() + " has been specified to use IDENTITY value generation, but not supported on HBase. Using INCREMENT"));
            }
        }
    }
}

