/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.fieldmanager;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.EnumConversionHelper;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    Table table;
    Put put;
    Delete delete;

    public StoreFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, Put put, Delete delete, boolean insert, Table table) {
        super(ec, cmd, insert);
        this.put = put;
        this.delete = delete;
        this.table = table;
    }

    public StoreFieldManager(ObjectProvider op, Put put, Delete delete, boolean insert, Table table) {
        super(op, insert);
        this.put = put;
        this.delete = delete;
        this.table = table;
    }

    protected AbstractMemberMetaData getMemberMetaData(int fieldNumber) {
        return this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeBooleanInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeByteInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeCharInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeDoubleInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeFloatInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeIntInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeLongInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeShortInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeStringField(int fieldNumber, String value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (value == null) {
            this.delete.addColumn(HBaseUtils.getFamilyNameForColumn(col).getBytes(), HBaseUtils.getQualifierNameForColumn(col).getBytes());
        } else if (mmd.isSerialized()) {
            this.writeObjectField(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value);
        } else {
            this.put.addColumn(HBaseUtils.getFamilyNameForColumn(col).getBytes(), HBaseUtils.getQualifierNameForColumn(col).getBytes(), value.getBytes());
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                if ((this.insert && !mmd.isCascadePersist() || !this.insert && !mmd.isCascadeUpdate()) && !this.ec.getApiAdapter().isDetached(value) && !this.ec.getApiAdapter().isPersistent(value)) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                    }
                    throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
                }
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                int[] embMmdPosns = embCmd.getAllMemberPositions();
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                if (value == null) {
                    StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(this.ec, embCmd, this.put, this.delete, this.insert, embMmds, this.table);
                    for (int i = 0; i < embMmdPosns.length; ++i) {
                        AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embMmdPosns[i]);
                        if (String.class.isAssignableFrom(embMmd.getType()) || embMmd.getType().isPrimitive() || ClassUtils.isPrimitiveWrapperType((String)mmd.getTypeName())) {
                            ArrayList<AbstractMemberMetaData> colEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                            colEmbMmds.add(embMmd);
                            MemberColumnMapping mapping = this.table.getMemberColumnMappingForEmbeddedMember(colEmbMmds);
                            Column col = mapping.getColumn(0);
                            String colFamName = HBaseUtils.getFamilyNameForColumn(col);
                            String colQualName = HBaseUtils.getQualifierNameForColumn(col);
                            this.delete.addColumn(colFamName.getBytes(), colQualName.getBytes());
                            continue;
                        }
                        if (!Object.class.isAssignableFrom(embMmd.getType())) continue;
                        storeEmbFM.storeObjectField(embMmdPosns[i], null);
                    }
                    return;
                }
                ObjectProvider embOP = this.ec.findObjectProviderForEmbedded(value, this.op, mmd);
                StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embOP, this.put, this.delete, this.insert, embMmds, this.table);
                embOP.provideFields(embCmd.getAllMemberPositions(), (FieldManager)ffm);
                return;
            }
            if (!RelationType.isRelationMultiValued((RelationType)relationType) || value == null) {
                // empty if block
            }
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but field of this type not suppported. Mark as not persistent? or not embedded?");
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void storeNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr, Object value) {
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        if (value instanceof Optional) {
            Optional opt;
            if (relationType != RelationType.NONE) {
                relationType = RelationType.ONE_TO_ONE_UNI;
            }
            value = (opt = (Optional)value).isPresent() ? opt.get() : null;
        }
        if (value == null) {
            for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                Column col = mapping.getColumn(i);
                this.delete.addColumn(HBaseUtils.getFamilyNameForColumn(col).getBytes(), HBaseUtils.getQualifierNameForColumn(col).getBytes());
            }
            return;
        }
        String relationStorageMode = this.ec.getStoreManager().getStringProperty("datanucleus.relation.identityStorageMode");
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            if ((this.insert && !mmd.isCascadePersist() || !this.insert && !mmd.isCascadeUpdate()) && !this.ec.getApiAdapter().isDetached(value) && !this.ec.getApiAdapter().isPersistent(value)) {
                if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
            }
            Column col = mapping.getColumn(0);
            String familyName = HBaseUtils.getFamilyNameForColumn(col);
            String qualifName = HBaseUtils.getQualifierNameForColumn(col);
            if (mmd.isSerialized()) {
                ObjectProvider pcOP = this.ec.findObjectProvider(value);
                if (pcOP == null || this.ec.getApiAdapter().getExecutionContext(value) == null) {
                    pcOP = this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, value, false, this.op, fieldNumber);
                }
                if (pcOP != null) {
                    pcOP.setStoringPC();
                }
                this.writeObjectField(familyName, qualifName, value);
                if (pcOP == null) return;
                pcOP.unsetStoringPC();
                return;
            }
            Object valuePC = this.ec.persistObjectInternal(value, this.op, fieldNumber, -1);
            Object valueID = this.ec.getApiAdapter().getIdForObject(valuePC);
            if (relationStorageMode.equalsIgnoreCase("PersistableIdentity")) {
                this.writeObjectField(familyName, qualifName, IdentityUtils.getPersistableIdentityForId((Object)valueID));
                return;
            } else {
                if (!relationStorageMode.equalsIgnoreCase("HBaseLegacy")) throw new NucleusUserException("This store plugin does not support relation identity storageMode of " + relationStorageMode);
                this.writeObjectField(familyName, qualifName, valueID);
            }
            return;
        } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            Column col = mapping.getColumn(0);
            String familyName = HBaseUtils.getFamilyNameForColumn(col);
            String qualifName = HBaseUtils.getQualifierNameForColumn(col);
            if (mmd.isSerialized()) {
                this.writeObjectField(familyName, qualifName, value);
                SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)value, (boolean)true);
                return;
            }
            if (mmd.hasCollection()) {
                Collection coll = (Collection)value;
                if (this.insert && !mmd.isCascadePersist() || !this.insert && !mmd.isCascadeUpdate()) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                    }
                    for (Object element : coll) {
                        if (this.ec.getApiAdapter().isDetached(element) || this.ec.getApiAdapter().isPersistent(element)) continue;
                        throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), element);
                    }
                }
                ArrayList<Object> collIds = new ArrayList<Object>();
                for (Object element : coll) {
                    if (element != null) {
                        Object object = this.ec.persistObjectInternal(element, this.op, fieldNumber, -1);
                        Object object2 = this.ec.getApiAdapter().getIdForObject(object);
                        if (relationStorageMode.equalsIgnoreCase("PersistableIdentity")) {
                            collIds.add(IdentityUtils.getPersistableIdentityForId((Object)object2));
                            continue;
                        }
                        if (!relationStorageMode.equalsIgnoreCase("HBaseLegacy")) continue;
                        collIds.add(object2);
                        continue;
                    }
                    if (relationStorageMode.equalsIgnoreCase("PersistableIdentity")) {
                        collIds.add("NULL");
                        continue;
                    }
                    if (!relationStorageMode.equalsIgnoreCase("HBaseLegacy")) continue;
                    collIds.addAll(null);
                }
                if (mmd.getCollection().isSerializedElement()) {
                    throw new NucleusException("Don't currently support serialized collection elements (field=" + mmd.getFullFieldName() + ")");
                }
                this.writeObjectField(familyName, qualifName, collIds);
                SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)value, (boolean)true);
                return;
            } else if (mmd.hasMap()) {
                HashMap<void, void> mapIds = new HashMap<void, void>();
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    void var16_64;
                    void var15_56;
                    void var16_70;
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    if (this.ec.getApiAdapter().isPersistable(k)) {
                        Object pKey = this.ec.persistObjectInternal(k, this.op, fieldNumber, -1);
                        Object object = this.ec.getApiAdapter().getIdForObject(pKey);
                        if (relationStorageMode.equalsIgnoreCase("PersistableIdentity")) {
                            String string = IdentityUtils.getPersistableIdentityForId((Object)object);
                        }
                    }
                    if (this.ec.getApiAdapter().isPersistable(v)) {
                        if (v != null) {
                            Object pVal = this.ec.persistObjectInternal(v, this.op, fieldNumber, -1);
                            Object object = this.ec.getApiAdapter().getIdForObject(pVal);
                            if (relationStorageMode.equalsIgnoreCase("PersistableIdentity")) {
                                String string = IdentityUtils.getPersistableIdentityForId((Object)object);
                            }
                        } else {
                            String string = "NULL";
                        }
                    }
                    if (var16_70 == null) {
                        String string = "NULL";
                    }
                    mapIds.put(var15_56, var16_64);
                }
                if (mmd.getMap().isSerializedKey() || mmd.getMap().isSerializedValue()) {
                    throw new NucleusException("Don't currently support serialized map keys/values (field=" + mmd.getFullFieldName() + ")");
                }
                this.writeObjectField(familyName, qualifName, mapIds);
                SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)value, (boolean)true);
                return;
            } else {
                if (!mmd.hasArray()) return;
                ArrayList<Object> arrIds = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    if (element != null) {
                        Object elementPC = this.ec.persistObjectInternal(element, this.op, fieldNumber, -1);
                        Object object = this.ec.getApiAdapter().getIdForObject(elementPC);
                        if (relationStorageMode.equalsIgnoreCase("PersistableIdentity")) {
                            arrIds.add(IdentityUtils.getPersistableIdentityForId((Object)object));
                            continue;
                        }
                        if (!relationStorageMode.equalsIgnoreCase("HBaseLegacy")) continue;
                        arrIds.add(object);
                        continue;
                    }
                    if (relationStorageMode.equalsIgnoreCase("PersistableIdentity")) {
                        arrIds.add("NULL");
                        continue;
                    }
                    if (!relationStorageMode.equalsIgnoreCase("HBaseLegacy")) continue;
                    arrIds.add(null);
                }
                if (mmd.getArray().isSerializedElement()) {
                    throw new NucleusException("Don't currently support serialized array elements (field=" + mmd.getFullFieldName() + ")");
                }
                this.writeObjectField(familyName, qualifName, arrIds);
            }
            return;
        } else {
            TypeConverter strConv;
            if (mmd.isSerialized()) {
                Column col = mapping.getColumn(0);
                String familyName = HBaseUtils.getFamilyNameForColumn(col);
                String qualifName = HBaseUtils.getQualifierNameForColumn(col);
                this.writeObjectField(familyName, qualifName, value);
                SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)value, (boolean)true);
                return;
            }
            if (mapping.getTypeConverter() != null) {
                Object datastoreValue = mapping.getTypeConverter().toDatastoreType(value);
                if (mapping.getNumberOfColumns() > 1) {
                    for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                        Column col = mapping.getColumn(i);
                        Object colValue = Array.get(datastoreValue, i);
                        byte[] valueColBytes = this.getPersistableBytesForObject(col, colValue);
                        this.put.addColumn(HBaseUtils.getFamilyNameForColumn(col).getBytes(), HBaseUtils.getQualifierNameForColumn(col).getBytes(), valueColBytes);
                    }
                    return;
                } else {
                    Column col = mapping.getColumn(0);
                    byte[] valueColBytes = this.getPersistableBytesForObject(col, datastoreValue);
                    this.put.addColumn(HBaseUtils.getFamilyNameForColumn(col).getBytes(), HBaseUtils.getQualifierNameForColumn(col).getBytes(), valueColBytes);
                }
                return;
            }
            Column col = mapping.getColumn(0);
            String familyName = HBaseUtils.getFamilyNameForColumn(col);
            String qualifName = HBaseUtils.getQualifierNameForColumn(col);
            if (Boolean.class.isAssignableFrom(value.getClass())) {
                this.storeBooleanInternal(familyName, qualifName, (Boolean)value, mmd.isSerialized());
                return;
            }
            if (Byte.class.isAssignableFrom(value.getClass())) {
                this.storeByteInternal(familyName, qualifName, (Byte)value, mmd.isSerialized());
                return;
            }
            if (Character.class.isAssignableFrom(value.getClass())) {
                this.storeCharInternal(familyName, qualifName, ((Character)value).charValue(), mmd.isSerialized());
                return;
            }
            if (Double.class.isAssignableFrom(value.getClass())) {
                this.storeDoubleInternal(familyName, qualifName, (Double)value, mmd.isSerialized());
                return;
            }
            if (Float.class.isAssignableFrom(value.getClass())) {
                this.storeFloatInternal(familyName, qualifName, ((Float)value).floatValue(), mmd.isSerialized());
                return;
            }
            if (Integer.class.isAssignableFrom(value.getClass())) {
                this.storeIntInternal(familyName, qualifName, (Integer)value, mmd.isSerialized());
                return;
            }
            if (Long.class.isAssignableFrom(value.getClass())) {
                this.storeLongInternal(familyName, qualifName, (Long)value, mmd.isSerialized());
                return;
            }
            if (Short.class.isAssignableFrom(value.getClass())) {
                this.storeShortInternal(familyName, qualifName, (Short)value, mmd.isSerialized());
                return;
            }
            if (Enum.class.isAssignableFrom(value.getClass())) {
                Object storedValue = EnumConversionHelper.getStoredValueFromEnum((AbstractMemberMetaData)mmd, (FieldRole)FieldRole.ROLE_FIELD, (Enum)((Enum)value));
                if (storedValue instanceof Number) {
                    this.put.addColumn(familyName.getBytes(), qualifName.getBytes(), Bytes.toBytes((int)((Number)storedValue).intValue()));
                    return;
                } else {
                    this.put.addColumn(familyName.getBytes(), qualifName.getBytes(), ((String)storedValue).getBytes());
                }
                return;
            }
            if (String.class.isAssignableFrom(value.getClass())) {
                this.put.addColumn(familyName.getBytes(), qualifName.getBytes(), ((String)value).getBytes());
                return;
            }
            if (Collection.class.isAssignableFrom(value.getClass())) {
                Collection coll = (Collection)value;
                if (coll.isEmpty()) {
                    this.writeObjectField(familyName, qualifName, value);
                    SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)value, (boolean)true);
                    return;
                }
                AbstractCollection dbColl = null;
                dbColl = value instanceof List || value instanceof Queue ? new ArrayList() : new HashSet();
                TypeConverter elemConv = mapping.getTypeConverterForComponent(FieldRole.ROLE_COLLECTION_ELEMENT);
                Iterator collIter = coll.iterator();
                while (collIter.hasNext()) {
                    void var16_72;
                    Object e;
                    Object e2 = e = collIter.next();
                    if (elemConv != null) {
                        Object object = elemConv.toDatastoreType(e);
                    }
                    dbColl.add(var16_72);
                }
                this.writeObjectField(familyName, qualifName, dbColl);
                SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)value, (boolean)true);
                return;
            }
            if (Map.class.isAssignableFrom(value.getClass())) {
                Map map = (Map)value;
                if (map.isEmpty()) {
                    this.writeObjectField(familyName, qualifName, value);
                    SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)value, (boolean)true);
                    return;
                }
                TypeConverter keyConv = mapping.getTypeConverterForComponent(FieldRole.ROLE_MAP_KEY);
                TypeConverter valConv = mapping.getTypeConverterForComponent(FieldRole.ROLE_MAP_VALUE);
                Iterator entryIter = map.entrySet().iterator();
                HashMap<void, void> hashMap = new HashMap<void, void>();
                while (entryIter.hasNext()) {
                    void var20_82;
                    void var18_78;
                    Object val;
                    Object key;
                    Map.Entry entry = entryIter.next();
                    Object k = key = entry.getKey();
                    if (keyConv != null) {
                        Object object = keyConv.toDatastoreType(key);
                    }
                    Object v = val = entry.getValue();
                    if (valConv != null) {
                        Object object = valConv.toDatastoreType(val);
                    }
                    hashMap.put(var18_78, var20_82);
                }
                this.writeObjectField(familyName, qualifName, hashMap);
                SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)value, (boolean)true);
                return;
            }
            if (value.getClass().isArray()) {
                // empty if block
            }
            if ((strConv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), String.class)) != null) {
                String strValue = (String)strConv.toDatastoreType(value);
                this.put.addColumn(familyName.getBytes(), qualifName.getBytes(), strValue.getBytes());
                return;
            }
            this.writeObjectField(familyName, qualifName, value);
            SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)value, (boolean)true);
        }
    }

    protected void writeObjectField(String familyName, String columnName, Object value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            this.put.addColumn(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    private void storeBooleanInternal(String familyName, String columnName, boolean value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeBoolean(value);
                oos.flush();
                this.put.addColumn(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.addColumn(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((boolean)value));
        }
    }

    private void storeByteInternal(String familyName, String columnName, byte value, boolean serialised) {
        this.put.addColumn(familyName.getBytes(), columnName.getBytes(), new byte[]{value});
    }

    private void storeCharInternal(String familyName, String columnName, char value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeChar(value);
                oos.flush();
                this.put.addColumn(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.addColumn(familyName.getBytes(), columnName.getBytes(), ("" + value).getBytes());
        }
    }

    private void storeDoubleInternal(String familyName, String columnName, double value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeDouble(value);
                oos.flush();
                this.put.addColumn(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.addColumn(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((double)value));
        }
    }

    private void storeFloatInternal(String familyName, String columnName, float value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeFloat(value);
                oos.flush();
                this.put.addColumn(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.addColumn(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((float)value));
        }
    }

    private void storeIntInternal(String familyName, String columnName, int value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeInt(value);
                oos.flush();
                this.put.addColumn(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.addColumn(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((int)value));
        }
    }

    private void storeLongInternal(String familyName, String columnName, long value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeLong(value);
                oos.flush();
                this.put.addColumn(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.addColumn(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((long)value));
        }
    }

    private void storeShortInternal(String familyName, String columnName, short value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeShort(value);
                oos.flush();
                this.put.addColumn(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.addColumn(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((short)value));
        }
    }

    protected byte[] getPersistableBytesForObject(Column col, Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == byte[].class) {
            return (byte[])value;
        }
        if (Boolean.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((boolean)((Boolean)value));
        }
        if (Byte.class.isAssignableFrom(value.getClass())) {
            return new byte[]{(Byte)value};
        }
        if (Character.class.isAssignableFrom(value.getClass())) {
            return ("" + value).getBytes();
        }
        if (Double.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((double)((Double)value));
        }
        if (Float.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((float)((Float)value).floatValue());
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((int)((Integer)value));
        }
        if (Long.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((long)((Long)value));
        }
        if (Short.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((short)((Short)value));
        }
        if (BigDecimal.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((BigDecimal)((BigDecimal)value));
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            return ((String)value).getBytes();
        }
        if (Enum.class.isAssignableFrom(value.getClass())) {
            ColumnMetaData colmd = col.getColumnMetaData();
            if (MetaDataUtils.persistColumnAsNumeric((ColumnMetaData)colmd)) {
                return Bytes.toBytes((int)((Enum)value).ordinal());
            }
            return ((Enum)value).name().getBytes();
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            TypeConverter dateStrConv = this.ec.getTypeManager().getTypeConverterForType(value.getClass(), String.class);
            String datastoreVal = (String)dateStrConv.toDatastoreType((Object)((Date)value));
            return datastoreVal.getBytes();
        }
        NucleusLogger.PERSISTENCE.warn((Object)("Persistence of column " + col + " has value of type " + value.getClass().getName() + " but no conversion to bytes defined. Report this"));
        return null;
    }
}

