/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import org.datanucleus.store.hbase.HBaseManagedConnection;

public class HBaseConnectionPool {
    private final List<HBaseManagedConnection> connections;
    private final ThreadLocal<WeakReference<HBaseManagedConnection>> connectionForCurrentThread = new ThreadLocal();
    private final Timer evictorThread;
    private int timeBetweenEvictionRunsMillis = 15000;

    public HBaseConnectionPool() {
        this.connections = new CopyOnWriteArrayList<HBaseManagedConnection>();
        this.evictorThread = new Timer("HBase Connection Evictor", true);
        TimerTask timeoutTask = new TimerTask(){

            @Override
            public void run() {
                HBaseConnectionPool.this.disposeTimedOutConnections();
            }
        };
        this.evictorThread.schedule(timeoutTask, this.timeBetweenEvictionRunsMillis, (long)this.timeBetweenEvictionRunsMillis);
    }

    public void registerConnection(HBaseManagedConnection managedConnection) {
        this.connections.add(managedConnection);
        this.connectionForCurrentThread.set(new WeakReference<HBaseManagedConnection>(managedConnection));
    }

    public HBaseManagedConnection getPooledConnection() {
        WeakReference<HBaseManagedConnection> ref = this.connectionForCurrentThread.get();
        if (ref == null) {
            return null;
        }
        HBaseManagedConnection managedConnection = (HBaseManagedConnection)((Object)ref.get());
        if (managedConnection != null && !managedConnection.isDisposed()) {
            return managedConnection;
        }
        return null;
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    private void disposeTimedOutConnections() {
        ArrayList<HBaseManagedConnection> timedOutConnections = new ArrayList<HBaseManagedConnection>();
        for (HBaseManagedConnection managedConnection : this.connections) {
            if (!managedConnection.isExpired()) continue;
            timedOutConnections.add(managedConnection);
        }
        for (HBaseManagedConnection managedConnection : timedOutConnections) {
            managedConnection.dispose();
            this.connections.remove((Object)managedConnection);
        }
    }
}

