/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.hbase.HBaseMetaDataListener;
import org.datanucleus.store.hbase.HBasePersistenceHandler;
import org.datanucleus.store.hbase.HBaseSchemaHandler;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;

public class HBaseStoreManager
extends AbstractStoreManager
implements SchemaAwareStoreManager {
    public static final String PROPERTY_HBASE_RELATION_USE_PERSISTABLEID = "datanucleus.hbase.relationUsesPersistableId";
    public static final String PROPERTY_HBASE_ENFORCE_UNIQUENESS_IN_APPLICATION = "datanucleus.hbase.enforceUniquenessInApplication";
    public static final String PROPERTY_HBASE_SERIALISED_PK = "datanucleus.hbase.serialisedPK";
    public static final String PROPERTY_HBASE_TABLE_POOL_MAXSIZE = "datanucleus.hbase.tablePoolMaxSize";
    MetaDataListener metadataListener;
    private Configuration hbaseConfig;

    public HBaseStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext ctx, Map<String, Object> props) {
        super("hbase", clr, ctx, props);
        this.schemaHandler = new HBaseSchemaHandler((StoreManager)this);
        this.persistenceHandler = new HBasePersistenceHandler((StoreManager)this);
        this.metadataListener = new HBaseMetaDataListener(this);
        MetaDataManager mmgr = this.nucleusContext.getMetaDataManager();
        mmgr.registerListener(this.metadataListener);
        Collection classNamesLoaded = mmgr.getClassesWithMetaData();
        if (classNamesLoaded != null && !classNamesLoaded.isEmpty()) {
            for (String className : classNamesLoaded) {
                AbstractClassMetaData cmd = mmgr.getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                this.metadataListener.loaded(cmd);
            }
        }
        this.logConfiguration();
    }

    protected void registerConnectionMgr() {
        super.registerConnectionMgr();
        this.connectionMgr.disableConnectionPool();
    }

    public synchronized void close() {
        this.nucleusContext.getMetaDataManager().deregisterListener(this.metadataListener);
        super.close();
    }

    public NucleusConnection getNucleusConnection(ExecutionContext om) {
        throw new UnsupportedOperationException();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationId");
        set.add("ApplicationCompositeId");
        set.add("DatastoreId");
        set.add("NonDurableId");
        set.add("ORM");
        set.add("ORM.EmbeddedPC");
        set.add("ORM.SerialisedPC");
        set.add("TransactionIsolationLevel.read-committed");
        return set;
    }

    public Configuration getHbaseConfig() {
        if (this.hbaseConfig == null) {
            this.hbaseConfig = HBaseConfiguration.create();
        }
        return this.hbaseConfig;
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        return super.getClassNameForObjectID(id, clr, ec);
    }

    public void manageClasses(ClassLoaderResolver clr, String ... classNames) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        HashSet<String> clsNameSet = new HashSet<String>();
        for (ClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd.isEmbeddedOnly() || cmd.isAbstract() || this.storeDataMgr.managesClass(cmd.getFullClassName())) continue;
            StoreData sd = this.storeDataMgr.get(cmd.getFullClassName());
            if (sd == null) {
                CompleteClassTable table = new CompleteClassTable((StoreManager)this, (AbstractClassMetaData)cmd, null);
                sd = this.newStoreData(cmd, clr);
                sd.setTable((Table)table);
                this.registerStoreData(sd);
            }
            clsNameSet.add(cmd.getFullClassName());
        }
        this.getSchemaHandler().createSchemaForClasses(clsNameSet, null, null);
    }

    protected Properties getPropertiesForGenerator(AbstractClassMetaData cmd, int absoluteFieldNumber, ExecutionContext ec, SequenceMetaData seqmd, TableGeneratorMetaData tablegenmd) {
        Properties props = super.getPropertiesForGenerator(cmd, absoluteFieldNumber, ec, seqmd, tablegenmd);
        IdentityStrategy strategy = null;
        if (absoluteFieldNumber >= 0) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            strategy = mmd.getValueStrategy();
        } else {
            IdentityMetaData idmd = cmd.getBaseIdentityMetaData();
            strategy = idmd.getValueStrategy();
        }
        if (!this.managesClass(cmd.getFullClassName())) {
            this.manageClasses(ec.getClassLoaderResolver(), cmd.getFullClassName());
        }
        Table table = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getTable();
        props.setProperty("table-name", table.getName());
        if (strategy == IdentityStrategy.INCREMENT && tablegenmd != null) {
            props.remove("table-name");
        }
        return props;
    }

    public void createSchema(String schemaName, Properties props) {
        this.schemaHandler.createSchema(schemaName, props, null);
    }

    public void deleteSchema(String schemaName, Properties props) {
        this.schemaHandler.deleteSchema(schemaName, props, null);
    }

    public void createSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.createSchemaForClasses(classNames, props, null);
    }

    public void deleteSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.deleteSchemaForClasses(classNames, props, null);
    }

    public void validateSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.validateSchema(classNames, props, null);
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());
    }
}

