/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.fieldmanager;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.store.types.converters.TypeConverterHelper;
import org.datanucleus.util.NucleusLogger;

public class FetchFieldManager
extends AbstractFetchFieldManager {
    Table table;
    Result result;

    public FetchFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, Result result, Table table) {
        super(ec, cmd);
        this.result = result;
        this.table = table;
    }

    public FetchFieldManager(ObjectProvider op, Result result, Table table) {
        super(op);
        this.result = result;
        this.table = table;
    }

    protected AbstractMemberMetaData getMemberMetaData(int fieldNumber) {
        return this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public boolean fetchBooleanField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchBooleanInternal(bytes, mmd.isSerialized(), null);
    }

    public byte fetchByteField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchByteInternal(bytes, mmd.isSerialized(), null);
    }

    public char fetchCharField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchCharInternal(bytes, mmd.isSerialized(), null);
    }

    public double fetchDoubleField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchDoubleInternal(bytes, mmd.isSerialized(), null);
    }

    public float fetchFloatField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchFloatInternal(bytes, mmd.isSerialized(), null);
    }

    public int fetchIntField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchIntInternal(bytes, mmd.isSerialized(), null);
    }

    public long fetchLongField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchLongInternal(bytes, mmd.isSerialized(), null);
    }

    public short fetchShortField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchShortInternal(bytes, mmd.isSerialized(), null);
    }

    public String fetchStringField(int fieldNumber) {
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        if (bytes == null) {
            return null;
        }
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                String value = (String)ois.readObject();
                ois.close();
                bis.close();
                return value;
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
        return new String(bytes);
    }

    public Object fetchObjectField(int fieldNumber) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                Class embcls = mmd.getType();
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(embcls, clr);
                boolean isNull = true;
                int[] embAllPosns = embCmd.getAllMemberPositions();
                for (int i = 0; i < embAllPosns.length; ++i) {
                    AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(i);
                    ArrayList<AbstractMemberMetaData> subEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                    subEmbMmds.add(embMmd);
                    Column col = this.table.getMemberColumnMappingForEmbeddedMember(subEmbMmds).getColumn(0);
                    String familyName = HBaseUtils.getFamilyNameForColumn(col);
                    String columnName = HBaseUtils.getQualifierNameForColumn(col);
                    if (this.result.getValue(familyName.getBytes(), columnName.getBytes()) == null) continue;
                    isNull = false;
                    break;
                }
                if (isNull) {
                    return null;
                }
                ObjectProvider embSM = this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, embCmd, this.op, fieldNumber);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embSM, this.result, embMmds, this.table);
                embSM.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)ffm);
                return embSM.getObject();
            }
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " marked as embedded not supported for this type");
        }
        return this.fetchNonEmbeddedObjectField(mmd, relationType, clr);
    }

    protected Object fetchNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr) {
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            String qualifName;
            String familyName;
            Column col = mapping.getColumn(0);
            Object value = this.readObjectField(col, familyName = HBaseUtils.getFamilyNameForColumn(col), qualifName = HBaseUtils.getQualifierNameForColumn(col), this.result, mmd);
            if (value == null) {
                return null;
            }
            if (mmd.isSerialized()) {
                return value;
            }
            return this.ec.findObject(value, true, true, null);
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            String qualifName;
            String familyName;
            Column col = mapping.getColumn(0);
            Object value = this.readObjectField(col, familyName = HBaseUtils.getFamilyNameForColumn(col), qualifName = HBaseUtils.getQualifierNameForColumn(col), this.result, mmd);
            if (value == null) {
                return null;
            }
            if (mmd.isSerialized()) {
                return value;
            }
            if (mmd.hasCollection()) {
                Collection coll;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                Collection collIds = (Collection)value;
                for (Object elementId : collIds) {
                    coll.add(this.ec.findObject(elementId, true, true, null));
                }
                if (this.op != null) {
                    return this.op.wrapSCOField(fieldNumber, (Object)coll, false, false, true);
                }
                return coll;
            }
            if (mmd.hasMap()) {
                Map map;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                    map = (Map)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                Map mapIds = (Map)value;
                for (Map.Entry entry : mapIds.entrySet()) {
                    Object mapKey = entry.getKey();
                    Object mapValue = entry.getValue();
                    if (mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager()) != null) {
                        mapKey = this.ec.findObject(mapKey, true, true, null);
                    }
                    if (mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager()) != null) {
                        mapValue = this.ec.findObject(mapValue, true, true, null);
                    }
                    map.put(mapKey, mapValue);
                }
                if (this.op != null) {
                    return this.op.wrapSCOField(fieldNumber, (Object)map, false, false, true);
                }
                return map;
            }
            if (mmd.hasArray()) {
                Collection arrIds = (Collection)value;
                Object array = Array.newInstance(mmd.getType().getComponentType(), arrIds.size());
                Iterator idIter = arrIds.iterator();
                int i = 0;
                while (idIter.hasNext()) {
                    Object elementId = idIter.next();
                    Array.set(array, i, this.ec.findObject(elementId, true, true, null));
                }
                return array;
            }
            throw new NucleusUserException("No container that isnt collection/map/array");
        }
        Object returnValue = null;
        if (mmd.isSerialized()) {
            String qualifName;
            String familyName;
            Column col = mapping.getColumn(0);
            Object value = this.readObjectField(col, familyName = HBaseUtils.getFamilyNameForColumn(col), qualifName = HBaseUtils.getQualifierNameForColumn(col), this.result, mmd);
            if (value == null) {
                return null;
            }
            returnValue = value;
        } else if (mapping.getTypeConverter() != null) {
            String qualifName;
            String familyName;
            TypeConverter conv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForName(mmd.getTypeConverterName());
            if (mapping.getNumberOfColumns() > 1) {
                boolean isNull = true;
                Object[] valuesArr = null;
                Class[] colTypes = ((MultiColumnConverter)conv).getDatastoreColumnTypes();
                valuesArr = colTypes[0] == Integer.TYPE ? new int[mapping.getNumberOfColumns()] : (colTypes[0] == Long.TYPE ? (Object[])new long[mapping.getNumberOfColumns()] : (colTypes[0] == Double.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == Float.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == String.class ? (Object[])new String[mapping.getNumberOfColumns()] : (Object[])new Object[mapping.getNumberOfColumns()]))));
                for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                    Column col = mapping.getColumn(i);
                    String familyName2 = HBaseUtils.getFamilyNameForColumn(col);
                    String qualifName2 = HBaseUtils.getQualifierNameForColumn(col);
                    Object colValue = null;
                    if (!this.result.containsColumn(familyName2.getBytes(), qualifName2.getBytes())) {
                        colValue = null;
                    } else {
                        byte[] bytes = this.result.getValue(familyName2.getBytes(), qualifName2.getBytes());
                        if (bytes == null) {
                            colValue = null;
                        } else {
                            isNull = false;
                            if (colTypes[i] == String.class) {
                                colValue = new String(bytes);
                            } else if (colTypes[i] == Integer.class || colTypes[i] == Integer.TYPE) {
                                colValue = Bytes.toInt((byte[])bytes);
                            } else if (colTypes[i] == Long.class || colTypes[i] == Long.TYPE) {
                                colValue = Bytes.toLong((byte[])bytes);
                            } else if (colTypes[i] == Double.class || colTypes[i] == Double.TYPE) {
                                colValue = Bytes.toDouble((byte[])bytes);
                            } else if (colTypes[i] == Float.class || colTypes[i] == Float.TYPE) {
                                colValue = Float.valueOf(Bytes.toFloat((byte[])bytes));
                            } else if (colTypes[i] == Short.class || colTypes[i] == Short.TYPE) {
                                colValue = Bytes.toShort((byte[])bytes);
                            } else if (colTypes[i] == Boolean.class || colTypes[i] == Boolean.TYPE) {
                                colValue = Bytes.toBoolean((byte[])bytes);
                            } else if (colTypes[i] == BigDecimal.class) {
                                colValue = Bytes.toBigDecimal((byte[])bytes);
                            } else {
                                NucleusLogger.PERSISTENCE.warn((Object)("Retrieve of column " + col + " is for type " + colTypes[i] + " but this is not yet supported. Report this"));
                            }
                        }
                    }
                    Array.set(valuesArr, i, colValue);
                }
                if (isNull) {
                    return null;
                }
                Object memberValue = conv.toMemberType((Object)valuesArr);
                if (this.op != null && memberValue != null) {
                    memberValue = this.op.wrapSCOField(fieldNumber, memberValue, false, false, true);
                }
                return memberValue;
            }
            Column col = mapping.getColumn(0);
            Object value = this.readObjectField(col, familyName = HBaseUtils.getFamilyNameForColumn(col), qualifName = HBaseUtils.getQualifierNameForColumn(col), this.result, mmd);
            if (value == null) {
                return null;
            }
            byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
            Class datastoreType = TypeConverterHelper.getDatastoreTypeForTypeConverter((TypeConverter)conv, (Class)mmd.getType());
            if (datastoreType == String.class) {
                returnValue = conv.toMemberType((Object)((String)value));
            } else if (datastoreType == Long.class) {
                returnValue = conv.toMemberType((Object)Bytes.toLong((byte[])bytes));
            } else if (datastoreType == Integer.class) {
                returnValue = conv.toMemberType((Object)Bytes.toInt((byte[])bytes));
            } else if (datastoreType == Double.class) {
                returnValue = conv.toMemberType((Object)Bytes.toDouble((byte[])bytes));
            } else if (datastoreType == Boolean.class) {
                returnValue = conv.toMemberType((Object)Bytes.toBoolean((byte[])bytes));
            }
        } else {
            String qualifName;
            String familyName;
            Column col = mapping.getColumn(0);
            Object value = this.readObjectField(col, familyName = HBaseUtils.getFamilyNameForColumn(col), qualifName = HBaseUtils.getQualifierNameForColumn(col), this.result, mmd);
            if (value == null) {
                return null;
            }
            returnValue = value;
            if (Boolean.class.isAssignableFrom(mmd.getType()) || Byte.class.isAssignableFrom(mmd.getType()) || Integer.class.isAssignableFrom(mmd.getType()) || Double.class.isAssignableFrom(mmd.getType()) || Float.class.isAssignableFrom(mmd.getType()) || Long.class.isAssignableFrom(mmd.getType()) || Character.class.isAssignableFrom(mmd.getType()) || Short.class.isAssignableFrom(mmd.getType())) {
                return value;
            }
            if (Enum.class.isAssignableFrom(mmd.getType())) {
                ColumnMetaData colmd = col.getColumnMetaData();
                if (MetaDataUtils.persistColumnAsNumeric((ColumnMetaData)colmd)) {
                    return mmd.getType().getEnumConstants()[((Number)value).intValue()];
                }
                return Enum.valueOf(mmd.getType(), (String)value);
            }
            TypeConverter strConv = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class);
            if (strConv != null) {
                String strValue = (String)value;
                returnValue = strConv.toMemberType((Object)strValue);
            }
        }
        if (this.op != null) {
            return this.op.wrapSCOField(fieldNumber, returnValue, false, false, true);
        }
        return returnValue;
    }

    protected Object readObjectField(Column col, String familyName, String qualifName, Result result, AbstractMemberMetaData mmd) {
        byte[] bytes = result.getValue(familyName.getBytes(), qualifName.getBytes());
        if (bytes == null) {
            return null;
        }
        if (mmd.getType() == Boolean.class) {
            return this.fetchBooleanInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (mmd.getType() == Byte.class) {
            return this.fetchByteInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (mmd.getType() == Character.class) {
            return Character.valueOf(this.fetchCharInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd)));
        }
        if (mmd.getType() == Double.class) {
            return this.fetchDoubleInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (mmd.getType() == Float.class) {
            return Float.valueOf(this.fetchFloatInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd)));
        }
        if (mmd.getType() == Integer.class) {
            return this.fetchIntInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (mmd.getType() == Long.class) {
            return this.fetchLongInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (mmd.getType() == Short.class) {
            return this.fetchShortInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (Enum.class.isAssignableFrom(mmd.getType())) {
            ColumnMetaData colmd = null;
            if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                colmd = mmd.getColumnMetaData()[0];
            }
            if (MetaDataUtils.persistColumnAsNumeric(colmd)) {
                return this.fetchIntInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
            }
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bis);
            Object object = ois.readObject();
            return object;
        }
        catch (IOException e) {
            String string = new String(bytes);
            return string;
        }
        catch (ClassNotFoundException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                bis.close();
            }
            catch (IOException ioe) {
                throw new NucleusException(ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    private boolean fetchBooleanInternal(byte[] bytes, boolean serialised, String defaultValue) {
        boolean value;
        if (bytes == null) {
            if (defaultValue != null) {
                return Boolean.valueOf(defaultValue);
            }
            return false;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readBoolean();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toBoolean((byte[])bytes);
        }
        return value;
    }

    private byte fetchByteInternal(byte[] bytes, boolean serialised, String defaultValue) {
        if (bytes == null) {
            if (defaultValue != null) {
                return defaultValue.getBytes()[0];
            }
            return 0;
        }
        return bytes[0];
    }

    private char fetchCharInternal(byte[] bytes, boolean serialised, String defaultValue) {
        char value;
        if (bytes == null) {
            if (defaultValue != null && defaultValue.length() > 0) {
                return defaultValue.charAt(0);
            }
            return '\u0000';
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readChar();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            String strValue = new String(bytes);
            value = strValue.charAt(0);
        }
        return value;
    }

    private double fetchDoubleInternal(byte[] bytes, boolean serialised, String defaultValue) {
        double value;
        if (bytes == null) {
            if (defaultValue != null) {
                return Double.valueOf(defaultValue);
            }
            return 0.0;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readDouble();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toDouble((byte[])bytes);
        }
        return value;
    }

    private float fetchFloatInternal(byte[] bytes, boolean serialised, String defaultValue) {
        float value;
        if (bytes == null) {
            if (defaultValue != null) {
                return Float.valueOf(defaultValue).floatValue();
            }
            return 0.0f;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readFloat();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toFloat((byte[])bytes);
        }
        return value;
    }

    private int fetchIntInternal(byte[] bytes, boolean serialised, String defaultValue) {
        int value;
        if (bytes == null) {
            if (defaultValue != null) {
                return Integer.valueOf(defaultValue);
            }
            return 0;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readInt();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toInt((byte[])bytes);
        }
        return value;
    }

    private long fetchLongInternal(byte[] bytes, boolean serialised, String defaultValue) {
        long value;
        if (bytes == null) {
            if (defaultValue != null) {
                return Long.valueOf(defaultValue);
            }
            return 0L;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readLong();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toLong((byte[])bytes);
        }
        return value;
    }

    private short fetchShortInternal(byte[] bytes, boolean serialised, String defaultValue) {
        short value;
        if (bytes == null) {
            if (defaultValue != null) {
                return Short.valueOf(defaultValue);
            }
            return 0;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readShort();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toShort((byte[])bytes);
        }
        return value;
    }
}

