/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.query;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.util.NucleusLogger;

class HBaseQueryUtils {
    HBaseQueryUtils() {
    }

    static List getObjectsOfCandidateType(ExecutionContext ec, HBaseManagedConnection mconn, Class candidateClass, boolean subclasses, boolean ignoreCache, FetchPlan fetchPlan, Filter filter, StoreManager storeMgr) {
        List cmds = MetaDataUtils.getMetaDataForCandidates((Class)candidateClass, (boolean)subclasses, (ExecutionContext)ec);
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving objects for candidate=" + candidateClass.getName() + (subclasses ? " and subclasses" : "") + (filter != null ? " with filter=" + filter : "")));
        }
        Iterator cmdIter = cmds.iterator();
        ArrayList results = new ArrayList();
        while (cmdIter.hasNext()) {
            AbstractClassMetaData acmd = (AbstractClassMetaData)cmdIter.next();
            results.addAll(HBaseQueryUtils.getObjectsOfType(ec, mconn, acmd, ignoreCache, fetchPlan, filter, storeMgr));
        }
        return results;
    }

    private static List getObjectsOfType(final ExecutionContext ec, final HBaseManagedConnection mconn, final AbstractClassMetaData cmd, boolean ignoreCache, FetchPlan fp, final Filter filter, final StoreManager storeMgr) {
        ArrayList<Object> results = new ArrayList<Object>();
        final String tableName = storeMgr.getNamingFactory().getTableName(cmd);
        final int[] fpMembers = fp.getFetchPlanForClass(cmd).getMemberNumbers();
        try {
            final ClassLoaderResolver clr = ec.getClassLoaderResolver();
            Iterator it = (Iterator)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    byte[] qualifName;
                    byte[] familyName;
                    String colName;
                    Scan scan = new Scan();
                    if (filter != null) {
                        scan.setFilter(filter);
                    }
                    for (int i = 0; i < fpMembers.length; ++i) {
                        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fpMembers[i]);
                        RelationType relationType = mmd.getRelationType(clr);
                        if (RelationType.isRelationSingleValued((RelationType)relationType) && mmd.isEmbedded()) {
                            HBaseQueryUtils.addColumnsToScanForEmbeddedMember(scan, mmd, tableName, ec);
                            continue;
                        }
                        byte[] familyName2 = HBaseUtils.getFamilyName(cmd, fpMembers[i], tableName).getBytes();
                        byte[] qualifName2 = HBaseUtils.getQualifierName(cmd, fpMembers[i]).getBytes();
                        scan.addColumn(familyName2, qualifName2);
                    }
                    VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                    if (cmd.isVersioned() && vermd.getFieldName() == null) {
                        colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
                        familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName).getBytes();
                        qualifName = HBaseUtils.getQualifierNameForColumnName(colName).getBytes();
                        scan.addColumn(familyName, qualifName);
                    }
                    if (cmd.hasDiscriminatorStrategy()) {
                        colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
                        familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName).getBytes();
                        qualifName = HBaseUtils.getQualifierNameForColumnName(colName).getBytes();
                        scan.addColumn(familyName, qualifName);
                    }
                    if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                        colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN);
                        familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName).getBytes();
                        qualifName = HBaseUtils.getQualifierNameForColumnName(colName).getBytes();
                        scan.addColumn(familyName, qualifName);
                    }
                    HTableInterface table = mconn.getHTable(tableName);
                    ResultScanner scanner = table.getScanner(scan);
                    if (ec.getStatistics() != null) {
                        ec.getStatistics().incrementNumReads();
                    }
                    Iterator it = scanner.iterator();
                    return it;
                }
            });
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                while (it.hasNext()) {
                    Result result = (Result)it.next();
                    Object obj = HBaseQueryUtils.getObjectUsingApplicationIdForResult(result, cmd, ec, ignoreCache, fpMembers, tableName, storeMgr);
                    if (obj == null) continue;
                    results.add(obj);
                }
            } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                while (it.hasNext()) {
                    Result result = (Result)it.next();
                    Object obj = HBaseQueryUtils.getObjectUsingDatastoreIdForResult(result, cmd, ec, ignoreCache, fpMembers, tableName, storeMgr);
                    if (obj == null) continue;
                    results.add(obj);
                }
            } else {
                while (it.hasNext()) {
                    Result result = (Result)it.next();
                    Object obj = HBaseQueryUtils.getObjectUsingNondurableIdForResult(result, cmd, ec, ignoreCache, fpMembers, tableName, storeMgr);
                    if (obj == null) continue;
                    results.add(obj);
                }
            }
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
        return results;
    }

    protected static Object getObjectUsingApplicationIdForResult(Result result, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers, String tableName, StoreManager storeMgr) {
        ObjectProvider sm;
        if (cmd.hasDiscriminatorStrategy()) {
            String colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
            String familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
            String columnName = HBaseUtils.getQualifierNameForColumnName(colName);
            String discValue = new String(result.getValue(familyName.getBytes(), columnName.getBytes()));
            if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? !cmd.getFullClassName().equals(discValue) : cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP && !cmd.getDiscriminatorValue().equals(discValue)) {
                return null;
            }
        }
        FetchFieldManager fm = new FetchFieldManager(ec, cmd, result, tableName);
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)fm);
        Object pc = ec.findObject(id, new FieldValues((FieldManager)fm){
            final /* synthetic */ FieldManager val$fm;
            {
                this.val$fm = fieldManager;
            }

            public void fetchFields(ObjectProvider sm) {
                sm.replaceFields(fpMembers, this.val$fm);
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                sm.replaceNonLoadedFields(fpMembers, this.val$fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, null, ignoreCache, false);
        if (cmd.isVersioned()) {
            sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = HBaseUtils.getSurrogateVersionForObject(cmd, result, tableName, storeMgr);
            }
            sm.setVersion(version);
        }
        if (result.getRow() != null) {
            sm = ec.findObjectProvider(pc);
            sm.setAssociatedValue((Object)"HBASE_ROW_KEY", (Object)result.getRow());
        }
        return pc;
    }

    protected static Object getObjectUsingDatastoreIdForResult(Result result, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers, String tableName, StoreManager storeMgr) {
        ObjectProvider sm;
        if (cmd.hasDiscriminatorStrategy()) {
            String colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
            String familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
            String columnName = HBaseUtils.getQualifierNameForColumnName(colName);
            String discValue = new String(result.getValue(familyName.getBytes(), columnName.getBytes()));
            if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? !cmd.getFullClassName().equals(discValue) : cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP && !cmd.getDiscriminatorValue().equals(discValue)) {
                return null;
            }
        }
        String dsidColName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN);
        String dsidFamilyName = HBaseUtils.getFamilyNameForColumnName(dsidColName, tableName);
        String dsidColumnName = HBaseUtils.getQualifierNameForColumnName(dsidColName);
        DatastoreId id = null;
        try {
            byte[] bytes = result.getValue(dsidFamilyName.getBytes(), dsidColumnName.getBytes());
            if (bytes == null) {
                throw new NucleusException("Retrieved identity for family=" + dsidFamilyName + " column=" + dsidColumnName + " IS NULL");
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object key = ois.readObject();
            id = ec.getNucleusContext().getIdentityManager().getDatastoreId(cmd.getFullClassName(), key);
            ois.close();
            bis.close();
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        FetchFieldManager fm = new FetchFieldManager(ec, cmd, result, tableName);
        Object pc = ec.findObject((Object)id, new FieldValues((FieldManager)fm){
            final /* synthetic */ FieldManager val$fm;
            {
                this.val$fm = fieldManager;
            }

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, this.val$fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, this.val$fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, null, ignoreCache, false);
        if (cmd.isVersioned()) {
            sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = HBaseUtils.getSurrogateVersionForObject(cmd, result, tableName, storeMgr);
            }
            sm.setVersion(version);
        }
        if (result.getRow() != null) {
            sm = ec.findObjectProvider(pc);
            sm.setAssociatedValue((Object)"HBASE_ROW_KEY", (Object)result.getRow());
        }
        return pc;
    }

    protected static Object getObjectUsingNondurableIdForResult(Result result, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers, String tableName, StoreManager storeMgr) {
        ObjectProvider sm;
        if (cmd.hasDiscriminatorStrategy()) {
            String colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
            String familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
            String columnName = HBaseUtils.getQualifierNameForColumnName(colName);
            String discValue = new String(result.getValue(familyName.getBytes(), columnName.getBytes()));
            if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? !cmd.getFullClassName().equals(discValue) : cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP && !cmd.getDiscriminatorValue().equals(discValue)) {
                return null;
            }
        }
        FetchFieldManager fm = new FetchFieldManager(ec, cmd, result, tableName);
        SCOID id = new SCOID(cmd.getFullClassName());
        Object pc = ec.findObject((Object)id, new FieldValues((FieldManager)fm){
            final /* synthetic */ FieldManager val$fm;
            {
                this.val$fm = fieldManager;
            }

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, this.val$fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, this.val$fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, null, ignoreCache, false);
        if (cmd.isVersioned()) {
            sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = HBaseUtils.getSurrogateVersionForObject(cmd, result, tableName, storeMgr);
            }
            sm.setVersion(version);
        }
        if (result.getRow() != null) {
            sm = ec.findObjectProvider(pc);
            sm.setAssociatedValue((Object)"HBASE_ROW_KEY", (Object)result.getRow());
        }
        return pc;
    }

    private static void addColumnsToScanForEmbeddedMember(Scan scan, AbstractMemberMetaData mmd, String tableName, ExecutionContext ec) {
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
        for (int i = 0; i < embmmds.length; ++i) {
            AbstractMemberMetaData embMmd = embmmds[i];
            RelationType relationType = embMmd.getRelationType(clr);
            if ((relationType == RelationType.ONE_TO_ONE_BI || relationType == RelationType.ONE_TO_ONE_UNI) && embMmd.isEmbedded()) {
                HBaseQueryUtils.addColumnsToScanForEmbeddedMember(scan, embMmd, tableName, ec);
                continue;
            }
            byte[] familyName = HBaseUtils.getFamilyName(mmd, i, tableName).getBytes();
            byte[] qualifName = HBaseUtils.getQualifierName(mmd, i).getBytes();
            scan.addColumn(familyName, qualifName);
        }
    }
}

