/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.VersionHelper;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchFieldManager;
import org.datanucleus.store.hbase.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class HBasePersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());
    protected final HBaseStoreManager storeMgr;

    public HBasePersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (HBaseStoreManager)storeMgr;
    }

    public void close() {
    }

    public void insertObjects(ObjectProvider ... ops) {
        if (ops.length == 1) {
            this.insertObject(ops[0]);
            return;
        }
        super.insertObjects(ops);
    }

    public void insertObject(ObjectProvider op) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        if (!this.storeMgr.managesClass(op.getClassMetaData().getFullClassName())) {
            this.storeMgr.addClass(op.getClassMetaData().getFullClassName(), op.getExecutionContext().getClassLoaderResolver());
        }
        AbstractClassMetaData cmd = op.getClassMetaData();
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(op.getExecutionContext());
        try {
            String qualifName;
            String familyName;
            String tableName = this.storeMgr.getNamingFactory().getTableName(cmd);
            HTable table = mconn.getHTable(tableName);
            boolean enforceUniquenessInApp = this.storeMgr.getBooleanProperty("datanucleus.hbase.enforceUniquenessInApplication", false);
            if (enforceUniquenessInApp) {
                NucleusLogger.DATASTORE_PERSIST.info((Object)"User requesting to enforce uniqueness of object identity in their application, so not checking for existence");
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
                try {
                    if (HBaseUtils.objectExistsInTable(op, table)) {
                        throw new NucleusUserException(LOCALISER.msg("HBase.Insert.ObjectWithIdAlreadyExists", (Object)op.toPrintableID(), op.getInternalObjectId()));
                    }
                }
                catch (IOException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            if (cmd.getIdentityType() == IdentityType.NONDURABLE) {
                throw new NucleusUserException("Nondurable identity type unsupported for HBase");
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.Insert.Start", (Object)op.toPrintableID(), op.getInternalObjectId()));
            }
            Put put = HBaseUtils.getPutForObject(op);
            Delete delete = HBaseUtils.getDeleteForObject(op);
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                String colName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN);
                familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
                qualifName = HBaseUtils.getQualifierNameForColumnName(colName);
                Object key = ((OID)op.getInternalObjectId()).getKeyValue();
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(key);
                    oos.flush();
                    put.add(familyName.getBytes(), qualifName.getBytes(), bos.toByteArray());
                    oos.close();
                    bos.close();
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            if (cmd.hasDiscriminatorStrategy()) {
                DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
                String discVal = null;
                discVal = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
                String colName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
                String familyName2 = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
                String qualifName2 = HBaseUtils.getQualifierNameForColumnName(colName);
                put.add(familyName2.getBytes(), qualifName2.getBytes(), discVal.getBytes());
            }
            if (this.storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
                String name = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN);
                familyName = HBaseUtils.getFamilyNameForColumnName(name, tableName);
                qualifName = HBaseUtils.getQualifierNameForColumnName(name);
                put.add(familyName.getBytes(), qualifName.getBytes(), this.storeMgr.getStringProperty("datanucleus.TenantID").getBytes());
            }
            if (cmd.isVersioned()) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                String colName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
                String familyName3 = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
                String qualifName3 = HBaseUtils.getQualifierNameForColumnName(colName);
                if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                    long versionNumber = 1L;
                    op.setTransactionalVersion((Object)versionNumber);
                    if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("HBase.Insert.ObjectPersistedWithVersion", (Object)op.toPrintableID(), op.getInternalObjectId(), (Object)("" + versionNumber)));
                    }
                    if (vermd.getFieldName() != null) {
                        AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                        Number verFieldValue = versionNumber;
                        if (verMmd.getType() == Integer.TYPE || verMmd.getType() == Integer.class) {
                            verFieldValue = (int)versionNumber;
                        }
                        op.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)verFieldValue);
                    } else {
                        put.add(familyName3.getBytes(), qualifName3.getBytes(), Bytes.toBytes((long)versionNumber));
                    }
                } else if (vermd.getVersionStrategy() == VersionStrategy.DATE_TIME) {
                    Date date = new Date();
                    Timestamp ts = new Timestamp(date.getTime());
                    op.setTransactionalVersion((Object)ts);
                    if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("HBase.Insert.ObjectPersistedWithVersion", (Object)op.toPrintableID(), op.getInternalObjectId(), (Object)("" + ts)));
                    }
                    if (vermd.getFieldName() != null) {
                        AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                        op.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)ts);
                    } else {
                        try {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ObjectOutputStream oos = new ObjectOutputStream(bos);
                            oos.writeObject(ts);
                            put.add(familyName3.getBytes(), qualifName3.getBytes(), bos.toByteArray());
                            oos.close();
                            bos.close();
                        }
                        catch (IOException e) {
                            throw new NucleusException(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            StoreFieldManager fm = new StoreFieldManager(op, put, delete, true, tableName);
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)fm);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER.msg("HBase.Put", (Object)StringUtils.toJVMIDString((Object)op.getObject()), (Object)tableName, (Object)put));
            }
            table.put(put);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementInsertCount();
            }
        }
        catch (NucleusException ne) {
            throw ne;
        }
        catch (Exception e) {
            NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown on insert", (Throwable)e);
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(op.getExecutionContext());
        try {
            long startTime = System.currentTimeMillis();
            AbstractClassMetaData cmd = op.getClassMetaData();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.Update.Start", (Object)op.toPrintableID(), op.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            String tableName = this.storeMgr.getNamingFactory().getTableName(cmd);
            HTable table = mconn.getHTable(tableName);
            if (cmd.isVersioned()) {
                Result result = HBaseUtils.getResultForObject(op, table);
                Object datastoreVersion = HBaseUtils.getVersionForObject(cmd, result, op.getExecutionContext(), tableName, (StoreManager)this.storeMgr);
                VersionHelper.performVersionCheck((ObjectProvider)op, (Object)datastoreVersion, (VersionMetaData)cmd.getVersionMetaDataForClass());
            }
            Put put = HBaseUtils.getPutForObject(op);
            Delete delete = HBaseUtils.getDeleteForObject(op);
            if (cmd.isVersioned()) {
                Object currentVersion = op.getTransactionalVersion();
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                Object nextVersion = VersionHelper.getNextVersion((VersionStrategy)vermd.getVersionStrategy(), (Object)currentVersion);
                op.setTransactionalVersion(nextVersion);
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), nextVersion);
                } else {
                    String colName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
                    String familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
                    String qualifName = HBaseUtils.getQualifierNameForColumnName(colName);
                    if (nextVersion instanceof Long) {
                        put.add(familyName.getBytes(), qualifName.getBytes(), Bytes.toBytes((long)((Long)nextVersion)));
                    } else if (nextVersion instanceof Integer) {
                        put.add(familyName.getBytes(), qualifName.getBytes(), Bytes.toBytes((int)((Integer)nextVersion)));
                    } else {
                        put.add(familyName.getBytes(), qualifName.getBytes(), ((String)nextVersion).getBytes());
                    }
                }
            }
            StoreFieldManager fm = new StoreFieldManager(op, put, delete, false, tableName);
            op.provideFields(fieldNumbers, (FieldManager)fm);
            if (!put.isEmpty()) {
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER.msg("HBase.Put", (Object)StringUtils.toJVMIDString((Object)op.getObject()), (Object)tableName, (Object)put));
                }
                table.put(put);
            }
            if (!delete.isEmpty()) {
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER.msg("HBase.Delete", (Object)StringUtils.toJVMIDString((Object)op.getObject()), (Object)tableName, (Object)delete));
                }
                table.delete(delete);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
        }
        catch (NucleusException ne) {
            throw ne;
        }
        catch (Exception e) {
            NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown on update", (Throwable)e);
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObjects(ObjectProvider ... ops) {
        HashSet<ObjectProvider> opsForTable;
        if (ops.length == 1) {
            this.deleteObject(ops[0]);
            return;
        }
        HashMap<String, HashSet<ObjectProvider>> opsByTable = new HashMap<String, HashSet<ObjectProvider>>();
        for (int i = 0; i < ops.length; ++i) {
            AbstractClassMetaData cmd = ops[i].getClassMetaData();
            String tableName = this.storeMgr.getNamingFactory().getTableName(cmd);
            opsForTable = (HashSet<ObjectProvider>)opsByTable.get(tableName);
            if (opsForTable == null) {
                opsForTable = new HashSet<ObjectProvider>();
                opsByTable.put(tableName, opsForTable);
            }
            opsForTable.add(ops[i]);
        }
        HashSet<NucleusOptimisticException> optimisticExcps = null;
        for (String tableName : opsByTable.keySet()) {
            opsForTable = (Set)opsByTable.get(tableName);
            ExecutionContext ec = ops[0].getExecutionContext();
            HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(ec);
            try {
                long startTime = System.currentTimeMillis();
                HTable table = mconn.getHTable(tableName);
                ArrayList<Delete> deletes = new ArrayList<Delete>(opsForTable.size());
                for (ObjectProvider op : opsForTable) {
                    this.storeMgr.assertReadOnlyForUpdateOfObject(op);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.Delete.Start", (Object)op.toPrintableID(), op.getInternalObjectId()));
                    }
                    boolean deletable = true;
                    AbstractClassMetaData cmd = op.getClassMetaData();
                    if (cmd.isVersioned()) {
                        Object currentVersion = op.getTransactionalVersion();
                        Result result = HBaseUtils.getResultForObject(op, table);
                        Object datastoreVersion = HBaseUtils.getVersionForObject(cmd, result, ec, tableName, (StoreManager)this.storeMgr);
                        if (!datastoreVersion.equals(currentVersion)) {
                            if (optimisticExcps == null) {
                                optimisticExcps = new HashSet<NucleusOptimisticException>();
                            }
                            optimisticExcps.add(new NucleusOptimisticException("Cannot delete object with id " + op.getObjectId() + " since has version=" + currentVersion + " while datastore has version=" + datastoreVersion));
                            deletable = false;
                        }
                    }
                    if (!deletable) continue;
                    op.loadUnloadedFields();
                    op.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(op));
                    deletes.add(HBaseUtils.getDeleteForObject(op));
                }
                table.delete(deletes);
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
                }
                if (this.storeMgr.getRuntimeManager() == null) continue;
                for (int i = 0; i < opsForTable.size(); ++i) {
                    this.storeMgr.getRuntimeManager().incrementDeleteCount();
                }
            }
            catch (NucleusException ne) {
                throw ne;
            }
            catch (Exception e) {
                NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown on delete", (Throwable)e);
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
        if (optimisticExcps != null) {
            if (optimisticExcps.size() == 1) {
                throw (NucleusOptimisticException)optimisticExcps.iterator().next();
            }
            throw new NucleusOptimisticException("Optimistic exceptions thrown during delete of objects", (Throwable[])optimisticExcps.toArray(new NucleusOptimisticException[optimisticExcps.size()]));
        }
    }

    public void deleteObject(ObjectProvider op) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(op.getExecutionContext());
        try {
            AbstractClassMetaData cmd = op.getClassMetaData();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.Delete.Start", (Object)op.toPrintableID(), op.getInternalObjectId()));
            }
            String tableName = this.storeMgr.getNamingFactory().getTableName(cmd);
            HTable table = mconn.getHTable(tableName);
            if (cmd.isVersioned()) {
                Result result = HBaseUtils.getResultForObject(op, table);
                Object datastoreVersion = HBaseUtils.getVersionForObject(cmd, result, op.getExecutionContext(), tableName, (StoreManager)this.storeMgr);
                VersionHelper.performVersionCheck((ObjectProvider)op, (Object)datastoreVersion, (VersionMetaData)cmd.getVersionMetaDataForClass());
            }
            op.loadUnloadedFields();
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(op));
            Delete delete = HBaseUtils.getDeleteForObject(op);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER.msg("HBase.Delete", (Object)StringUtils.toJVMIDString((Object)op.getObject()), (Object)tableName, (Object)delete));
            }
            table.delete(delete);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementDeleteCount();
            }
        }
        catch (NucleusException ne) {
            throw ne;
        }
        catch (Exception e) {
            NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown on delete", (Throwable)e);
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(op.getExecutionContext());
        try {
            String tableName;
            HTable table;
            Result result;
            AbstractClassMetaData cmd = op.getClassMetaData();
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                StringBuffer str = new StringBuffer("Fetching object \"");
                str.append(op.toPrintableID()).append("\" (id=");
                str.append(op.getExecutionContext().getApiAdapter().getObjectId(op)).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.PERSISTENCE.debug((Object)str);
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("HBase.Fetch.Start", (Object)op.toPrintableID(), op.getInternalObjectId()));
            }
            if ((result = HBaseUtils.getResultForObject(op, table = mconn.getHTable(tableName = this.storeMgr.getNamingFactory().getTableName(cmd)))).getRow() == null) {
                throw new NucleusObjectNotFoundException();
            }
            if (cmd.hasDiscriminatorStrategy()) {
                String colName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
                String familyName = HBaseUtils.getFamilyNameForColumnName(colName, tableName);
                String columnName = HBaseUtils.getQualifierNameForColumnName(colName);
                String discValue = new String(result.getValue(familyName.getBytes(), columnName.getBytes()));
                if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? !cmd.getFullClassName().equals(discValue) : cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP && !cmd.getDiscriminatorValue().equals(discValue)) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            FetchFieldManager fm = new FetchFieldManager(op, result, tableName);
            op.replaceFields(cmd.getAllMemberPositions(), (FieldManager)fm);
            if (cmd.isVersioned() && op.getTransactionalVersion() == null) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getFieldName() != null) {
                    Object datastoreVersion = op.provideField(cmd.getAbsolutePositionOfMember(vermd.getFieldName()));
                    op.setVersion(datastoreVersion);
                } else {
                    op.setVersion(HBaseUtils.getSurrogateVersionForObject(cmd, result, tableName, (StoreManager)this.storeMgr));
                }
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementFetchCount();
            }
        }
        catch (NucleusException ne) {
            throw ne;
        }
        catch (Exception e) {
            NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown on fetch", (Throwable)e);
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext ectx, Object id) {
        return null;
    }

    public void locateObject(ObjectProvider op) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(op.getExecutionContext());
            try {
                String tableName = this.storeMgr.getNamingFactory().getTableName(cmd);
                HTable table = mconn.getHTable(tableName);
                if (!HBaseUtils.objectExistsInTable(op, table)) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            catch (NucleusException ne) {
                throw ne;
            }
            catch (Exception e) {
                NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown on existence check", (Throwable)e);
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }
}

