/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.hbase.HBaseConnectionPool;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.util.Localiser;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    protected static final Localiser LOCALISER_HBASE = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());
    private HBaseConnectionPool connectionPool;
    private int poolMinEvictableIdleTimeMillis = 0;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        int poolTimeBetweenEvictionRunsMillis = storeMgr.getIntProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis");
        if (poolTimeBetweenEvictionRunsMillis == 0) {
            poolTimeBetweenEvictionRunsMillis = 15000;
        }
        this.poolMinEvictableIdleTimeMillis = storeMgr.getIntProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis");
        if (this.poolMinEvictableIdleTimeMillis == 0) {
            this.poolMinEvictableIdleTimeMillis = 30000;
        }
        this.connectionPool = new HBaseConnectionPool();
        this.connectionPool.setTimeBetweenEvictionRunsMillis(poolTimeBetweenEvictionRunsMillis);
        String url = storeMgr.getConnectionURL();
        if (!url.startsWith("hbase")) {
            throw new NucleusException(LOCALISER_HBASE.msg("HBase.URLInvalid", (Object)url));
        }
        String hbaseStr = url.substring(5);
        if (hbaseStr.startsWith(":")) {
            hbaseStr = hbaseStr.substring(1);
        }
        if (hbaseStr.length() > 0) {
            String serverName = hbaseStr;
            String portName = "60000";
            if (hbaseStr.indexOf(58) > 0) {
                serverName = hbaseStr.substring(0, hbaseStr.indexOf(58));
                portName = hbaseStr.substring(hbaseStr.indexOf(58) + 1);
            }
            HBaseStoreManager hbaseStoreMgr = (HBaseStoreManager)storeMgr;
            hbaseStoreMgr.getHbaseConfig().set("hbase.zookeeper.quorum", serverName);
            hbaseStoreMgr.getHbaseConfig().set("hbase.master", serverName + ":" + portName);
        }
    }

    public ManagedConnection createManagedConnection(Object poolKey, Map options) {
        HBaseStoreManager storeManager = (HBaseStoreManager)this.storeMgr;
        HBaseManagedConnection managedConnection = this.connectionPool.getPooledConnection();
        if (managedConnection == null) {
            managedConnection = new HBaseManagedConnection(storeManager.getHbaseConfig());
            managedConnection.setIdleTimeoutMills(this.poolMinEvictableIdleTimeMillis);
            this.connectionPool.registerConnection(managedConnection);
        }
        return managedConnection;
    }
}

