/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUnsupportedOptionException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class HBaseUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());

    public static String getDefaultValueForMember(AbstractMemberMetaData mmd) {
        ColumnMetaData[] colmds = mmd.getColumnMetaData();
        if (colmds == null || colmds.length < 1) {
            return null;
        }
        return colmds[0].getDefaultValue();
    }

    public static String getTableName(AbstractClassMetaData acmd) {
        if (acmd.getTable() != null) {
            return acmd.getTable();
        }
        return acmd.getName();
    }

    public static String getFamilyName(AbstractMemberMetaData mmd, int fieldNumber, String tableNameForClass) {
        AbstractMemberMetaData[] embmmds;
        ColumnMetaData[] colmds;
        String columnName = null;
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null && (colmds = (embMmd = (embmmds = embmd.getMemberMetaData())[fieldNumber]).getColumnMetaData()) != null && colmds.length > 0 && (columnName = colmds[0].getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return tableNameForClass;
    }

    public static String getQualifierName(AbstractMemberMetaData mmd, int fieldNumber) {
        ColumnMetaData[] colmds;
        String columnName = null;
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null) {
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            embMmd = embmmds[fieldNumber];
        }
        if ((colmds = embMmd.getColumnMetaData()) != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = embMmd.getName();
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    public static String getFamilyName(IdentityMetaData idmd) {
        String columnName = null;
        ColumnMetaData colmd = idmd.getColumnMetaData();
        if (colmd != null && (columnName = colmd.getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return HBaseUtils.getTableName((AbstractClassMetaData)idmd.getParent());
    }

    public static String getQualifierName(IdentityMetaData idmd) {
        String columnName = null;
        ColumnMetaData colmd = idmd.getColumnMetaData();
        if (colmd != null) {
            columnName = colmd.getName();
        }
        if (columnName == null) {
            columnName = "IDENTITY";
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    public static String getFamilyName(DiscriminatorMetaData dismd) {
        String columnName = null;
        ColumnMetaData colmd = dismd.getColumnMetaData();
        if (colmd != null && (columnName = colmd.getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return HBaseUtils.getTableName((AbstractClassMetaData)dismd.getParent().getParent());
    }

    public static String getQualifierName(DiscriminatorMetaData dismd) {
        String columnName = null;
        ColumnMetaData colmd = dismd.getColumnMetaData();
        if (colmd != null) {
            columnName = colmd.getName();
        }
        if (columnName == null) {
            columnName = "DISCRIM";
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    public static String getFamilyName(VersionMetaData vermd) {
        String columnName = null;
        ColumnMetaData colmd = vermd.getColumnMetaData();
        if (colmd != null && (columnName = colmd.getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return HBaseUtils.getTableName((AbstractClassMetaData)vermd.getParent());
    }

    public static String getQualifierName(VersionMetaData vermd) {
        String columnName = null;
        ColumnMetaData colmd = vermd.getColumnMetaData();
        if (colmd != null) {
            columnName = colmd.getName();
        }
        if (columnName == null) {
            columnName = "VERSION";
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    public static String getFamilyName(AbstractClassMetaData acmd, int absoluteFieldNumber) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0 && (columnName = colmds[0].getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return HBaseUtils.getTableName(acmd);
    }

    public static String getQualifierName(AbstractClassMetaData acmd, int absoluteFieldNumber) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = ammd.getName();
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    static void createSchemaForClass(final HBaseStoreManager storeMgr, final AbstractClassMetaData acmd, final boolean validateOnly) {
        if (acmd.isEmbeddedOnly()) {
            return;
        }
        final Configuration config = storeMgr.getHbaseConfig();
        try {
            final HBaseAdmin hBaseAdmin = (HBaseAdmin)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new HBaseAdmin(config);
                }
            });
            final HTableDescriptor hTable = (HTableDescriptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTableDescriptor hTable;
                    block3: {
                        String tableName = HBaseUtils.getTableName(acmd);
                        hTable = null;
                        try {
                            hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
                        }
                        catch (TableNotFoundException ex) {
                            if (validateOnly) {
                                NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER.msg("HBase.SchemaValidate.Class", (Object)acmd.getFullClassName(), (Object)tableName));
                                hTable = null;
                            }
                            if (!storeMgr.isAutoCreateTables()) break block3;
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class", (Object)acmd.getFullClassName(), (Object)tableName));
                            hTable = new HTableDescriptor(tableName);
                            hBaseAdmin.createTable(hTable);
                        }
                    }
                    return hTable;
                }
            });
            if (hTable != null) {
                boolean modified = false;
                String tableName = HBaseUtils.getTableName(acmd);
                if (!hTable.hasFamily(tableName.getBytes())) {
                    if (validateOnly) {
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER.msg("HBase.SchemaValidate.Class.Family", (Object)tableName, (Object)tableName));
                    } else if (storeMgr.isAutoCreateColumns()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class.Family", (Object)tableName, (Object)tableName));
                        HColumnDescriptor hColumn = new HColumnDescriptor(tableName);
                        hTable.addFamily(hColumn);
                        modified = true;
                    }
                }
                int[] fieldNumbers = acmd.getAllMemberPositions();
                ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    AbstractMemberMetaData mmd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                    int relationType = mmd.getRelationType(clr);
                    if ((relationType == 1 || relationType == 2) && mmd.isEmbedded()) {
                        HBaseUtils.createSchemaForEmbeddedMember(storeMgr, hTable, mmd, clr, validateOnly);
                        continue;
                    }
                    String familyName = HBaseUtils.getFamilyName(acmd, fieldNumbers[i]);
                    if (hTable.hasFamily(familyName.getBytes())) continue;
                    if (validateOnly) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaValidate.Class.Family", (Object)tableName, (Object)familyName));
                        continue;
                    }
                    if (!storeMgr.isAutoCreateColumns()) continue;
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class.Family", (Object)tableName, (Object)familyName));
                    HColumnDescriptor hColumn = new HColumnDescriptor(familyName);
                    hTable.addFamily(hColumn);
                    modified = true;
                }
                if (modified) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            hBaseAdmin.disableTable(hTable.getName());
                            hBaseAdmin.modifyTable(hTable.getName(), hTable);
                            hBaseAdmin.enableTable(hTable.getName());
                            return null;
                        }
                    });
                }
            }
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
    }

    static boolean createSchemaForEmbeddedMember(HBaseStoreManager storeMgr, HTableDescriptor hTable, AbstractMemberMetaData mmd, ClassLoaderResolver clr, boolean validateOnly) {
        boolean modified = false;
        String tableName = hTable.getNameAsString();
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
        for (int j = 0; j < embmmds.length; ++j) {
            AbstractMemberMetaData embMmd = embmmds[j];
            int embRelationType = embMmd.getRelationType(clr);
            if ((embRelationType == 1 || embRelationType == 2) && embMmd.isEmbedded()) {
                return HBaseUtils.createSchemaForEmbeddedMember(storeMgr, hTable, embMmd, clr, validateOnly);
            }
            String familyName = HBaseUtils.getFamilyName(embMmd, j, tableName);
            if (hTable.hasFamily(familyName.getBytes())) continue;
            if (validateOnly) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaValidate.Class.Family", (Object)tableName, (Object)familyName));
                continue;
            }
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class.Family", (Object)tableName, (Object)familyName));
            HColumnDescriptor hColumn = new HColumnDescriptor(familyName);
            hTable.addFamily(hColumn);
            modified = true;
        }
        return modified;
    }

    static void deleteSchemaForClass(HBaseStoreManager storeMgr, final AbstractClassMetaData acmd) {
        if (acmd.isEmbeddedOnly()) {
            return;
        }
        final Configuration config = storeMgr.getHbaseConfig();
        try {
            final HBaseAdmin hBaseAdmin = (HBaseAdmin)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new HBaseAdmin(config);
                }
            });
            final HTableDescriptor hTable = (HTableDescriptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTableDescriptor hTable;
                    String tableName = HBaseUtils.getTableName(acmd);
                    try {
                        hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
                    }
                    catch (TableNotFoundException ex) {
                        hTable = new HTableDescriptor(tableName);
                        hBaseAdmin.createTable(hTable);
                    }
                    return hTable;
                }
            });
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaDelete.Class", (Object)acmd.getFullClassName(), (Object)hTable.getNameAsString()));
                    hBaseAdmin.disableTable(hTable.getName());
                    hBaseAdmin.deleteTable(hTable.getName());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
    }

    public static Object getVersionForObject(AbstractClassMetaData cmd, Result result, ExecutionContext ec) {
        if (cmd.isVersioned()) {
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                String familyName = HBaseUtils.getFamilyName(cmd, verMmd.getAbsoluteFieldNumber());
                String columnName = HBaseUtils.getQualifierName(cmd, verMmd.getAbsoluteFieldNumber());
                Object version = null;
                try {
                    byte[] bytes = result.getValue(familyName.getBytes(), columnName.getBytes());
                    if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                        version = Bytes.toLong((byte[])bytes);
                    } else if (Date.class.isAssignableFrom(verMmd.getType())) {
                        String strValue = new String(bytes);
                        ObjectStringConverter strConv = ec.getNucleusContext().getTypeManager().getStringConverter(verMmd.getType());
                        version = strConv.toObject(strValue);
                        version = new Timestamp(((Date)version).getTime());
                    } else {
                        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                        ObjectInputStream ois = new ObjectInputStream(bis);
                        version = ois.readObject();
                        ois.close();
                        bis.close();
                    }
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
                return version;
            }
            return HBaseUtils.getSurrogateVersionForObject(cmd, result);
        }
        return null;
    }

    public static Object getSurrogateVersionForObject(AbstractClassMetaData cmd, Result result) {
        VersionMetaData vermd = cmd.getVersionMetaDataForClass();
        String familyName = HBaseUtils.getFamilyName(vermd);
        String columnName = HBaseUtils.getQualifierName(vermd);
        Object version = null;
        try {
            byte[] bytes = result.getValue(familyName.getBytes(), columnName.getBytes());
            if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                version = Bytes.toLong((byte[])bytes);
            } else {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                version = ois.readObject();
                ois.close();
                bis.close();
            }
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return version;
    }

    public static Object getDiscriminatorForObject(AbstractClassMetaData cmd, Result result) {
        String familyName = HBaseUtils.getFamilyName(cmd.getDiscriminatorMetaData());
        String columnName = HBaseUtils.getQualifierName(cmd.getDiscriminatorMetaData());
        byte[] bytes = result.getValue(familyName.getBytes(), columnName.getBytes());
        return new String(bytes);
    }

    public static Put getPutForObject(ObjectProvider sm) throws IOException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Object[] pkValues = HBaseUtils.findKeyObjects(sm, cmd);
        byte[] pkBytes = HBaseUtils.getBytesForPkValue(pkValues, sm.getExecutionContext().getNucleusContext());
        return new Put(pkBytes);
    }

    public static Delete getDeleteForObject(ObjectProvider sm) throws IOException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Object[] pkValues = HBaseUtils.findKeyObjects(sm, cmd);
        byte[] pkBytes = HBaseUtils.getBytesForPkValue(pkValues, sm.getExecutionContext().getNucleusContext());
        return new Delete(pkBytes);
    }

    public static Result getResultForObject(ObjectProvider sm, HTable table) throws IOException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Object[] pkValues = HBaseUtils.findKeyObjects(sm, cmd);
        byte[] pkBytes = HBaseUtils.getBytesForPkValue(pkValues, sm.getExecutionContext().getNucleusContext());
        Get get = new Get(pkBytes);
        return table.get(get);
    }

    public static boolean objectExistsInTable(ObjectProvider sm, HTable table) throws IOException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Object[] pkValues = HBaseUtils.findKeyObjects(sm, cmd);
        byte[] pkBytes = HBaseUtils.getBytesForPkValue(pkValues, sm.getExecutionContext().getNucleusContext());
        Get get = new Get(pkBytes);
        return table.exists(get);
    }

    private static Object[] findKeyObjects(ObjectProvider sm, AbstractClassMetaData cmd) {
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return new Object[]{((OID)sm.getInternalObjectId()).getKeyValue()};
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pos = sm.getClassMetaData().getPKMemberPositions();
            Object[] keyObjects = new Object[pos.length];
            for (int i = 0; i < pos.length; ++i) {
                keyObjects[i] = sm.provideField(pos[i]);
            }
            return keyObjects;
        }
        throw new NucleusUnsupportedOptionException("unsupported identity type: " + cmd.getIdentityType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getBytesForPkValue(Object[] pkValues, NucleusContext nucCtx) throws IOException {
        boolean useSerialisation = nucCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.hbase.serialisedPK");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if (useSerialisation) {
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                try {
                    for (Object pkValue : pkValues) {
                        oos.writeObject(pkValue);
                    }
                }
                finally {
                    oos.close();
                }
            } else {
                for (Object pkValue : pkValues) {
                    if (pkValue instanceof String) {
                        bos.write(Bytes.toBytes((String)((String)pkValue)));
                        continue;
                    }
                    if (pkValue instanceof Long) {
                        bos.write(Bytes.toBytes((long)((Long)pkValue)));
                        continue;
                    }
                    if (pkValue instanceof Integer) {
                        bos.write(Bytes.toBytes((int)((Integer)pkValue)));
                        continue;
                    }
                    if (pkValue instanceof Short) {
                        bos.write(Bytes.toBytes((short)((Short)pkValue)));
                        continue;
                    }
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    try {
                        oos.writeObject(pkValue);
                    }
                    finally {
                        oos.close();
                    }
                }
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            bos.close();
        }
    }
}

