/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.fieldmanager;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.types.ObjectStringConverter;

public class StoreFieldManager
extends AbstractFieldManager {
    ObjectProvider sm;
    Put put;
    Delete delete;
    AbstractClassMetaData cmd;

    public StoreFieldManager(ObjectProvider sm, Put put, Delete delete) {
        this.sm = sm;
        this.cmd = sm.getClassMetaData();
        this.put = put;
        this.delete = delete;
    }

    protected String getFamilyName(int fieldNumber) {
        return HBaseUtils.getFamilyName(this.cmd, fieldNumber);
    }

    protected String getQualifierName(int fieldNumber) {
        return HBaseUtils.getQualifierName(this.cmd, fieldNumber);
    }

    protected AbstractMemberMetaData getMemberMetaData(int fieldNumber) {
        return this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeBoolean(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((boolean)value));
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        this.put.add(familyName.getBytes(), columnName.getBytes(), new byte[]{value});
    }

    public void storeCharField(int fieldNumber, char value) {
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeChar(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), ("" + value).getBytes());
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeDouble(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((double)value));
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeFloat(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((float)value));
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeInt(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((int)value));
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeLong(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((long)value));
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeShort(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((short)value));
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        if (value == null) {
            this.delete.deleteColumn(familyName.getBytes(), columnName.getBytes());
        } else {
            AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
            if (mmd.isSerialized()) {
                this.writeObjectField(familyName, columnName, value);
            } else {
                this.put.add(familyName.getBytes(), columnName.getBytes(), value.getBytes());
            }
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        ExecutionContext ec = this.sm.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        int relationType = mmd.getRelationType(clr);
        if (mmd.isEmbedded() && Relation.isRelationSingleValued((int)relationType)) {
            Class embcls = mmd.getType();
            AbstractClassMetaData embcmd = ec.getMetaDataManager().getMetaDataForClass(embcls, clr);
            if (embcmd != null) {
                if (value == null) {
                    this.deleteColumnsForEmbeddedMember(mmd, clr, ec);
                    return;
                }
                ObjectProvider embSM = ec.findObjectProviderForEmbedded(value, this.sm, mmd);
                StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embSM, this.put, this.delete, mmd, HBaseUtils.getTableName(this.cmd));
                embSM.provideFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return;
            }
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
        }
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        if (value == null) {
            this.delete.deleteColumn(familyName.getBytes(), columnName.getBytes());
        } else if (Relation.isRelationSingleValued((int)relationType)) {
            Object valuePC = this.sm.getExecutionContext().persistObjectInternal(value, this.sm, fieldNumber, -1);
            if (mmd.isSerialized()) {
                this.writeObjectField(familyName, columnName, value);
            } else {
                Object valueId = ec.getApiAdapter().getIdForObject(valuePC);
                this.writeObjectField(familyName, columnName, valueId);
            }
        } else if (Relation.isRelationMultiValued((int)relationType)) {
            if (mmd.hasCollection()) {
                ArrayList<Object> collIds = new ArrayList<Object>();
                Collection coll = (Collection)value;
                for (Object element : coll) {
                    Object elementPC = this.sm.getExecutionContext().persistObjectInternal(element, this.sm, fieldNumber, -1);
                    Object elementID = this.sm.getExecutionContext().getApiAdapter().getIdForObject(elementPC);
                    collIds.add(elementID);
                }
                if (mmd.isSerialized()) {
                    this.writeObjectField(familyName, columnName, value);
                } else {
                    this.writeObjectField(familyName, columnName, collIds);
                }
                this.sm.wrapSCOField(fieldNumber, value, false, false, true);
            } else if (mmd.hasMap()) {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    Object mapKey = entry.getKey();
                    Object mapValue = entry.getValue();
                    if (ec.getApiAdapter().isPersistable(mapKey)) {
                        ec.persistObjectInternal(mapKey, this.sm, fieldNumber, -1);
                    }
                    if (!ec.getApiAdapter().isPersistable(mapValue)) continue;
                    ec.persistObjectInternal(mapValue, this.sm, fieldNumber, -1);
                }
                if (!mmd.isSerialized()) {
                    throw new NucleusException("Only currently support maps serialised with HBase. Mark the field as serialized");
                }
                this.writeObjectField(familyName, columnName, value);
                this.sm.wrapSCOField(fieldNumber, value, false, false, true);
            } else if (mmd.hasArray()) {
                ArrayList<Object> arrIds = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    Object elementPC = ec.persistObjectInternal(element, this.sm, fieldNumber, -1);
                    Object elementID = ec.getApiAdapter().getIdForObject(elementPC);
                    arrIds.add(elementID);
                }
                if (mmd.isSerialized()) {
                    this.writeObjectField(familyName, columnName, value);
                } else {
                    this.writeObjectField(familyName, columnName, arrIds);
                }
            }
        } else {
            if (!mmd.isSerialized()) {
                if (Enum.class.isAssignableFrom(value.getClass())) {
                    this.put.add(familyName.getBytes(), columnName.getBytes(), ((Enum)value).name().getBytes());
                    return;
                }
                ObjectStringConverter strConv = ec.getNucleusContext().getTypeManager().getStringConverter(value.getClass());
                if (strConv != null) {
                    String strValue = strConv.toString(value);
                    this.put.add(familyName.getBytes(), columnName.getBytes(), strValue.getBytes());
                    return;
                }
            }
            this.writeObjectField(familyName, columnName, value);
            this.sm.wrapSCOField(fieldNumber, value, false, false, true);
        }
    }

    protected void writeObjectField(String familyName, String columnName, Object value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    protected void deleteColumnsForEmbeddedMember(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec) {
        Class embcls = mmd.getType();
        AbstractClassMetaData embcmd = ec.getMetaDataManager().getMetaDataForClass(embcls, clr);
        if (embcmd != null) {
            EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            String tableName = HBaseUtils.getTableName(this.cmd);
            for (int i = 0; i < embmmds.length; ++i) {
                int relationType = embmmds[i].getRelationType(clr);
                if ((relationType == 2 || relationType == 1) && embmmds[i].isEmbedded()) {
                    this.deleteColumnsForEmbeddedMember(embmmds[i], clr, ec);
                    continue;
                }
                String familyName = HBaseUtils.getFamilyName(mmd, i, tableName);
                String columnName = HBaseUtils.getQualifierName(mmd, i);
                this.delete.deleteColumn(familyName.getBytes(), columnName.getBytes());
            }
            return;
        }
    }
}

