/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.fieldmanager;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.store.types.sco.SCOUtils;

public class FetchFieldManager
extends AbstractFieldManager {
    Result result;
    ExecutionContext ec;
    ObjectProvider sm;
    AbstractClassMetaData cmd;

    public FetchFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, Result result) {
        this.ec = ec;
        this.cmd = cmd;
        this.result = result;
    }

    public FetchFieldManager(ObjectProvider sm, Result result) {
        this.ec = sm.getExecutionContext();
        this.sm = sm;
        this.cmd = sm.getClassMetaData();
        this.result = result;
    }

    protected String getFamilyName(int fieldNumber) {
        return HBaseUtils.getFamilyName(this.cmd, fieldNumber);
    }

    protected String getQualifierName(int fieldNumber) {
        return HBaseUtils.getQualifierName(this.cmd, fieldNumber);
    }

    protected AbstractMemberMetaData getMemberMetaData(int fieldNumber) {
        return this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
    }

    public boolean fetchBooleanField(int fieldNumber) {
        boolean value;
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readBoolean();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toBoolean((byte[])bytes);
        }
        return value;
    }

    public byte fetchByteField(int fieldNumber) {
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
        return bytes[0];
    }

    public char fetchCharField(int fieldNumber) {
        char value;
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readChar();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            String strValue = new String(bytes);
            value = strValue.charAt(0);
        }
        return value;
    }

    public double fetchDoubleField(int fieldNumber) {
        double value;
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readDouble();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toDouble((byte[])bytes);
        }
        return value;
    }

    public float fetchFloatField(int fieldNumber) {
        float value;
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readFloat();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toFloat((byte[])bytes);
        }
        return value;
    }

    public int fetchIntField(int fieldNumber) {
        int value;
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readInt();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toInt((byte[])bytes);
        }
        return value;
    }

    public long fetchLongField(int fieldNumber) {
        long value;
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readLong();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toLong((byte[])bytes);
        }
        return value;
    }

    public short fetchShortField(int fieldNumber) {
        short value;
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readShort();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toShort((byte[])bytes);
        }
        return value;
    }

    public String fetchStringField(int fieldNumber) {
        String value;
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
        if (bytes == null) {
            return null;
        }
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = (String)ois.readObject();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = new String(bytes);
        }
        return value;
    }

    public Object fetchObjectField(int fieldNumber) {
        String columnName;
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        int relationType = mmd.getRelationType(clr);
        if (mmd.isEmbedded() && Relation.isRelationSingleValued((int)relationType)) {
            Class embcls = mmd.getType();
            AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(embcls, clr);
            if (embcmd != null) {
                String tableName = HBaseUtils.getTableName(this.cmd);
                EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
                AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
                boolean isNull = true;
                for (int i = 0; i < embmmds.length; ++i) {
                    String familyName = HBaseUtils.getFamilyName(mmd, i, tableName);
                    String columnName2 = HBaseUtils.getQualifierName(mmd, i);
                    if (this.result.getValue(familyName.getBytes(), columnName2.getBytes()) == null) continue;
                    isNull = false;
                    break;
                }
                if (isNull) {
                    return null;
                }
                ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, embcmd, this.sm, fieldNumber);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embSM, this.result, mmd, tableName);
                embSM.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return embSM.getObject();
            }
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " marked as embedded but no such metadata");
        }
        String familyName = HBaseUtils.getFamilyName(this.cmd, fieldNumber);
        Object value = this.readObjectField(familyName, columnName = HBaseUtils.getQualifierName(this.cmd, fieldNumber), this.result);
        if (value == null) {
            return null;
        }
        if (Relation.isRelationSingleValued((int)relationType)) {
            if (mmd.isSerialized()) {
                return value;
            }
            return this.ec.findObject(value, true, true, null);
        }
        if (Relation.isRelationMultiValued((int)relationType)) {
            if (mmd.hasCollection()) {
                Collection coll;
                if (mmd.isSerialized()) {
                    return value;
                }
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                Collection collIds = (Collection)value;
                for (Object elementId : collIds) {
                    coll.add(this.ec.findObject(elementId, true, true, null));
                }
                if (this.sm != null) {
                    return this.sm.wrapSCOField(fieldNumber, (Object)coll, false, false, true);
                }
                return coll;
            }
            if (mmd.hasMap()) {
                if (mmd.isSerialized()) {
                    return value;
                }
            } else if (mmd.hasArray()) {
                if (mmd.isSerialized()) {
                    return value;
                }
                Collection arrIds = (Collection)value;
                Object array = Array.newInstance(mmd.getType().getComponentType(), arrIds.size());
                Iterator idIter = arrIds.iterator();
                int i = 0;
                while (idIter.hasNext()) {
                    Object elementId = idIter.next();
                    Array.set(array, i, this.ec.findObject(elementId, true, true, null));
                }
                return array;
            }
            throw new NucleusUserException("No container that isnt collection/map/array");
        }
        Object returnValue = value;
        if (!mmd.isSerialized()) {
            if (Enum.class.isAssignableFrom(mmd.getType())) {
                return Enum.valueOf(mmd.getType(), (String)value);
            }
            ObjectStringConverter strConv = this.ec.getNucleusContext().getTypeManager().getStringConverter(mmd.getType());
            if (strConv != null) {
                String strValue = (String)value;
                returnValue = strConv.toObject(strValue);
            }
        }
        if (this.sm != null) {
            return this.sm.wrapSCOField(fieldNumber, returnValue, false, false, true);
        }
        return returnValue;
    }

    protected Object readObjectField(String familyName, String columnName, Result result) {
        byte[] bytes = result.getValue(familyName.getBytes(), columnName.getBytes());
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bis);
            Object object = ois.readObject();
            return object;
        }
        catch (IOException e) {
            String string = new String(bytes);
            return string;
        }
        catch (ClassNotFoundException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException ioe) {
                throw new NucleusException(ioe.getMessage(), (Throwable)ioe);
            }
        }
    }
}

