/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class HBaseUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());

    public static String getTableName(AbstractClassMetaData acmd) {
        if (acmd.getTable() != null) {
            return acmd.getTable();
        }
        return acmd.getName();
    }

    public static String getFamilyName(AbstractMemberMetaData mmd, int fieldNumber, String tableNameForClass) {
        AbstractMemberMetaData[] embmmds;
        ColumnMetaData[] colmds;
        String columnName = null;
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null && (colmds = (embMmd = (embmmds = embmd.getMemberMetaData())[fieldNumber]).getColumnMetaData()) != null && colmds.length > 0 && (columnName = colmds[0].getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return tableNameForClass;
    }

    public static String getQualifierName(AbstractMemberMetaData mmd, int fieldNumber) {
        ColumnMetaData[] colmds;
        String columnName = null;
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null) {
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            embMmd = embmmds[fieldNumber];
        }
        if ((colmds = embMmd.getColumnMetaData()) != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = embMmd.getName();
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    public static String getFamilyName(IdentityMetaData idmd) {
        String columnName = null;
        ColumnMetaData[] colmds = idmd.getColumnMetaData();
        if (colmds != null && colmds.length > 0 && (columnName = colmds[0].getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return HBaseUtils.getTableName((AbstractClassMetaData)idmd.getParent());
    }

    public static String getQualifierName(IdentityMetaData idmd) {
        String columnName = null;
        ColumnMetaData[] colmds = idmd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = "IDENTITY";
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    public static String getFamilyName(DiscriminatorMetaData dismd) {
        String columnName = null;
        ColumnMetaData colmd = dismd.getColumnMetaData();
        if (colmd != null && (columnName = colmd.getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return HBaseUtils.getTableName((AbstractClassMetaData)dismd.getParent().getParent());
    }

    public static String getQualifierName(DiscriminatorMetaData dismd) {
        String columnName = null;
        ColumnMetaData colmd = dismd.getColumnMetaData();
        if (colmd != null) {
            columnName = colmd.getName();
        }
        if (columnName == null) {
            columnName = "DISCRIM";
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    public static String getFamilyName(VersionMetaData vermd) {
        String columnName = null;
        ColumnMetaData[] colmds = vermd.getColumnMetaData();
        if (colmds != null && colmds.length > 0 && (columnName = colmds[0].getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return HBaseUtils.getTableName((AbstractClassMetaData)vermd.getParent());
    }

    public static String getQualifierName(VersionMetaData vermd) {
        String columnName = null;
        ColumnMetaData[] colmds = vermd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = "VERSION";
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    public static String getFamilyName(AbstractClassMetaData acmd, int absoluteFieldNumber) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0 && (columnName = colmds[0].getName()) != null && columnName.indexOf(":") > -1) {
            return columnName.substring(0, columnName.indexOf(":"));
        }
        return HBaseUtils.getTableName(acmd);
    }

    public static String getQualifierName(AbstractClassMetaData acmd, int absoluteFieldNumber) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = ammd.getName();
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    static void createSchemaForClass(final HBaseStoreManager storeMgr, final AbstractClassMetaData acmd, final boolean validateOnly) {
        if (acmd.isEmbeddedOnly()) {
            return;
        }
        final Configuration config = storeMgr.getHbaseConfig();
        try {
            final HBaseAdmin hBaseAdmin = (HBaseAdmin)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new HBaseAdmin(config);
                }
            });
            final HTableDescriptor hTable = (HTableDescriptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTableDescriptor hTable;
                    block3: {
                        String tableName = HBaseUtils.getTableName(acmd);
                        hTable = null;
                        try {
                            hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
                        }
                        catch (TableNotFoundException ex) {
                            if (validateOnly) {
                                NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER.msg("HBase.SchemaValidate.Class", (Object)acmd.getFullClassName(), (Object)tableName));
                                hTable = null;
                            }
                            if (!storeMgr.isAutoCreateTables()) break block3;
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class", (Object)acmd.getFullClassName(), (Object)tableName));
                            hTable = new HTableDescriptor(tableName);
                            hBaseAdmin.createTable(hTable);
                        }
                    }
                    return hTable;
                }
            });
            if (hTable != null) {
                boolean modified = false;
                String tableName = HBaseUtils.getTableName(acmd);
                if (!hTable.hasFamily(tableName.getBytes())) {
                    if (validateOnly) {
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER.msg("HBase.SchemaValidate.Class.Family", (Object)tableName, (Object)tableName));
                    } else if (storeMgr.isAutoCreateColumns()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class.Family", (Object)tableName, (Object)tableName));
                        HColumnDescriptor hColumn = new HColumnDescriptor(tableName);
                        hTable.addFamily(hColumn);
                        modified = true;
                    }
                }
                int[] fieldNumbers = acmd.getAllMemberPositions();
                ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    AbstractMemberMetaData mmd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                    int relationType = mmd.getRelationType(clr);
                    if ((relationType == 1 || relationType == 2) && mmd.isEmbedded()) {
                        HBaseUtils.createSchemaForEmbeddedMember(storeMgr, hTable, mmd, clr, validateOnly);
                        continue;
                    }
                    String familyName = HBaseUtils.getFamilyName(acmd, fieldNumbers[i]);
                    if (hTable.hasFamily(familyName.getBytes())) continue;
                    if (validateOnly) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaValidate.Class.Family", (Object)tableName, (Object)familyName));
                        continue;
                    }
                    if (!storeMgr.isAutoCreateColumns()) continue;
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class.Family", (Object)tableName, (Object)familyName));
                    HColumnDescriptor hColumn = new HColumnDescriptor(familyName);
                    hTable.addFamily(hColumn);
                    modified = true;
                }
                if (modified) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            hBaseAdmin.disableTable(hTable.getName());
                            hBaseAdmin.modifyTable(hTable.getName(), hTable);
                            hBaseAdmin.enableTable(hTable.getName());
                            return null;
                        }
                    });
                }
            }
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
    }

    static boolean createSchemaForEmbeddedMember(HBaseStoreManager storeMgr, HTableDescriptor hTable, AbstractMemberMetaData mmd, ClassLoaderResolver clr, boolean validateOnly) {
        boolean modified = false;
        String tableName = hTable.getNameAsString();
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
        for (int j = 0; j < embmmds.length; ++j) {
            AbstractMemberMetaData embMmd = embmmds[j];
            int embRelationType = embMmd.getRelationType(clr);
            if ((embRelationType == 1 || embRelationType == 2) && embMmd.isEmbedded()) {
                return HBaseUtils.createSchemaForEmbeddedMember(storeMgr, hTable, embMmd, clr, validateOnly);
            }
            String familyName = HBaseUtils.getFamilyName(embMmd, j, tableName);
            if (hTable.hasFamily(familyName.getBytes())) continue;
            if (validateOnly) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaValidate.Class.Family", (Object)tableName, (Object)familyName));
                continue;
            }
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaCreate.Class.Family", (Object)tableName, (Object)familyName));
            HColumnDescriptor hColumn = new HColumnDescriptor(familyName);
            hTable.addFamily(hColumn);
            modified = true;
        }
        return modified;
    }

    static void deleteSchemaForClass(HBaseStoreManager storeMgr, final AbstractClassMetaData acmd) {
        if (acmd.isEmbeddedOnly()) {
            return;
        }
        final Configuration config = storeMgr.getHbaseConfig();
        try {
            final HBaseAdmin hBaseAdmin = (HBaseAdmin)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new HBaseAdmin(config);
                }
            });
            final HTableDescriptor hTable = (HTableDescriptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTableDescriptor hTable;
                    String tableName = HBaseUtils.getTableName(acmd);
                    try {
                        hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
                    }
                    catch (TableNotFoundException ex) {
                        hTable = new HTableDescriptor(tableName);
                        hBaseAdmin.createTable(hTable);
                    }
                    return hTable;
                }
            });
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("HBase.SchemaDelete.Class", (Object)acmd.getFullClassName(), (Object)hTable.getNameAsString()));
                    hBaseAdmin.disableTable(hTable.getName());
                    hBaseAdmin.deleteTable(hTable.getName());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
    }

    public static Object getVersionForObject(AbstractClassMetaData cmd, Result result) {
        if (cmd.hasVersionStrategy()) {
            if (cmd.getVersionMetaData().getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(cmd.getVersionMetaData().getFieldName());
                String familyName = HBaseUtils.getFamilyName(cmd, verMmd.getAbsoluteFieldNumber());
                String columnName = HBaseUtils.getQualifierName(cmd, verMmd.getAbsoluteFieldNumber());
                Object version = null;
                try {
                    byte[] bytes = result.getValue(familyName.getBytes(), columnName.getBytes());
                    ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    version = cmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.VERSION_NUMBER ? Long.valueOf(ois.readLong()) : ois.readObject();
                    ois.close();
                    bis.close();
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
                return version;
            }
            return HBaseUtils.getSurrogateVersionForObject(cmd, result);
        }
        return null;
    }

    public static Object getSurrogateVersionForObject(AbstractClassMetaData cmd, Result result) {
        String familyName = HBaseUtils.getFamilyName(cmd.getVersionMetaData());
        String columnName = HBaseUtils.getQualifierName(cmd.getVersionMetaData());
        Object version = null;
        try {
            byte[] bytes = result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            version = cmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.VERSION_NUMBER ? Long.valueOf(ois.readLong()) : ois.readObject();
            ois.close();
            bis.close();
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return version;
    }

    public static Object getDiscriminatorForObject(AbstractClassMetaData cmd, Result result) {
        String familyName = HBaseUtils.getFamilyName(cmd.getDiscriminatorMetaData());
        String columnName = HBaseUtils.getQualifierName(cmd.getDiscriminatorMetaData());
        Object discValue = null;
        try {
            byte[] bytes = result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            discValue = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return discValue;
    }

    public static Put getPutForObject(ObjectProvider sm) throws IOException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Object pkValue = null;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pkValue = ((OID)sm.getInternalObjectId()).getKeyValue();
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Put batch = new Put(bos.toByteArray());
        oos.close();
        bos.close();
        return batch;
    }

    public static Delete getDeleteForObject(ObjectProvider sm) throws IOException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Object pkValue = null;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pkValue = ((OID)sm.getInternalObjectId()).getKeyValue();
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Delete batch = new Delete(bos.toByteArray());
        oos.close();
        bos.close();
        return batch;
    }

    public static Result getResultForObject(ObjectProvider sm, HTable table) throws IOException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Object pkValue = null;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pkValue = ((OID)sm.getInternalObjectId()).getKeyValue();
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Get get = new Get(bos.toByteArray());
        Result result = table.get(get);
        oos.close();
        bos.close();
        return result;
    }

    public static boolean objectExistsInTable(ObjectProvider sm, HTable table) throws IOException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Object pkValue = null;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pkValue = ((OID)sm.getInternalObjectId()).getKeyValue();
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Get get = new Get(bos.toByteArray());
        boolean result = table.exists(get);
        oos.close();
        bos.close();
        return result;
    }
}

