/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchFieldManager;
import org.datanucleus.store.hbase.fieldmanager.StoreFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class HBasePersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());
    protected final HBaseStoreManager storeMgr;

    public HBasePersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (HBaseStoreManager)storeMgr;
    }

    public void close() {
    }

    public void insertObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        if (!this.storeMgr.managesClass(sm.getClassMetaData().getFullClassName())) {
            this.storeMgr.addClass(sm.getClassMetaData().getFullClassName(), sm.getExecutionContext().getClassLoaderResolver());
        }
        AbstractClassMetaData cmd = sm.getClassMetaData();
        boolean enforceUniquenessInApp = this.storeMgr.getBooleanProperty("datanucleus.hbase.enforceUniquenessInApplication", false);
        if (enforceUniquenessInApp) {
            NucleusLogger.DATASTORE_PERSIST.info((Object)"User requesting to enforce uniqueness of object identity in their application, so not checking for existence");
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            try {
                this.locateObject(sm);
                throw new NucleusUserException(LOCALISER.msg("HBase.Insert.ObjectWithIdAlreadyExists", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            catch (NucleusObjectNotFoundException onfe) {
                // empty catch block
            }
        }
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
        try {
            ObjectOutputStream oos;
            ByteArrayOutputStream bos;
            String columnName;
            String familyName;
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.Insert.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            HTable table = mconn.getHTable(HBaseUtils.getTableName(cmd));
            Put put = HBaseUtils.getPutForObject(sm);
            Delete delete = HBaseUtils.getDeleteForObject(sm);
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                familyName = HBaseUtils.getFamilyName(cmd.getIdentityMetaData());
                columnName = HBaseUtils.getQualifierName(cmd.getIdentityMetaData());
                Object key = ((OID)sm.getInternalObjectId()).getKeyValue();
                try {
                    ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
                    ObjectOutputStream oos2 = new ObjectOutputStream(bos2);
                    oos2.writeObject(key);
                    oos2.flush();
                    put.add(familyName.getBytes(), columnName.getBytes(), bos2.toByteArray());
                    oos2.close();
                    bos2.close();
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            if (cmd.hasDiscriminatorStrategy()) {
                DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
                String discVal = null;
                discVal = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
                String familyName2 = HBaseUtils.getFamilyName(discmd);
                String columnName2 = HBaseUtils.getQualifierName(discmd);
                try {
                    bos = new ByteArrayOutputStream();
                    oos = new ObjectOutputStream(bos);
                    oos.writeObject(discVal);
                    oos.flush();
                    put.add(familyName2.getBytes(), columnName2.getBytes(), bos.toByteArray());
                    oos.close();
                    bos.close();
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            if (cmd.hasVersionStrategy()) {
                AbstractMemberMetaData verMmd;
                familyName = HBaseUtils.getFamilyName(cmd.getVersionMetaData());
                columnName = HBaseUtils.getQualifierName(cmd.getVersionMetaData());
                if (cmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                    long versionNumber = 1L;
                    sm.setTransactionalVersion((Object)versionNumber);
                    if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("HBase.Insert.ObjectPersistedWithVersion", (Object)sm.toPrintableID(), sm.getInternalObjectId(), (Object)("" + versionNumber)));
                    }
                    if (cmd.getVersionMetaData().getFieldName() != null) {
                        verMmd = cmd.getMetaDataForMember(cmd.getVersionMetaData().getFieldName());
                        Number verFieldValue = versionNumber;
                        if (verMmd.getType() == Integer.TYPE || verMmd.getType() == Integer.class) {
                            verFieldValue = (int)versionNumber;
                        }
                        sm.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)verFieldValue);
                    } else {
                        try {
                            bos = new ByteArrayOutputStream();
                            oos = new ObjectOutputStream(bos);
                            oos.writeLong(versionNumber);
                            oos.flush();
                            put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                            oos.close();
                            bos.close();
                        }
                        catch (IOException e) {
                            throw new NucleusException(e.getMessage(), (Throwable)e);
                        }
                    }
                } else if (cmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.DATE_TIME) {
                    Date date = new Date();
                    Timestamp ts = new Timestamp(date.getTime());
                    sm.setTransactionalVersion((Object)ts);
                    if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("HBase.Insert.ObjectPersistedWithVersion", (Object)sm.toPrintableID(), sm.getInternalObjectId(), (Object)("" + ts)));
                    }
                    if (cmd.getVersionMetaData().getFieldName() != null) {
                        verMmd = cmd.getMetaDataForMember(cmd.getVersionMetaData().getFieldName());
                        sm.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)ts);
                    } else {
                        try {
                            bos = new ByteArrayOutputStream();
                            oos = new ObjectOutputStream(bos);
                            oos.writeObject(ts);
                            put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                            oos.close();
                            bos.close();
                        }
                        catch (IOException e) {
                            throw new NucleusException(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            StoreFieldManager fm = new StoreFieldManager(sm, put, delete);
            sm.provideFields(cmd.getAllMemberPositions(), (FieldManager)fm);
            table.put(put);
            table.close();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementInsertCount();
            }
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(ObjectProvider sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
        try {
            long startTime = System.currentTimeMillis();
            AbstractClassMetaData cmd = sm.getClassMetaData();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.Update.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            HTable table = mconn.getHTable(HBaseUtils.getTableName(cmd));
            if (cmd.hasVersionStrategy()) {
                Object currentVersion = sm.getTransactionalVersion();
                Result result = HBaseUtils.getResultForObject(sm, table);
                Object datastoreVersion = HBaseUtils.getVersionForObject(cmd, result);
                if (!datastoreVersion.equals(currentVersion)) {
                    throw new NucleusOptimisticException("Cannot update object with id " + sm.getObjectId() + " since has version=" + currentVersion + " while datastore has version=" + datastoreVersion);
                }
            }
            Put put = HBaseUtils.getPutForObject(sm);
            Delete delete = HBaseUtils.getDeleteForObject(sm);
            if (cmd.hasVersionStrategy()) {
                Object currentVersion = sm.getTransactionalVersion();
                VersionMetaData vermd = cmd.getVersionMetaData();
                Object nextVersion = vermd.getNextVersion(currentVersion);
                sm.setTransactionalVersion(nextVersion);
                if (cmd.getVersionMetaData().getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(cmd.getVersionMetaData().getFieldName());
                    sm.replaceField(verMmd.getAbsoluteFieldNumber(), nextVersion);
                } else {
                    String familyName = HBaseUtils.getFamilyName(vermd);
                    String columnName = HBaseUtils.getQualifierName(vermd);
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(bos);
                        if (nextVersion instanceof Long) {
                            oos.writeLong((Long)nextVersion);
                        } else if (nextVersion instanceof Integer) {
                            oos.writeInt((Integer)nextVersion);
                        } else {
                            oos.writeObject(nextVersion);
                        }
                        oos.flush();
                        put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                        oos.close();
                        bos.close();
                    }
                    catch (IOException ioe) {
                        throw new NucleusException(ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
            StoreFieldManager fm = new StoreFieldManager(sm, put, delete);
            sm.provideFields(fieldNumbers, (FieldManager)fm);
            if (!put.isEmpty()) {
                table.put(put);
            }
            if (!delete.isEmpty()) {
                table.delete(delete);
            }
            table.close();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
        try {
            AbstractClassMetaData cmd = sm.getClassMetaData();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.Delete.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            HTable table = mconn.getHTable(HBaseUtils.getTableName(cmd));
            if (cmd.hasVersionStrategy()) {
                Object currentVersion = sm.getTransactionalVersion();
                Result result = HBaseUtils.getResultForObject(sm, table);
                Object datastoreVersion = HBaseUtils.getVersionForObject(cmd, result);
                if (!datastoreVersion.equals(currentVersion)) {
                    throw new NucleusOptimisticException("Cannot delete object with id " + sm.getObjectId() + " since has version=" + currentVersion + " while datastore has version=" + datastoreVersion);
                }
            }
            sm.loadUnloadedFields();
            sm.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(sm));
            table.delete(HBaseUtils.getDeleteForObject(sm));
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementDeleteCount();
            }
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(ObjectProvider sm, int[] fieldNumbers) {
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
        try {
            HTable table;
            Result result;
            AbstractClassMetaData cmd = sm.getClassMetaData();
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                StringBuffer str = new StringBuffer("Fetching object \"");
                str.append(sm.toPrintableID()).append("\" (id=");
                str.append(sm.getExecutionContext().getApiAdapter().getObjectId(sm)).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.PERSISTENCE.debug((Object)str);
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("HBase.Fetch.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            if ((result = HBaseUtils.getResultForObject(sm, table = mconn.getHTable(HBaseUtils.getTableName(cmd)))).getRow() == null) {
                throw new NucleusObjectNotFoundException();
            }
            if (cmd.hasDiscriminatorStrategy()) {
                Object discValue = HBaseUtils.getDiscriminatorForObject(cmd, result);
                if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? !cmd.getFullClassName().equals(discValue) : cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP && !cmd.getDiscriminatorValue().equals(discValue)) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            FetchFieldManager fm = new FetchFieldManager(sm, result);
            sm.replaceFields(cmd.getAllMemberPositions(), (FieldManager)fm);
            if (cmd.hasVersionStrategy() && sm.getTransactionalVersion() == null) {
                if (cmd.getVersionMetaData().getFieldName() != null) {
                    Object datastoreVersion = sm.provideField(cmd.getAbsolutePositionOfMember(cmd.getVersionMetaData().getFieldName()));
                    sm.setVersion(datastoreVersion);
                } else {
                    sm.setVersion(HBaseUtils.getSurrogateVersionForObject(cmd, result));
                }
            }
            table.close();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementFetchCount();
            }
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext ectx, Object id) {
        return null;
    }

    public void locateObject(ObjectProvider sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
            try {
                AbstractClassMetaData acmd = sm.getClassMetaData();
                HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
                if (!HBaseUtils.objectExistsInTable(sm, table)) {
                    throw new NucleusObjectNotFoundException();
                }
                table.close();
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }
}

