/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.query;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues2;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchFieldManager;

class HBaseQueryUtils {
    HBaseQueryUtils() {
    }

    static List getObjectsOfCandidateType(final ExecutionContext ec, final HBaseManagedConnection mconn, Class candidateClass, boolean subclasses, boolean ignoreCache, FetchPlan fetchPlan) {
        ArrayList<Object> results;
        block8: {
            results = new ArrayList<Object>();
            try {
                final ClassLoaderResolver clr = ec.getClassLoaderResolver();
                final AbstractClassMetaData acmd = ec.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
                Iterator it = (Iterator)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        byte[] columnName;
                        HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
                        int[] fieldNumbers = acmd.getAllMemberPositions();
                        Scan scan = new Scan();
                        for (int i = 0; i < fieldNumbers.length; ++i) {
                            AbstractMemberMetaData mmd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                            int relationType = mmd.getRelationType(clr);
                            if ((relationType == 1 || relationType == 2) && mmd.isEmbedded()) {
                                HBaseQueryUtils.addColumnsToScanForEmbeddedMember(scan, mmd, HBaseUtils.getTableName(acmd), ec);
                                continue;
                            }
                            byte[] familyName = HBaseUtils.getFamilyName(acmd, fieldNumbers[i]).getBytes();
                            byte[] columnName2 = HBaseUtils.getQualifierName(acmd, fieldNumbers[i]).getBytes();
                            scan.addColumn(familyName, columnName2);
                        }
                        if (acmd.hasVersionStrategy() && acmd.getVersionMetaData().getFieldName() == null) {
                            byte[] familyName = HBaseUtils.getFamilyName(acmd.getVersionMetaData()).getBytes();
                            columnName = HBaseUtils.getQualifierName(acmd.getVersionMetaData()).getBytes();
                            scan.addColumn(familyName, columnName);
                        }
                        if (acmd.getIdentityType() == IdentityType.DATASTORE) {
                            byte[] familyName = HBaseUtils.getFamilyName(acmd.getIdentityMetaData()).getBytes();
                            columnName = HBaseUtils.getQualifierName(acmd.getIdentityMetaData()).getBytes();
                            scan.addColumn(familyName, columnName);
                        }
                        ResultScanner scanner = table.getScanner(scan);
                        Iterator it = scanner.iterator();
                        return it;
                    }
                });
                if (acmd.getIdentityType() == IdentityType.APPLICATION) {
                    while (it.hasNext()) {
                        final Result result = (Result)it.next();
                        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)acmd, null, (boolean)false, (FieldManager)new FetchFieldManager(ec, acmd, result));
                        results.add(ec.findObject(id, new FieldValues2(){

                            public void fetchFields(ObjectProvider sm) {
                                sm.replaceFields(acmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(ec, acmd, result));
                            }

                            public void fetchNonLoadedFields(ObjectProvider sm) {
                                sm.replaceNonLoadedFields(acmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(ec, acmd, result));
                            }

                            public FetchPlan getFetchPlanForLoading() {
                                return null;
                            }
                        }, null, ignoreCache));
                    }
                    break block8;
                }
                if (acmd.getIdentityType() != IdentityType.DATASTORE) break block8;
                String dsidFamilyName = HBaseUtils.getFamilyName(acmd.getIdentityMetaData());
                String dsidColumnName = HBaseUtils.getQualifierName(acmd.getIdentityMetaData());
                while (it.hasNext()) {
                    final Result result = (Result)it.next();
                    OID id = null;
                    try {
                        byte[] bytes = result.getValue(dsidFamilyName.getBytes(), dsidColumnName.getBytes());
                        if (bytes == null) {
                            throw new NucleusException("Retrieved identity for family=" + dsidFamilyName + " column=" + dsidColumnName + " IS NULL");
                        }
                        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                        ObjectInputStream ois = new ObjectInputStream(bis);
                        Object key = ois.readObject();
                        id = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)acmd.getFullClassName(), (Object)key);
                        ois.close();
                        bis.close();
                    }
                    catch (Exception e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                    results.add(ec.findObject((Object)id, new FieldValues2(){

                        public void fetchFields(ObjectProvider sm) {
                            sm.replaceFields(acmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(ec, acmd, result));
                        }

                        public void fetchNonLoadedFields(ObjectProvider sm) {
                            sm.replaceNonLoadedFields(acmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(ec, acmd, result));
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, null, ignoreCache));
                }
            }
            catch (PrivilegedActionException e) {
                throw new NucleusDataStoreException(e.getMessage(), e.getCause());
            }
        }
        return results;
    }

    private static void addColumnsToScanForEmbeddedMember(Scan scan, AbstractMemberMetaData mmd, String tableName, ExecutionContext ec) {
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
        for (int i = 0; i < embmmds.length; ++i) {
            AbstractMemberMetaData embMmd = embmmds[i];
            int relationType = embMmd.getRelationType(clr);
            if ((relationType == 2 || relationType == 1) && embMmd.isEmbedded()) {
                HBaseQueryUtils.addColumnsToScanForEmbeddedMember(scan, embMmd, tableName, ec);
                continue;
            }
            byte[] familyName = HBaseUtils.getFamilyName(mmd, i, tableName).getBytes();
            byte[] columnName = HBaseUtils.getQualifierName(mmd, i).getBytes();
            scan.addColumn(familyName, columnName);
        }
    }
}

