/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchFieldManager;
import org.datanucleus.store.hbase.fieldmanager.StoreFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class HBasePersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());
    protected final HBaseStoreManager storeMgr;

    public HBasePersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (HBaseStoreManager)storeMgr;
    }

    public void close() {
    }

    public void insertObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        if (!this.storeMgr.managesClass(sm.getClassMetaData().getFullClassName())) {
            this.storeMgr.addClass(sm.getClassMetaData().getFullClassName(), sm.getExecutionContext().getClassLoaderResolver());
        }
        AbstractClassMetaData cmd = sm.getClassMetaData();
        boolean enforceUniquenessInApp = this.storeMgr.getBooleanProperty("datanucleus.hbase.enforceUniquenessInApplication", false);
        if (enforceUniquenessInApp) {
            NucleusLogger.DATASTORE_PERSIST.info((Object)"User requesting to enforce uniqueness of object identity in their application, so not checking for existence");
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            try {
                this.locateObject(sm);
                throw new NucleusUserException(LOCALISER.msg("HBase.Insert.ObjectWithIdAlreadyExists", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            catch (NucleusObjectNotFoundException onfe) {
                // empty catch block
            }
        }
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
        try {
            String columnName;
            String familyName;
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.Insert.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            HTable table = mconn.getHTable(HBaseUtils.getTableName(cmd));
            Put put = this.newPut(sm);
            Delete delete = this.newDelete(sm);
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                familyName = HBaseUtils.getFamilyName(cmd.getIdentityMetaData());
                columnName = HBaseUtils.getQualifierName(cmd.getIdentityMetaData());
                Object key = ((OID)sm.getInternalObjectId()).getKeyValue();
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(key);
                    oos.flush();
                    put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                    oos.close();
                    bos.close();
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            if (cmd.hasVersionStrategy()) {
                ByteArrayOutputStream bos;
                AbstractMemberMetaData verMmd;
                familyName = HBaseUtils.getFamilyName(cmd.getVersionMetaData());
                columnName = HBaseUtils.getQualifierName(cmd.getVersionMetaData());
                if (cmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                    long versionNumber = 1L;
                    sm.setTransactionalVersion((Object)versionNumber);
                    if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("HBase.Insert.ObjectPersistedWithVersion", (Object)sm.toPrintableID(), sm.getInternalObjectId(), (Object)("" + versionNumber)));
                    }
                    if (cmd.getVersionMetaData().getFieldName() != null) {
                        verMmd = cmd.getMetaDataForMember(cmd.getVersionMetaData().getFieldName());
                        Number verFieldValue = versionNumber;
                        if (verMmd.getType() == Integer.TYPE || verMmd.getType() == Integer.class) {
                            verFieldValue = (int)versionNumber;
                        }
                        sm.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)verFieldValue);
                    } else {
                        try {
                            bos = new ByteArrayOutputStream();
                            ObjectOutputStream oos = new ObjectOutputStream(bos);
                            oos.writeLong(versionNumber);
                            oos.flush();
                            put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                            oos.close();
                            bos.close();
                        }
                        catch (IOException e) {
                            throw new NucleusException(e.getMessage(), (Throwable)e);
                        }
                    }
                } else if (cmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.DATE_TIME) {
                    Date date = new Date();
                    Timestamp ts = new Timestamp(date.getTime());
                    sm.setTransactionalVersion((Object)ts);
                    if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("HBase.Insert.ObjectPersistedWithVersion", (Object)sm.toPrintableID(), sm.getInternalObjectId(), (Object)("" + ts)));
                    }
                    if (cmd.getVersionMetaData().getFieldName() != null) {
                        verMmd = cmd.getMetaDataForMember(cmd.getVersionMetaData().getFieldName());
                        sm.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)ts);
                    } else {
                        try {
                            bos = new ByteArrayOutputStream();
                            ObjectOutputStream oos = new ObjectOutputStream(bos);
                            oos.writeObject(ts);
                            put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                            oos.close();
                            bos.close();
                        }
                        catch (IOException e) {
                            throw new NucleusException(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            StoreFieldManager fm = new StoreFieldManager(sm, put, delete);
            sm.provideFields(cmd.getAllMemberPositions(), (FieldManager)fm);
            table.put(put);
            table.close();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementInsertCount();
            }
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(ObjectProvider sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
        try {
            long startTime = System.currentTimeMillis();
            AbstractClassMetaData acmd = sm.getClassMetaData();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.Update.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
            Put put = this.newPut(sm);
            Delete delete = this.newDelete(sm);
            StoreFieldManager fm = new StoreFieldManager(sm, put, delete);
            sm.provideFields(fieldNumbers, (FieldManager)fm);
            if (acmd.hasVersionStrategy()) {
                Object currentVersion = sm.getTransactionalVersion();
                Object nextVersion = null;
                VersionMetaData vermd = acmd.getVersionMetaData();
                if (acmd.getVersionMetaData().getFieldName() != null) {
                    AbstractMemberMetaData verfmd = acmd.getMetaDataForMember(vermd.getFieldName());
                    if (currentVersion instanceof Integer) {
                        currentVersion = ((Integer)currentVersion).longValue();
                    }
                    nextVersion = acmd.getVersionMetaData().getNextVersion(currentVersion);
                    if (verfmd.getType() == Integer.class || verfmd.getType() == Integer.TYPE) {
                        nextVersion = ((Long)nextVersion).intValue();
                    }
                } else {
                    nextVersion = vermd.getNextVersion(currentVersion);
                }
                String familyName = HBaseUtils.getFamilyName(acmd.getVersionMetaData());
                String columnName = HBaseUtils.getQualifierName(acmd.getVersionMetaData());
                if (acmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(bos);
                        oos.writeLong((Long)nextVersion);
                        oos.flush();
                        put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                        oos.close();
                        bos.close();
                    }
                    catch (IOException e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                }
                if (acmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.DATE_TIME) {
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(bos);
                        oos.writeObject(nextVersion);
                        put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                        oos.close();
                        bos.close();
                    }
                    catch (IOException e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (!put.isEmpty()) {
                table.put(put);
            }
            if (!delete.isEmpty()) {
                table.delete(delete);
            }
            table.close();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
        try {
            AbstractClassMetaData acmd = sm.getClassMetaData();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.Delete.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
            table.delete(this.newDelete(sm));
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementDeleteCount();
            }
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(ObjectProvider sm, int[] fieldNumbers) {
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
        try {
            HTable table;
            Result result;
            AbstractClassMetaData acmd = sm.getClassMetaData();
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                StringBuffer str = new StringBuffer("Fetching object \"");
                str.append(sm.toPrintableID()).append("\" (id=");
                str.append(sm.getExecutionContext().getApiAdapter().getObjectId(sm)).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.PERSISTENCE.debug((Object)str);
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("HBase.Fetch.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            if ((result = this.getResult(sm, table = mconn.getHTable(HBaseUtils.getTableName(acmd)))).getRow() == null) {
                throw new NucleusObjectNotFoundException();
            }
            FetchFieldManager fm = new FetchFieldManager(sm, result);
            sm.replaceFields(acmd.getAllMemberPositions(), (FieldManager)fm);
            if (acmd.hasVersionStrategy() && sm.getTransactionalVersion() == null) {
                if (acmd.getVersionMetaData().getFieldName() != null) {
                    Object datastoreVersion = sm.provideField(acmd.getAbsolutePositionOfMember(acmd.getVersionMetaData().getFieldName()));
                    sm.setVersion(datastoreVersion);
                } else {
                    String familyName = HBaseUtils.getFamilyName(acmd.getVersionMetaData());
                    String columnName = HBaseUtils.getQualifierName(acmd.getVersionMetaData());
                    try {
                        byte[] bytes = result.getValue(familyName.getBytes(), columnName.getBytes());
                        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                        ObjectInputStream ois = new ObjectInputStream(bis);
                        if (acmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                            sm.setVersion((Object)ois.readLong());
                        } else {
                            sm.setVersion(ois.readObject());
                        }
                        ois.close();
                        bis.close();
                    }
                    catch (Exception e) {
                        throw new NucleusException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            table.close();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("HBase.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementFetchCount();
            }
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext ectx, Object id) {
        return null;
    }

    public void locateObject(ObjectProvider sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
            try {
                AbstractClassMetaData acmd = sm.getClassMetaData();
                HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
                if (!this.exists(sm, table)) {
                    throw new NucleusObjectNotFoundException();
                }
                table.close();
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    private Put newPut(ObjectProvider sm) throws IOException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Object pkValue = null;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pkValue = ((OID)sm.getInternalObjectId()).getKeyValue();
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Put batch = new Put(bos.toByteArray());
        oos.close();
        bos.close();
        return batch;
    }

    private Delete newDelete(ObjectProvider sm) throws IOException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Object pkValue = null;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pkValue = ((OID)sm.getInternalObjectId()).getKeyValue();
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Delete batch = new Delete(bos.toByteArray());
        oos.close();
        bos.close();
        return batch;
    }

    private Result getResult(ObjectProvider sm, HTable table) throws IOException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Object pkValue = null;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pkValue = ((OID)sm.getInternalObjectId()).getKeyValue();
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Get get = new Get(bos.toByteArray());
        Result result = table.get(get);
        oos.close();
        bos.close();
        return result;
    }

    private boolean exists(ObjectProvider sm, HTable table) throws IOException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Object pkValue = null;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pkValue = ((OID)sm.getInternalObjectId()).getKeyValue();
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Get get = new Get(bos.toByteArray());
        boolean result = table.exists(get);
        oos.close();
        bos.close();
        return result;
    }
}

