/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;

public class HBaseUtils {
    public static String getTableName(AbstractClassMetaData acmd) {
        if (acmd.getTable() != null) {
            return acmd.getTable();
        }
        return acmd.getName();
    }

    public static String getFamilyName(AbstractClassMetaData acmd, int absoluteFieldNumber) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = HBaseUtils.getTableName(acmd);
        } else if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(0, columnName.indexOf(":"));
        }
        return columnName;
    }

    public static String getQualifierName(AbstractClassMetaData acmd, int absoluteFieldNumber) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = ammd.getName();
        }
        if (columnName.indexOf(":") > -1) {
            columnName = columnName.substring(columnName.indexOf(":") + 1);
        }
        return columnName;
    }

    static void createSchema(final HBaseConfiguration config, final AbstractClassMetaData acmd, boolean autoCreateColumns) {
        try {
            final HBaseAdmin hBaseAdmin = (HBaseAdmin)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new HBaseAdmin(config);
                }
            });
            final HTableDescriptor hTable = (HTableDescriptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTableDescriptor hTable;
                    String tableName = HBaseUtils.getTableName(acmd);
                    try {
                        hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
                    }
                    catch (TableNotFoundException ex) {
                        hTable = new HTableDescriptor(tableName);
                        hBaseAdmin.createTable(hTable);
                    }
                    return hTable;
                }
            });
            if (autoCreateColumns) {
                boolean modified = false;
                if (!hTable.hasFamily(HBaseUtils.getTableName(acmd).getBytes())) {
                    HColumnDescriptor hColumn = new HColumnDescriptor(HBaseUtils.getTableName(acmd));
                    hTable.addFamily(hColumn);
                    modified = true;
                }
                int[] fieldNumbers = acmd.getAllMemberPositions();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    String familyName = HBaseUtils.getFamilyName(acmd, fieldNumbers[i]);
                    if (hTable.hasFamily(familyName.getBytes())) continue;
                    HColumnDescriptor hColumn = new HColumnDescriptor(familyName);
                    hTable.addFamily(hColumn);
                    modified = true;
                }
                if (modified) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            hBaseAdmin.disableTable(hTable.getName());
                            hBaseAdmin.modifyTable(hTable.getName(), hTable);
                            hBaseAdmin.enableTable(hTable.getName());
                            return null;
                        }
                    });
                }
            }
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
    }
}

