/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.AbstractPersistenceHandler2;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseFetchFieldManager;
import org.datanucleus.store.hbase.HBaseInsertFieldManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.util.Localiser;

public class HBasePersistenceHandler
extends AbstractPersistenceHandler2 {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());
    protected final HBaseStoreManager storeMgr;

    HBasePersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (HBaseStoreManager)storeMgr;
    }

    public void close() {
    }

    public void deleteObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
        try {
            AbstractClassMetaData acmd = sm.getClassMetaData();
            HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
            table.delete(this.newDelete(sm));
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(ObjectProvider sm, int[] fieldNumbers) {
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
        try {
            AbstractClassMetaData acmd = sm.getClassMetaData();
            HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
            Result result = this.getResult(sm, table);
            if (result.getRow() == null) {
                throw new NucleusObjectNotFoundException();
            }
            HBaseFetchFieldManager fm = new HBaseFetchFieldManager(acmd, result);
            sm.replaceFields(acmd.getAllMemberPositions(), (FieldManager)fm);
            table.close();
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext ectx, Object id) {
        return null;
    }

    public void insertObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        if (!this.storeMgr.managesClass(sm.getClassMetaData().getFullClassName())) {
            this.storeMgr.addClass(sm.getClassMetaData().getFullClassName(), sm.getExecutionContext().getClassLoaderResolver());
        }
        try {
            this.locateObject(sm);
            throw new NucleusUserException(LOCALISER.msg("HBase.Insert.ObjectWithIdAlreadyExists"));
        }
        catch (NucleusObjectNotFoundException onfe) {
            HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
            try {
                AbstractClassMetaData acmd = sm.getClassMetaData();
                HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
                Put put = this.newPut(sm);
                Delete delete = this.newDelete(sm);
                HBaseInsertFieldManager fm = new HBaseInsertFieldManager(acmd, put, delete);
                sm.provideFields(acmd.getAllMemberPositions(), (FieldManager)fm);
                table.put(put);
                table.close();
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
            return;
        }
    }

    private Put newPut(ObjectProvider sm) throws IOException {
        Object pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Put batch = new Put(bos.toByteArray());
        oos.close();
        bos.close();
        return batch;
    }

    private Delete newDelete(ObjectProvider sm) throws IOException {
        Object pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Delete batch = new Delete(bos.toByteArray());
        oos.close();
        bos.close();
        return batch;
    }

    private Result getResult(ObjectProvider sm, HTable table) throws IOException {
        Object pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Get get = new Get(bos.toByteArray());
        Result result = table.get(get);
        oos.close();
        bos.close();
        return result;
    }

    private boolean exists(ObjectProvider sm, HTable table) throws IOException {
        Object pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Get get = new Get(bos.toByteArray());
        boolean result = table.exists(get);
        oos.close();
        bos.close();
        return result;
    }

    public void locateObject(ObjectProvider sm) {
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
        try {
            AbstractClassMetaData acmd = sm.getClassMetaData();
            HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
            if (!this.exists(sm, table)) {
                throw new NucleusObjectNotFoundException();
            }
            table.close();
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(ObjectProvider sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getExecutionContext());
        try {
            AbstractClassMetaData acmd = sm.getClassMetaData();
            HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
            Put put = this.newPut(sm);
            Delete delete = this.newDelete(sm);
            HBaseInsertFieldManager fm = new HBaseInsertFieldManager(acmd, put, delete);
            sm.provideFields(fieldNumbers, (FieldManager)fm);
            if (!put.isEmpty()) {
                table.put(put);
            }
            if (!put.isEmpty()) {
                table.delete(delete);
            }
            table.close();
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }
}

