/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.hbase.HBaseUtils;

public class HBaseInsertFieldManager
extends AbstractFieldManager {
    Put put;
    Delete delete;
    StateManager sm;

    public HBaseInsertFieldManager(StateManager sm, Put put, Delete delete) {
        this.sm = sm;
        this.put = put;
        this.delete = delete;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeBoolean(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        this.put.add(familyName.getBytes(), columnName.getBytes(), new byte[]{value});
    }

    public void storeCharField(int fieldNumber, char value) {
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeChar(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeDouble(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeFloat(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeInt(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeLong(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        if (value == null) {
            this.delete.deleteColumn(familyName.getBytes(), columnName.getBytes());
        } else {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeShort(value);
            oos.flush();
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        if (value == null) {
            this.delete.deleteColumn(familyName.getBytes(), columnName.getBytes());
        } else {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

