/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping;

import java.awt.geom.CubicCurve2D;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class CubicCurve2dDoubleMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        super.initialize(fmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
    }

    public Class getJavaType() {
        return CubicCurve2D.Double.class;
    }

    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        CubicCurve2D.Double cc = (CubicCurve2D.Double)value;
        if (index == 0) {
            return cc.getX1();
        }
        if (index == 1) {
            return cc.getY1();
        }
        if (index == 2) {
            return cc.getCtrlX1();
        }
        if (index == 3) {
            return cc.getCtrlY1();
        }
        if (index == 4) {
            return cc.getCtrlX2();
        }
        if (index == 5) {
            return cc.getCtrlY2();
        }
        if (index == 6) {
            return cc.getX2();
        }
        if (index == 7) {
            return cc.getY2();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        CubicCurve2D.Double cubicCurve = (CubicCurve2D.Double)value;
        if (cubicCurve == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getColumnMapping(i).setObject(ps, exprIndex[i], null);
            }
        } else {
            this.getColumnMapping(0).setDouble(ps, exprIndex[0], cubicCurve.getX1());
            this.getColumnMapping(1).setDouble(ps, exprIndex[1], cubicCurve.getY1());
            this.getColumnMapping(2).setDouble(ps, exprIndex[2], cubicCurve.getCtrlX1());
            this.getColumnMapping(3).setDouble(ps, exprIndex[3], cubicCurve.getCtrlY1());
            this.getColumnMapping(4).setDouble(ps, exprIndex[4], cubicCurve.getCtrlX2());
            this.getColumnMapping(5).setDouble(ps, exprIndex[5], cubicCurve.getCtrlY2());
            this.getColumnMapping(6).setDouble(ps, exprIndex[6], cubicCurve.getX2());
            this.getColumnMapping(7).setDouble(ps, exprIndex[7], cubicCurve.getY2());
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.getColumnMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        double x1 = this.getColumnMapping(0).getDouble(resultSet, exprIndex[0]);
        double y1 = this.getColumnMapping(1).getDouble(resultSet, exprIndex[1]);
        double ctrlx1 = this.getColumnMapping(2).getDouble(resultSet, exprIndex[2]);
        double ctrly1 = this.getColumnMapping(3).getDouble(resultSet, exprIndex[3]);
        double ctrlx2 = this.getColumnMapping(4).getDouble(resultSet, exprIndex[4]);
        double ctrly2 = this.getColumnMapping(5).getDouble(resultSet, exprIndex[5]);
        double x2 = this.getColumnMapping(6).getDouble(resultSet, exprIndex[6]);
        double y2 = this.getColumnMapping(7).getDouble(resultSet, exprIndex[7]);
        return new CubicCurve2D.Double(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
    }
}

