/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.wrappers;

import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.datanucleus.FetchPlanState;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.types.SCO;

public class Arc2dFloat
extends Arc2D.Float
implements SCO<Arc2D.Float> {
    private static final long serialVersionUID = 5319768140588872943L;
    protected transient DNStateManager ownerOP;
    protected transient String fieldName;

    public Arc2dFloat(DNStateManager ownerSM, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerSM;
        this.fieldName = mmd.getName();
    }

    public void initialise(Arc2D.Float newValue, Object oldValue) {
        super.setArc(newValue);
    }

    public void initialise(Arc2D.Float value) {
        super.setArc(value);
    }

    public void initialise() {
    }

    public Arc2D.Float getValue() {
        return new Arc2D.Float((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), (float)this.getAngleStart(), (float)this.getAngleExtent(), this.getArcType());
    }

    public void unsetOwner() {
        this.ownerOP = null;
    }

    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.getExecutionContext().getApiAdapter().makeDirty(this.ownerOP.getObject(), this.fieldName);
        }
    }

    public Arc2D.Float detachCopy(FetchPlanState state) {
        return new Arc2D.Float((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), (float)this.getAngleStart(), (float)this.getAngleExtent(), this.getArcType());
    }

    public void attachCopy(Arc2D.Float value) {
        double oldX = this.getX();
        double oldY = this.getY();
        double oldW = this.getWidth();
        double oldH = this.getHeight();
        double oldS = this.getAngleStart();
        double oldE = this.getAngleExtent();
        double oldT = this.getArcType();
        this.initialise(value, null);
        Arc2dFloat rect = (Arc2dFloat)value;
        double newX = rect.getX();
        double newY = rect.getY();
        double newW = rect.getWidth();
        double newH = rect.getHeight();
        double newS = rect.getAngleStart();
        double newE = rect.getAngleExtent();
        double newT = rect.getArcType();
        if (oldX != newX || oldY != newY || oldW != newW || oldH != newH || oldS != newS || oldE != newE || oldT != newT) {
            this.makeDirty();
        }
    }

    @Override
    public Object clone() {
        Object obj = super.clone();
        ((Arc2dFloat)obj).unsetOwner();
        return obj;
    }

    @Override
    public void setArc(double x, double y, double w, double h, double angSt, double angExt, int closure) {
        super.setArc(x, y, w, h, angSt, angExt, closure);
        this.makeDirty();
    }

    @Override
    public void setAngleStart(double angSt) {
        super.setAngleStart(angSt);
        this.makeDirty();
    }

    @Override
    public void setAngleExtent(double angExt) {
        super.setAngleExtent(angExt);
        this.makeDirty();
    }

    @Override
    public void setArc(Point2D loc, Dimension2D size, double angSt, double angExt, int closure) {
        super.setArc(loc, size, angSt, angExt, closure);
        this.makeDirty();
    }

    @Override
    public void setArc(Rectangle2D rect, double angSt, double angExt, int closure) {
        super.setArc(rect, angSt, angExt, closure);
        this.makeDirty();
    }

    @Override
    public void setArc(Arc2D a) {
        super.setArc(a);
        this.makeDirty();
    }

    @Override
    public void setArcByCenter(double x, double y, double radius, double angSt, double angExt, int closure) {
        super.setArcByCenter(x, y, radius, angSt, angExt, closure);
        this.makeDirty();
    }

    @Override
    public void setArcByTangent(Point2D p1, Point2D p2, Point2D p3, double radius) {
        super.setArcByTangent(p1, p2, p3, radius);
        this.makeDirty();
    }

    @Override
    public void setAngleStart(Point2D p) {
        super.setAngleStart(p);
        this.makeDirty();
    }

    @Override
    public void setAngles(double x1, double y1, double x2, double y2) {
        super.setAngles(x1, y1, x2, y2);
        this.makeDirty();
    }

    @Override
    public void setAngles(Point2D p1, Point2D p2) {
        super.setAngles(p1, p2);
        this.makeDirty();
    }

    @Override
    public void setArcType(int type) {
        super.setArcType(type);
        this.makeDirty();
    }

    @Override
    public void setFrame(double x, double y, double w, double h) {
        super.setFrame(x, y, w, h);
        this.makeDirty();
    }

    @Override
    public void setFrame(Point2D loc, Dimension2D size) {
        super.setFrame(loc, size);
        this.makeDirty();
    }

    @Override
    public void setFrame(Rectangle2D r) {
        super.setFrame(r);
        this.makeDirty();
    }

    @Override
    public void setFrameFromDiagonal(double x1, double y1, double x2, double y2) {
        super.setFrameFromDiagonal(x1, y1, x2, y2);
        this.makeDirty();
    }

    @Override
    public void setFrameFromDiagonal(Point2D p1, Point2D p2) {
        super.setFrameFromDiagonal(p1, p2);
        this.makeDirty();
    }

    @Override
    public void setFrameFromCenter(double centerX, double centerY, double cornerX, double cornerY) {
        super.setFrameFromCenter(centerX, centerY, cornerX, cornerY);
        this.makeDirty();
    }

    @Override
    public void setFrameFromCenter(Point2D center, Point2D corner) {
        super.setFrameFromCenter(center, corner);
        this.makeDirty();
    }
}

