/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.expression.GeometryExpression;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMethodHelper;

public class SpatialBoundaryMethod2
implements SQLMethod {
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List args) {
        if (expr == null && (args == null || args.size() != 1)) {
            throw new NucleusUserException("Cannot invoke Spatial.boundary without 1 argument");
        }
        if (expr != null && args != null && args.size() != 0) {
            throw new NucleusUserException("Cannot invoke geom.getBoundary() with an argument");
        }
        SQLExpression argExpr = expr;
        if (expr == null) {
            argExpr = (SQLExpression)args.get(0);
        }
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        ArrayList<SQLExpression> geomFuncArgs = new ArrayList<SQLExpression>();
        geomFuncArgs.add(argExpr);
        GeometryExpression geomExpr = new GeometryExpression(stmt, null, "geometry.from_sdo_geom", geomFuncArgs, null);
        ArrayList<GeometryExpression> geomEnvFuncArgs = new ArrayList<GeometryExpression>();
        geomEnvFuncArgs.add(geomExpr);
        GeometryExpression geomEnvExpr = new GeometryExpression(stmt, null, "boundary", geomEnvFuncArgs, null);
        ArrayList<GeometryExpression> funcArgs = new ArrayList<GeometryExpression>();
        funcArgs.add(geomEnvExpr);
        JavaTypeMapping geomMapping = SpatialMethodHelper.getGeometryMapping(clr, argExpr);
        return new GeometryExpression(stmt, geomMapping, "geometry.get_sdo_geom", funcArgs, null);
    }
}

