/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping.jts;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.ColumnMappingPostSet;
import org.datanucleus.store.rdbms.mapping.column.OracleBlobColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.NucleusLogger;

public class GeometryMapping
extends SingleFieldMultiMapping {
    private static WKTReader wktReader;
    private boolean mapUserdataObject = false;

    protected static final Geometry createGeom(String wkt) {
        if (wktReader == null) {
            wktReader = new WKTReader();
        }
        try {
            return wktReader.read(wkt);
        }
        catch (ParseException e) {
            throw new Error("AssertionError: Illegal sampleValue", e);
        }
    }

    public String getJavaTypeForColumnMapping(int index) {
        return this.getJavaType().getName();
    }

    public boolean representableAsStringLiteralInStatement() {
        return false;
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns(this.getJavaType().getName());
    }

    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        super.initialize(mmd, table, clr);
        this.addColumns(this.getJavaType().getName());
        String mappingExtension = MetaDataUtils.getValueForExtensionRecursively((MetaData)mmd, (String)"mapping");
        if (mappingExtension != null && mappingExtension.equalsIgnoreCase("no-userdata")) {
            this.mapUserdataObject = false;
        } else {
            this.mapUserdataObject = true;
            this.addColumns(ClassNameConstants.JAVA_IO_SERIALIZABLE);
        }
    }

    public Class getJavaType() {
        return Geometry.class;
    }

    public Object getObject(ExecutionContext ec, ResultSet rs, int[] exprIndex, ObjectProvider ownerSM, int ownerFieldNumber) {
        return this.getObject(ec, rs, exprIndex);
    }

    public Object getObject(ExecutionContext ec, ResultSet datastoreResults, int[] exprIndex) {
        Geometry geom = (Geometry)this.getColumnMapping(0).getObject(datastoreResults, exprIndex[0]);
        if (geom == null) {
            return null;
        }
        if (this.mapUserdataObject) {
            Object userData = this.getColumnMapping(1).getObject(datastoreResults, exprIndex[1]);
            geom.setUserData(userData);
        }
        return geom;
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value, ObjectProvider ownerSM, int ownerFieldNumber) {
        this.setObject(ec, ps, exprIndex, value);
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        Geometry geom = (Geometry)value;
        if (geom == null) {
            this.getColumnMapping(0).setObject(ps, exprIndex[0], null);
            if (exprIndex.length == 2) {
                this.getColumnMapping(1).setObject(ps, exprIndex[1], null);
            }
        } else {
            ColumnMapping mapping;
            this.getColumnMapping(0).setObject(ps, exprIndex[0], (Object)geom);
            if (exprIndex.length == 2 && (mapping = this.getColumnMapping(1)).insertValuesOnInsert()) {
                this.getColumnMapping(1).setObject(ps, exprIndex[1], geom.getUserData());
            }
        }
    }

    public void setValuePostProcessing(ObjectProvider op) {
        if (!this.mapUserdataObject || !(this.columnMappings[1] instanceof OracleBlobColumnMapping)) {
            return;
        }
        Object geom = op.provideField(this.mmd.getAbsoluteFieldNumber());
        if (geom == null || !(geom instanceof Geometry) || ((Geometry)geom).getUserData() == null) {
            return;
        }
        Object value = ((Geometry)geom).getUserData();
        byte[] bytes = new byte[]{};
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            bytes = baos.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((ColumnMappingPostSet)this.columnMappings[1]).setPostProcessing(op, (Object)bytes);
    }

    public GeometryMapping getMappingWithoutUserData() {
        try {
            GeometryMapping geomMapping = (GeometryMapping)((Object)((Object)((Object)this)).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            geomMapping.storeMgr = this.storeMgr;
            geomMapping.type = this.type;
            geomMapping.mmd = this.mmd;
            geomMapping.mapUserdataObject = this.mapUserdataObject;
            geomMapping.table = this.table;
            geomMapping.columnMappings = new ColumnMapping[1];
            geomMapping.columnMappings[0] = this.columnMappings[0];
            return geomMapping;
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.info((Object)"Exception creating copy of mapping without user-data", (Throwable)e);
            return this;
        }
    }
}

