/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.types.geospatial.rdbms.mapping.RectangleMapping;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.RectangleComponentMapping;

public abstract class RectangleComponentMethod
implements SQLMethod {
    public SQLExpression getExpressionForMapping(SQLStatement stmt, SQLExpression expr, List args, int mappingIndex) {
        if (expr == null || args != null && !args.isEmpty()) {
            throw new NucleusUserException("Cannot invoke Rectangle.getX/getY/getWidth/getHeight on null object");
        }
        ColumnMapping colMapping = expr.getJavaTypeMapping().getColumnMapping(0);
        JavaTypeMapping javaTypeMapping = colMapping.getJavaTypeMapping();
        if (!(javaTypeMapping instanceof RectangleMapping)) {
            throw new NucleusException("Can only be used with 'RectangleMapping' Java Type mappings.");
        }
        RectangleMapping rectMapping = (RectangleMapping)javaTypeMapping;
        RectangleComponentMapping rectCmptMapping = new RectangleComponentMapping(rectMapping, mappingIndex);
        return new NumericExpression(stmt, expr.getSQLTable(), (JavaTypeMapping)rectCmptMapping);
    }
}

