/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping;

import java.awt.geom.Ellipse2D;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class Ellipse2dDoubleMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        super.initialize(fmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
    }

    public Class getJavaType() {
        return Ellipse2D.Double.class;
    }

    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        Ellipse2D.Double el = (Ellipse2D.Double)value;
        if (index == 0) {
            return el.getX();
        }
        if (index == 1) {
            return el.getY();
        }
        if (index == 2) {
            return el.getWidth();
        }
        if (index == 3) {
            return el.getHeight();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        Ellipse2D ellipse = (Ellipse2D)value;
        if (ellipse == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getColumnMapping(i).setObject(ps, exprIndex[i], null);
            }
        } else {
            this.getColumnMapping(0).setDouble(ps, exprIndex[0], ellipse.getX());
            this.getColumnMapping(1).setDouble(ps, exprIndex[1], ellipse.getY());
            this.getColumnMapping(2).setDouble(ps, exprIndex[2], ellipse.getWidth());
            this.getColumnMapping(3).setDouble(ps, exprIndex[3], ellipse.getHeight());
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.getColumnMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        double x = this.getColumnMapping(0).getDouble(resultSet, exprIndex[0]);
        double y = this.getColumnMapping(1).getDouble(resultSet, exprIndex[1]);
        double width = this.getColumnMapping(2).getDouble(resultSet, exprIndex[2]);
        double height = this.getColumnMapping(3).getDouble(resultSet, exprIndex[3]);
        return new Ellipse2D.Double(x, y, width, height);
    }
}

