/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;

public class SpatialDistanceMethod
implements SQLMethod {
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List args) {
        if (args == null) {
            throw new NucleusUserException("Cannot invoke Spatial.distance without arguments");
        }
        if (expr == null && args.size() != 2) {
            throw new NucleusUserException("Cannot invoke Spatial.distance without 2 arguments");
        }
        if (expr != null && args.size() != 1) {
            throw new NucleusUserException("Cannot invoke geom.distance without 1 argument");
        }
        SQLExpression argExpr1 = null;
        SQLExpression argExpr2 = null;
        if (expr == null) {
            argExpr1 = (SQLExpression)args.get(0);
            argExpr2 = (SQLExpression)args.get(1);
        } else {
            argExpr1 = expr;
            argExpr2 = (SQLExpression)args.get(0);
        }
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        funcArgs.add(argExpr1);
        funcArgs.add(argExpr2);
        JavaTypeMapping m = stmt.getSQLExpressionFactory().getMappingForType(Double.TYPE);
        return new NumericExpression(stmt, m, "Distance", funcArgs);
    }
}

