/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.converters;

import java.awt.geom.RoundRectangle2D;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class RoundRectangle2dFloatStringConverter
implements TypeConverter<RoundRectangle2D.Float, String> {
    public RoundRectangle2D.Float toMemberType(String str) {
        if (str == null) {
            return null;
        }
        RoundRectangle2D.Float r = new RoundRectangle2D.Float();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        float x = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                x = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, RoundRectangle2D.Float.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        float y = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                y = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, RoundRectangle2D.Float.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        float width = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                width = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, RoundRectangle2D.Float.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        float height = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                height = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, RoundRectangle2D.Float.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        float arcwidth = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                arcwidth = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, RoundRectangle2D.Float.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        float archeight = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                archeight = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, RoundRectangle2D.Float.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        r.setRoundRect(x, y, width, height, arcwidth, archeight);
        return r;
    }

    public String toDatastoreType(RoundRectangle2D.Float rect) {
        return rect != null ? "(" + rect.getX() + "," + rect.getY() + "," + rect.getWidth() + "," + rect.getHeight() + "," + rect.arcwidth + "," + rect.archeight + ")" : null;
    }
}

