/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.converters;

import java.awt.geom.Point2D;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class Point2dFloatStringConverter
implements TypeConverter<Point2D.Float, String> {
    public Point2D.Float toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Point2D.Float p = new Point2D.Float();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        float x = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                x = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, Point2D.Float.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        float y = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                y = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, Point2D.Float.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        p.setLocation(x, y);
        return p;
    }

    public String toDatastoreType(Point2D.Float p) {
        return p != null ? "(" + p.getX() + "," + p.getY() + ")" : null;
    }
}

