/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.converters;

import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class Rectangle2dFloatStringConverter
implements TypeConverter<Rectangle2D.Float, String> {
    public Rectangle2D.Float toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Rectangle2D.Float r = new Rectangle2D.Float();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        float x = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                x = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle2D.Float.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        float y = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                y = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle2D.Float.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        float width = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                width = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle2D.Float.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        float height = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                height = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle2D.Float.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        r.setRect(x, y, width, height);
        return r;
    }

    public String toDatastoreType(Rectangle2D.Float rect) {
        return rect != null ? "(" + rect.getX() + "," + rect.getY() + "," + rect.getWidth() + "," + rect.getHeight() + ")" : null;
    }
}

